/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jwa;

import io.inverno.mod.security.jose.internal.JOSEUtils;
import io.inverno.mod.security.jose.internal.jwa.AbstractECDH_ESKeyManager;
import io.inverno.mod.security.jose.internal.jwk.ec.GenericECJWK;
import io.inverno.mod.security.jose.jwa.ECAlgorithm;
import io.inverno.mod.security.jose.jwa.ECCurve;
import io.inverno.mod.security.jose.jwa.JWAProcessingException;
import io.inverno.mod.security.jose.jwk.ec.ECJWK;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class ECDH_ESKeyManager
extends AbstractECDH_ESKeyManager<ECPublicKey, ECPrivateKey, ECJWK, ECAlgorithm> {
    public static final Set<ECAlgorithm> SUPPORTED_ALGORITHMS = Set.of(ECAlgorithm.ECDH_ES);
    private ECCurve curve;

    public ECDH_ESKeyManager(ECJWK jwk, ECAlgorithm algorithm) throws JWAProcessingException {
        super(jwk, algorithm);
        if (!SUPPORTED_ALGORITHMS.contains(algorithm)) {
            throw new JWAProcessingException("Unsupported algorithm: " + algorithm.getAlgorithm());
        }
        this.init();
    }

    public ECDH_ESKeyManager(ECJWK jwk) {
        super(jwk);
    }

    @Override
    protected final void init() throws JWAProcessingException {
        this.curve = ECCurve.fromCurve(((ECJWK)this.jwk).getCurve());
    }

    @Override
    protected String getKeyAgreementAlgorithm() {
        return "ECDH";
    }

    @Override
    protected ECJWK getEPK(Map<String, Object> parameters) throws JWAProcessingException {
        Object epk_obj;
        Object object = epk_obj = parameters != null ? parameters.get("epk") : null;
        if (epk_obj != null) {
            if (epk_obj instanceof ECJWK) {
                return (ECJWK)epk_obj;
            }
            if (epk_obj instanceof Map) {
                Map epk = (Map)epk_obj;
                String kty = (String)epk.get("kty");
                String crv = (String)epk.get("crv");
                String x = (String)epk.get("x");
                String y = (String)epk.get("y");
                if (kty == null || !"EC".equals(kty)) {
                    throw new JWAProcessingException("Invalid ephemeral key type: " + kty);
                }
                if (crv == null) {
                    throw new JWAProcessingException("Missing curve in ephemeral key");
                }
                if (!this.curve.getCurve().equals(crv)) {
                    throw new JWAProcessingException("Curve " + crv + " in ephemeral key is not consistent with expected curve " + this.curve.getCurve());
                }
                if (StringUtils.isBlank((CharSequence)x)) {
                    throw new JWAProcessingException("X is blank in ephemeral key");
                }
                if (StringUtils.isBlank((CharSequence)y)) {
                    throw new JWAProcessingException("Y is blank in ephemeral key");
                }
                return new GenericECJWK(this.curve, x, y);
            }
            throw new JWAProcessingException("Invalid EPK type: " + String.valueOf(epk_obj.getClass()));
        }
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("EC");
            keyPairGenerator.initialize(new ECGenParameterSpec(this.curve.getJCAName()));
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            ECPublicKey publicKey = (ECPublicKey)keyPair.getPublic();
            ECPrivateKey privateKey = (ECPrivateKey)keyPair.getPrivate();
            return new GenericECJWK(this.curve, JOSEUtils.BASE64_NOPAD_URL_ENCODER.encodeToString(JOSEUtils.toPaddedUnsignedBytes(publicKey.getW().getAffineX(), this.curve.getKeyLength())), JOSEUtils.BASE64_NOPAD_URL_ENCODER.encodeToString(JOSEUtils.toPaddedUnsignedBytes(publicKey.getW().getAffineY(), this.curve.getKeyLength())), JOSEUtils.BASE64_NOPAD_URL_ENCODER.encodeToString(JOSEUtils.toPaddedUnsignedBytes(privateKey.getS(), this.curve.getKeyLength())));
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException e) {
            throw new JWAProcessingException("Error generating ephemeral key", e);
        }
    }
}

