/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jwa;

import io.inverno.mod.security.jose.internal.JOSEUtils;
import io.inverno.mod.security.jose.internal.jwa.AbstractJWA;
import io.inverno.mod.security.jose.jwa.JWACipher;
import io.inverno.mod.security.jose.jwa.JWACipherException;
import io.inverno.mod.security.jose.jwa.JWAProcessingException;
import io.inverno.mod.security.jose.jwa.OCTAlgorithm;
import io.inverno.mod.security.jose.jwk.oct.OCTJWK;
import java.security.SecureRandom;

public abstract class AbstractJWACipher
extends AbstractJWA
implements JWACipher {
    protected final OCTJWK jwk;
    protected OCTAlgorithm algorithm;

    public AbstractJWACipher(OCTJWK jwk, OCTAlgorithm algorithm) throws JWAProcessingException {
        if (!algorithm.isEncryption()) {
            throw new JWAProcessingException("Not an encryption algorithm: " + algorithm.getAlgorithm());
        }
        this.jwk = jwk;
        this.algorithm = algorithm;
    }

    protected AbstractJWACipher(OCTJWK jwk) {
        this.jwk = jwk;
    }

    @Override
    public JWACipher.EncryptedData encrypt(byte[] data, byte[] aad, SecureRandom secureRandom) throws JWACipherException {
        if (this.jwk.getKeyOperations() != null && !this.jwk.getKeyOperations().contains("encrypt")) {
            throw new JWACipherException("JWK does not support encrypt operation");
        }
        return this.doEncrypt(data, aad, secureRandom != null ? secureRandom : JOSEUtils.DEFAULT_SECURE_RANDOM);
    }

    protected abstract JWACipher.EncryptedData doEncrypt(byte[] var1, byte[] var2, SecureRandom var3) throws JWACipherException;

    @Override
    public byte[] decrypt(byte[] data, byte[] cipherText, byte[] iv, byte[] tag) throws JWACipherException {
        if (this.jwk.getKeyOperations() != null && !this.jwk.getKeyOperations().contains("decrypt")) {
            throw new JWACipherException("JWK does not support decrypt operation");
        }
        return this.doDecrypt(data, cipherText, iv, tag);
    }

    protected abstract byte[] doDecrypt(byte[] var1, byte[] var2, byte[] var3, byte[] var4) throws JWACipherException;
}

