/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.converter;

import io.inverno.core.annotation.Bean;
import io.inverno.mod.base.converter.MediaTypeConverter;
import io.inverno.mod.base.resource.MediaTypes;
import io.inverno.mod.security.jose.internal.converter.DataConversionService;
import io.inverno.mod.security.jose.internal.converter.JOSEMediaTypeConverter;
import io.inverno.mod.security.jose.jwe.JWEService;
import io.inverno.mod.security.jose.jws.JWSService;
import io.inverno.mod.security.jose.jwt.JWTService;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;

@Bean(name="dataConversionService", visibility=Bean.Visibility.PRIVATE)
public class GenericDataConversionService
implements DataConversionService {
    private final List<MediaTypeConverter<String>> converters;
    private final Map<String, MediaTypeConverter<String>> convertersCache = new HashMap<String, MediaTypeConverter<String>>();

    public GenericDataConversionService(List<MediaTypeConverter<String>> converters) {
        LinkedList<MediaTypeConverter<String>> tmpConverters = new LinkedList<MediaTypeConverter<String>>(converters);
        int end = tmpConverters.size();
        for (int i = 0; i < end; ++i) {
            MediaTypeConverter<String> current = tmpConverters.get(i);
            if (!(current instanceof JOSEMediaTypeConverter)) continue;
            tmpConverters.remove(i);
            tmpConverters.add(current);
            --i;
            --end;
        }
        this.converters = tmpConverters;
    }

    public void injectJWSService(JWSService jwsService) {
        for (MediaTypeConverter<String> converter : this.converters) {
            if (!(converter instanceof JOSEMediaTypeConverter)) continue;
            ((JOSEMediaTypeConverter)converter).injectJWSService(jwsService);
        }
    }

    public void injectJWEService(JWEService jweService) {
        for (MediaTypeConverter<String> converter : this.converters) {
            if (!(converter instanceof JOSEMediaTypeConverter)) continue;
            ((JOSEMediaTypeConverter)converter).injectJWEService(jweService);
        }
    }

    public void injectJWTService(JWTService jwtService) {
        for (MediaTypeConverter<String> converter : this.converters) {
            if (!(converter instanceof JOSEMediaTypeConverter)) continue;
            ((JOSEMediaTypeConverter)converter).injectJWTService(jwtService);
        }
    }

    @Override
    public Optional<MediaTypeConverter<String>> getConverter(String mediaType) {
        String normalizedMediaType = MediaTypes.normalizeApplicationMediaType((String)mediaType);
        MediaTypeConverter<String> result = this.convertersCache.get(normalizedMediaType);
        if (result == null && !this.convertersCache.containsKey(normalizedMediaType)) {
            for (MediaTypeConverter<String> converter : this.converters) {
                if (!converter.canConvert(normalizedMediaType)) continue;
                this.convertersCache.put(normalizedMediaType, converter);
                result = converter;
                break;
            }
            if (result == null) {
                this.convertersCache.put(normalizedMediaType, null);
            }
        }
        return Optional.ofNullable(result);
    }

    @Bean(name="mediaTypeConverters")
    public static interface MediaTypeConvertersSocket
    extends Supplier<List<MediaTypeConverter<String>>> {
    }
}

