/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.inverno.core.v1.Module;
import io.inverno.mod.base.converter.MediaTypeConverter;
import io.inverno.mod.base.resource.ResourceService;
import io.inverno.mod.security.jose.JOSEConfiguration;
import io.inverno.mod.security.jose.JOSEConfigurationLoader;
import io.inverno.mod.security.jose.internal.JOSEObjectMapper;
import io.inverno.mod.security.jose.internal.WorkerPool;
import io.inverno.mod.security.jose.internal.converter.GenericDataConversionService;
import io.inverno.mod.security.jose.internal.converter.JOSEJsonStringMediaTypeConverter;
import io.inverno.mod.security.jose.internal.converter.JOSEStringMediaTypeConverter;
import io.inverno.mod.security.jose.internal.converter.JWKJsonMediaTypeConverter;
import io.inverno.mod.security.jose.internal.converter.JWKSetJsonMediaTypeConverter;
import io.inverno.mod.security.jose.internal.converter.JWTStringMediaTypeConverter;
import io.inverno.mod.security.jose.internal.jwe.DeflateJWEZip;
import io.inverno.mod.security.jose.internal.jwe.GenericJWEService;
import io.inverno.mod.security.jose.internal.jwk.GenericJWKKeyResolver;
import io.inverno.mod.security.jose.internal.jwk.GenericJWKService;
import io.inverno.mod.security.jose.internal.jwk.GenericJWKStore;
import io.inverno.mod.security.jose.internal.jwk.GenericJWKURLResolver;
import io.inverno.mod.security.jose.internal.jwk.GenericX509JWKCertPathValidator;
import io.inverno.mod.security.jose.internal.jwk.SwitchableJWKURLResolver;
import io.inverno.mod.security.jose.internal.jwk.ec.GenericECJWKFactory;
import io.inverno.mod.security.jose.internal.jwk.oct.GenericOCTJWKFactory;
import io.inverno.mod.security.jose.internal.jwk.okp.GenericEdECJWKFactory;
import io.inverno.mod.security.jose.internal.jwk.okp.GenericXECJWKFactory;
import io.inverno.mod.security.jose.internal.jwk.pbes2.GenericPBES2JWKFactory;
import io.inverno.mod.security.jose.internal.jwk.rsa.GenericRSAJWKFactory;
import io.inverno.mod.security.jose.internal.jws.GenericJWSService;
import io.inverno.mod.security.jose.internal.jwt.GenericJWTService;
import io.inverno.mod.security.jose.jwe.JWEService;
import io.inverno.mod.security.jose.jwe.JWEZip;
import io.inverno.mod.security.jose.jwk.JWKFactory;
import io.inverno.mod.security.jose.jwk.JWKKeyResolver;
import io.inverno.mod.security.jose.jwk.JWKPKIXParameters;
import io.inverno.mod.security.jose.jwk.JWKService;
import io.inverno.mod.security.jose.jwk.JWKStore;
import io.inverno.mod.security.jose.jwk.JWKURLResolver;
import io.inverno.mod.security.jose.jwk.X509JWKCertPathValidator;
import io.inverno.mod.security.jose.jws.JWSService;
import io.inverno.mod.security.jose.jwt.JWTService;
import java.security.cert.PKIXParameters;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;

public final class Jose
extends Module {
    private Module.Bean<JOSEConfiguration> configuration;
    private Module.Bean<GenericDataConversionService> dataConversionService;
    private Module.Bean<DeflateJWEZip> deflateJWEZip;
    private Module.Bean<GenericECJWKFactory> genericECJWKFactory;
    private Module.Bean<GenericEdECJWKFactory> genericEdECJWKFactory;
    private Module.Bean<GenericOCTJWKFactory> genericOCTJWKFactory;
    private Module.Bean<GenericPBES2JWKFactory> genericPBES2JWKFactory;
    private Module.Bean<GenericRSAJWKFactory> genericRSAJWKFactory;
    private Module.Bean<GenericXECJWKFactory> genericXECJWKFactory;
    private Module.Bean<JOSEJsonStringMediaTypeConverter> joseJsonStringMediaTypeConverter;
    private Module.Bean<JOSEStringMediaTypeConverter> joseStringMediaTypeConverter;
    private Module.Bean<GenericJWEService> jweService;
    private Module.Bean<JWKJsonMediaTypeConverter> jwkJsonMediaTypeConverter;
    private Module.Bean<JWKKeyResolver> jwkKeyResolver;
    private Module.Bean<PKIXParameters> jwkPKIXParameters;
    private Module.Bean<GenericJWKService> jwkService;
    private Module.Bean<JWKSetJsonMediaTypeConverter> jwkSetJsonMediaTypeConverter;
    private Module.Bean<JWKStore> jwkStore;
    private Module.Bean<JWKURLResolver> jwkURLResolver;
    private Module.Bean<X509JWKCertPathValidator> jwkX509CertPathValidator;
    private Module.Bean<GenericJWSService> jwsService;
    private Module.Bean<GenericJWTService> jwtService;
    private Module.Bean<JWTStringMediaTypeConverter> jwtStringMediaTypeConverter;
    private Module.Bean<ObjectMapper> objectMapper;
    private Module.Bean<SwitchableJWKURLResolver> switchableJWKURLResolver;
    private Module.Bean<ExecutorService> workerPool;

    private Jose(@Module.Socket(name="jweZips", wiredTo={"dataConversionService", "genericRSAJWKFactory", "objectMapper", "joseJsonStringMediaTypeConverter", "jwkSetJsonMediaTypeConverter", "genericOCTJWKFactory", "jwkURLResolver", "genericXECJWKFactory", "jwkPKIXParameters", "genericPBES2JWKFactory", "jwtService", "jwkJsonMediaTypeConverter", "jwsService", "jweService", "jwkService", "workerPool", "genericECJWKFactory", "genericEdECJWKFactory", "switchableJWKURLResolver", "jwkStore", "jwkKeyResolver", "jwkX509CertPathValidator", "configuration", "jwtStringMediaTypeConverter", "joseStringMediaTypeConverter"}) Optional<Supplier<List<JWEZip>>> jweZips, @Module.Socket(name="jwkFactories", wiredTo={"dataConversionService", "genericRSAJWKFactory", "objectMapper", "joseJsonStringMediaTypeConverter", "jwkSetJsonMediaTypeConverter", "genericOCTJWKFactory", "jwkURLResolver", "genericXECJWKFactory", "jwkPKIXParameters", "genericPBES2JWKFactory", "jwtService", "jwkJsonMediaTypeConverter", "jwsService", "jweService", "jwkService", "workerPool", "genericECJWKFactory", "genericEdECJWKFactory", "switchableJWKURLResolver", "jwkStore", "jwkKeyResolver", "jwkX509CertPathValidator", "configuration", "jwtStringMediaTypeConverter", "joseStringMediaTypeConverter"}) Optional<Supplier<List<JWKFactory<?, ?, ?>>>> jwkFactories, @Module.Socket(name="mediaTypeConverters", wiredTo={"dataConversionService", "genericRSAJWKFactory", "objectMapper", "joseJsonStringMediaTypeConverter", "jwkSetJsonMediaTypeConverter", "genericOCTJWKFactory", "jwkURLResolver", "genericXECJWKFactory", "jwkPKIXParameters", "genericPBES2JWKFactory", "jwtService", "jwkJsonMediaTypeConverter", "jwsService", "jweService", "jwkService", "workerPool", "genericECJWKFactory", "genericEdECJWKFactory", "switchableJWKURLResolver", "jwkStore", "jwkKeyResolver", "jwkX509CertPathValidator", "configuration", "jwtStringMediaTypeConverter", "joseStringMediaTypeConverter"}) Supplier<List<MediaTypeConverter<String>>> mediaTypeConverters, @Module.Socket(name="resourceService", wiredTo={"dataConversionService", "genericRSAJWKFactory", "objectMapper", "joseJsonStringMediaTypeConverter", "jwkSetJsonMediaTypeConverter", "genericOCTJWKFactory", "jwkURLResolver", "genericXECJWKFactory", "jwkPKIXParameters", "genericPBES2JWKFactory", "jwtService", "jwkJsonMediaTypeConverter", "jwsService", "jweService", "jwkService", "workerPool", "genericECJWKFactory", "genericEdECJWKFactory", "switchableJWKURLResolver", "jwkStore", "jwkKeyResolver", "jwkX509CertPathValidator", "configuration", "jwtStringMediaTypeConverter", "joseStringMediaTypeConverter"}) Optional<Supplier<ResourceService>> resourceService, @Module.Socket(name="configuration", wiredTo={"dataConversionService", "genericRSAJWKFactory", "objectMapper", "joseJsonStringMediaTypeConverter", "jwkSetJsonMediaTypeConverter", "genericOCTJWKFactory", "jwkURLResolver", "genericXECJWKFactory", "jwkPKIXParameters", "genericPBES2JWKFactory", "jwtService", "jwkJsonMediaTypeConverter", "jwsService", "jweService", "jwkService", "workerPool", "genericECJWKFactory", "genericEdECJWKFactory", "switchableJWKURLResolver", "jwkStore", "jwkKeyResolver", "jwkX509CertPathValidator", "configuration", "jwtStringMediaTypeConverter", "joseStringMediaTypeConverter"}) Optional<Supplier<JOSEConfiguration>> configurationOverride, @Module.Socket(name="jwkKeyResolver", wiredTo={"dataConversionService", "genericRSAJWKFactory", "objectMapper", "joseJsonStringMediaTypeConverter", "jwkSetJsonMediaTypeConverter", "genericOCTJWKFactory", "jwkURLResolver", "genericXECJWKFactory", "jwkPKIXParameters", "genericPBES2JWKFactory", "jwtService", "jwkJsonMediaTypeConverter", "jwsService", "jweService", "jwkService", "workerPool", "genericECJWKFactory", "genericEdECJWKFactory", "switchableJWKURLResolver", "jwkStore", "jwkKeyResolver", "jwkX509CertPathValidator", "configuration", "jwtStringMediaTypeConverter", "joseStringMediaTypeConverter"}) Optional<Supplier<JWKKeyResolver>> jwkKeyResolverOverride, @Module.Socket(name="jwkPKIXParameters", wiredTo={"dataConversionService", "genericRSAJWKFactory", "objectMapper", "joseJsonStringMediaTypeConverter", "jwkSetJsonMediaTypeConverter", "genericOCTJWKFactory", "jwkURLResolver", "genericXECJWKFactory", "jwkPKIXParameters", "genericPBES2JWKFactory", "jwtService", "jwkJsonMediaTypeConverter", "jwsService", "jweService", "jwkService", "workerPool", "genericECJWKFactory", "genericEdECJWKFactory", "switchableJWKURLResolver", "jwkStore", "jwkKeyResolver", "jwkX509CertPathValidator", "configuration", "jwtStringMediaTypeConverter", "joseStringMediaTypeConverter"}) Optional<Supplier<PKIXParameters>> jwkPKIXParametersOverride, @Module.Socket(name="jwkStore", wiredTo={"dataConversionService", "genericRSAJWKFactory", "objectMapper", "joseJsonStringMediaTypeConverter", "jwkSetJsonMediaTypeConverter", "genericOCTJWKFactory", "jwkURLResolver", "genericXECJWKFactory", "jwkPKIXParameters", "genericPBES2JWKFactory", "jwtService", "jwkJsonMediaTypeConverter", "jwsService", "jweService", "jwkService", "workerPool", "genericECJWKFactory", "genericEdECJWKFactory", "switchableJWKURLResolver", "jwkStore", "jwkKeyResolver", "jwkX509CertPathValidator", "configuration", "jwtStringMediaTypeConverter", "joseStringMediaTypeConverter"}) Optional<Supplier<JWKStore>> jwkStoreOverride, @Module.Socket(name="jwkURLResolver", wiredTo={"dataConversionService", "genericRSAJWKFactory", "objectMapper", "joseJsonStringMediaTypeConverter", "jwkSetJsonMediaTypeConverter", "genericOCTJWKFactory", "jwkURLResolver", "genericXECJWKFactory", "jwkPKIXParameters", "genericPBES2JWKFactory", "jwtService", "jwkJsonMediaTypeConverter", "jwsService", "jweService", "jwkService", "workerPool", "genericECJWKFactory", "genericEdECJWKFactory", "switchableJWKURLResolver", "jwkStore", "jwkKeyResolver", "jwkX509CertPathValidator", "configuration", "jwtStringMediaTypeConverter", "joseStringMediaTypeConverter"}) Optional<Supplier<JWKURLResolver>> jwkURLResolverOverride, @Module.Socket(name="jwkX509CertPathValidator", wiredTo={"dataConversionService", "genericRSAJWKFactory", "objectMapper", "joseJsonStringMediaTypeConverter", "jwkSetJsonMediaTypeConverter", "genericOCTJWKFactory", "jwkURLResolver", "genericXECJWKFactory", "jwkPKIXParameters", "genericPBES2JWKFactory", "jwtService", "jwkJsonMediaTypeConverter", "jwsService", "jweService", "jwkService", "workerPool", "genericECJWKFactory", "genericEdECJWKFactory", "switchableJWKURLResolver", "jwkStore", "jwkKeyResolver", "jwkX509CertPathValidator", "configuration", "jwtStringMediaTypeConverter", "joseStringMediaTypeConverter"}) Optional<Supplier<X509JWKCertPathValidator>> jwkX509CertPathValidatorOverride, @Module.Socket(name="objectMapper", wiredTo={"dataConversionService", "genericRSAJWKFactory", "objectMapper", "joseJsonStringMediaTypeConverter", "jwkSetJsonMediaTypeConverter", "genericOCTJWKFactory", "jwkURLResolver", "genericXECJWKFactory", "jwkPKIXParameters", "genericPBES2JWKFactory", "jwtService", "jwkJsonMediaTypeConverter", "jwsService", "jweService", "jwkService", "workerPool", "genericECJWKFactory", "genericEdECJWKFactory", "switchableJWKURLResolver", "jwkStore", "jwkKeyResolver", "jwkX509CertPathValidator", "configuration", "jwtStringMediaTypeConverter", "joseStringMediaTypeConverter"}) Optional<Supplier<ObjectMapper>> objectMapperOverride, @Module.Socket(name="workerPool", wiredTo={"dataConversionService", "genericRSAJWKFactory", "objectMapper", "joseJsonStringMediaTypeConverter", "jwkSetJsonMediaTypeConverter", "genericOCTJWKFactory", "jwkURLResolver", "genericXECJWKFactory", "jwkPKIXParameters", "genericPBES2JWKFactory", "jwtService", "jwkJsonMediaTypeConverter", "jwsService", "jweService", "jwkService", "workerPool", "genericECJWKFactory", "genericEdECJWKFactory", "switchableJWKURLResolver", "jwkStore", "jwkKeyResolver", "jwkX509CertPathValidator", "configuration", "jwtStringMediaTypeConverter", "joseStringMediaTypeConverter"}) Optional<Supplier<ExecutorService>> workerPoolOverride) {
        super("io.inverno.mod.security.jose");
        this.configuration = this.with(Module.WrapperBeanBuilder.singleton((String)"configuration", () -> {
            JOSEConfigurationLoader.Bean configuration = new JOSEConfigurationLoader.Bean();
            return configuration;
        }).override(configurationOverride));
        this.dataConversionService = this.with(Module.ModuleBeanBuilder.singleton((String)"dataConversionService", () -> {
            GenericDataConversionService dataConversionService = new GenericDataConversionService(new Module.BeanAggregator().add((Collection)mediaTypeConverters.get()).add((Object)((MediaTypeConverter)this.joseJsonStringMediaTypeConverter.get())).add((Object)((MediaTypeConverter)this.joseStringMediaTypeConverter.get())).add((Object)((MediaTypeConverter)this.jwkJsonMediaTypeConverter.get())).add((Object)((MediaTypeConverter)this.jwkSetJsonMediaTypeConverter.get())).add((Object)((MediaTypeConverter)this.jwtStringMediaTypeConverter.get())).toList());
            return dataConversionService;
        }));
        this.deflateJWEZip = this.with(Module.ModuleBeanBuilder.singleton((String)"deflateJWEZip", () -> {
            DeflateJWEZip deflateJWEZip = new DeflateJWEZip();
            return deflateJWEZip;
        }));
        this.genericECJWKFactory = this.with(Module.ModuleBeanBuilder.singleton((String)"genericECJWKFactory", () -> {
            GenericECJWKFactory genericECJWKFactory = new GenericECJWKFactory((JOSEConfiguration)this.configuration.get(), (JWKStore)this.jwkStore.get(), (JWKKeyResolver)this.jwkKeyResolver.get(), (ObjectMapper)this.objectMapper.get(), (SwitchableJWKURLResolver)this.switchableJWKURLResolver.get(), (X509JWKCertPathValidator)this.jwkX509CertPathValidator.get());
            return genericECJWKFactory;
        }));
        this.genericEdECJWKFactory = this.with(Module.ModuleBeanBuilder.singleton((String)"genericEdECJWKFactory", () -> {
            GenericEdECJWKFactory genericEdECJWKFactory = new GenericEdECJWKFactory((JOSEConfiguration)this.configuration.get(), (JWKStore)this.jwkStore.get(), (JWKKeyResolver)this.jwkKeyResolver.get(), (ObjectMapper)this.objectMapper.get(), (SwitchableJWKURLResolver)this.switchableJWKURLResolver.get(), (X509JWKCertPathValidator)this.jwkX509CertPathValidator.get());
            return genericEdECJWKFactory;
        }));
        this.genericOCTJWKFactory = this.with(Module.ModuleBeanBuilder.singleton((String)"genericOCTJWKFactory", () -> {
            GenericOCTJWKFactory genericOCTJWKFactory = new GenericOCTJWKFactory((JOSEConfiguration)this.configuration.get(), (JWKStore)this.jwkStore.get(), (JWKKeyResolver)this.jwkKeyResolver.get(), (ObjectMapper)this.objectMapper.get());
            return genericOCTJWKFactory;
        }));
        this.genericPBES2JWKFactory = this.with(Module.ModuleBeanBuilder.singleton((String)"genericPBES2JWKFactory", () -> {
            GenericPBES2JWKFactory genericPBES2JWKFactory = new GenericPBES2JWKFactory((JOSEConfiguration)this.configuration.get(), (JWKStore)this.jwkStore.get(), (JWKKeyResolver)this.jwkKeyResolver.get(), (ObjectMapper)this.objectMapper.get());
            return genericPBES2JWKFactory;
        }));
        this.genericRSAJWKFactory = this.with(Module.ModuleBeanBuilder.singleton((String)"genericRSAJWKFactory", () -> {
            GenericRSAJWKFactory genericRSAJWKFactory = new GenericRSAJWKFactory((JOSEConfiguration)this.configuration.get(), (JWKStore)this.jwkStore.get(), (JWKKeyResolver)this.jwkKeyResolver.get(), (ObjectMapper)this.objectMapper.get(), (SwitchableJWKURLResolver)this.switchableJWKURLResolver.get(), (X509JWKCertPathValidator)this.jwkX509CertPathValidator.get());
            return genericRSAJWKFactory;
        }));
        this.genericXECJWKFactory = this.with(Module.ModuleBeanBuilder.singleton((String)"genericXECJWKFactory", () -> {
            GenericXECJWKFactory genericXECJWKFactory = new GenericXECJWKFactory((JOSEConfiguration)this.configuration.get(), (JWKStore)this.jwkStore.get(), (JWKKeyResolver)this.jwkKeyResolver.get(), (ObjectMapper)this.objectMapper.get(), (SwitchableJWKURLResolver)this.switchableJWKURLResolver.get(), (X509JWKCertPathValidator)this.jwkX509CertPathValidator.get());
            return genericXECJWKFactory;
        }));
        this.joseJsonStringMediaTypeConverter = this.with(Module.ModuleBeanBuilder.singleton((String)"joseJsonStringMediaTypeConverter", () -> {
            JOSEJsonStringMediaTypeConverter joseJsonStringMediaTypeConverter = new JOSEJsonStringMediaTypeConverter();
            return joseJsonStringMediaTypeConverter;
        }));
        this.joseStringMediaTypeConverter = this.with(Module.ModuleBeanBuilder.singleton((String)"joseStringMediaTypeConverter", () -> {
            JOSEStringMediaTypeConverter joseStringMediaTypeConverter = new JOSEStringMediaTypeConverter();
            return joseStringMediaTypeConverter;
        }));
        this.jweService = this.with((Module.ModuleBeanBuilder)Module.ModuleBeanBuilder.singleton((String)"jweService", () -> {
            GenericJWEService jweService = new GenericJWEService((ObjectMapper)this.objectMapper.get(), (GenericDataConversionService)this.dataConversionService.get(), (JWKService)this.jwkService.get());
            new Module.BeanAggregator().add((Collection)jweZips.orElse(() -> null).get()).add((Object)((JWEZip)this.deflateJWEZip.get())).toOptionalList().ifPresent(jweService::setJWEZips);
            return jweService;
        }).init(GenericJWEService::init));
        this.jwkJsonMediaTypeConverter = this.with(Module.ModuleBeanBuilder.singleton((String)"jwkJsonMediaTypeConverter", () -> {
            JWKJsonMediaTypeConverter jwkJsonMediaTypeConverter = new JWKJsonMediaTypeConverter((JWKService)this.jwkService.get(), (ObjectMapper)this.objectMapper.get());
            return jwkJsonMediaTypeConverter;
        }));
        this.jwkKeyResolver = this.with(((Module.ModuleBeanBuilder)Module.ModuleBeanBuilder.singleton((String)"jwkKeyResolver", () -> {
            GenericJWKKeyResolver jwkKeyResolver = new GenericJWKKeyResolver((JOSEConfiguration)this.configuration.get());
            resourceService.map(Supplier::get).ifPresent(jwkKeyResolver::setResourceService);
            return jwkKeyResolver;
        }).init(GenericJWKKeyResolver::init)).override(jwkKeyResolverOverride));
        this.jwkPKIXParameters = this.with(Module.WrapperBeanBuilder.singleton((String)"jwkPKIXParameters", () -> {
            JWKPKIXParameters jwkPKIXParameters = new JWKPKIXParameters();
            return jwkPKIXParameters;
        }).override(jwkPKIXParametersOverride));
        this.jwkService = this.with(Module.ModuleBeanBuilder.singleton((String)"jwkService", () -> {
            GenericJWKService jwkService = new GenericJWKService((JOSEConfiguration)this.configuration.get(), (GenericECJWKFactory)this.genericECJWKFactory.get(), (GenericRSAJWKFactory)this.genericRSAJWKFactory.get(), (GenericOCTJWKFactory)this.genericOCTJWKFactory.get(), (GenericEdECJWKFactory)this.genericEdECJWKFactory.get(), (GenericXECJWKFactory)this.genericXECJWKFactory.get(), (GenericPBES2JWKFactory)this.genericPBES2JWKFactory.get(), (JWKStore)this.jwkStore.get(), (JWKURLResolver)this.jwkURLResolver.get(), (SwitchableJWKURLResolver)this.switchableJWKURLResolver.get(), (ObjectMapper)this.objectMapper.get());
            new Module.BeanAggregator().add((Collection)jwkFactories.orElse(() -> null).get()).add((Object)((JWKFactory)this.genericECJWKFactory.get())).add((Object)((JWKFactory)this.genericEdECJWKFactory.get())).add((Object)((JWKFactory)this.genericOCTJWKFactory.get())).add((Object)((JWKFactory)this.genericPBES2JWKFactory.get())).add((Object)((JWKFactory)this.genericRSAJWKFactory.get())).add((Object)((JWKFactory)this.genericXECJWKFactory.get())).toOptionalList().ifPresent(jwkService::setJWKFactories);
            return jwkService;
        }));
        this.jwkSetJsonMediaTypeConverter = this.with(Module.ModuleBeanBuilder.singleton((String)"jwkSetJsonMediaTypeConverter", () -> {
            JWKSetJsonMediaTypeConverter jwkSetJsonMediaTypeConverter = new JWKSetJsonMediaTypeConverter((JWKService)this.jwkService.get(), (ObjectMapper)this.objectMapper.get());
            return jwkSetJsonMediaTypeConverter;
        }));
        this.jwkStore = this.with(Module.WrapperBeanBuilder.singleton((String)"jwkStore", () -> {
            GenericJWKStore jwkStore = new GenericJWKStore();
            return jwkStore;
        }).override(jwkStoreOverride));
        this.jwkURLResolver = this.with(Module.ModuleBeanBuilder.singleton((String)"jwkURLResolver", () -> {
            GenericJWKURLResolver jwkURLResolver = new GenericJWKURLResolver((ObjectMapper)this.objectMapper.get());
            resourceService.map(Supplier::get).ifPresent(jwkURLResolver::setResourceService);
            return jwkURLResolver;
        }).override(jwkURLResolverOverride));
        this.jwkX509CertPathValidator = this.with(Module.ModuleBeanBuilder.singleton((String)"jwkX509CertPathValidator", () -> {
            GenericX509JWKCertPathValidator jwkX509CertPathValidator = new GenericX509JWKCertPathValidator((PKIXParameters)this.jwkPKIXParameters.get(), (ExecutorService)this.workerPool.get());
            return jwkX509CertPathValidator;
        }).override(jwkX509CertPathValidatorOverride));
        this.jwsService = this.with((Module.ModuleBeanBuilder)Module.ModuleBeanBuilder.singleton((String)"jwsService", () -> {
            GenericJWSService jwsService = new GenericJWSService((ObjectMapper)this.objectMapper.get(), (GenericDataConversionService)this.dataConversionService.get(), (JWKService)this.jwkService.get());
            return jwsService;
        }).init(GenericJWSService::init));
        this.jwtService = this.with((Module.ModuleBeanBuilder)Module.ModuleBeanBuilder.singleton((String)"jwtService", () -> {
            GenericJWTService jwtService = new GenericJWTService((ObjectMapper)this.objectMapper.get(), (GenericDataConversionService)this.dataConversionService.get(), (JWKService)this.jwkService.get());
            new Module.BeanAggregator().add((Collection)jweZips.orElse(() -> null).get()).add((Object)((JWEZip)this.deflateJWEZip.get())).toOptionalList().ifPresent(jwtService::setJWEZips);
            return jwtService;
        }).init(GenericJWTService::init));
        this.jwtStringMediaTypeConverter = this.with(Module.ModuleBeanBuilder.singleton((String)"jwtStringMediaTypeConverter", () -> {
            JWTStringMediaTypeConverter jwtStringMediaTypeConverter = new JWTStringMediaTypeConverter();
            return jwtStringMediaTypeConverter;
        }));
        this.objectMapper = this.with(Module.WrapperBeanBuilder.singleton((String)"objectMapper", () -> {
            JOSEObjectMapper objectMapper = new JOSEObjectMapper();
            return objectMapper;
        }).override(objectMapperOverride));
        this.switchableJWKURLResolver = this.with(Module.ModuleBeanBuilder.singleton((String)"switchableJWKURLResolver", () -> {
            SwitchableJWKURLResolver switchableJWKURLResolver = new SwitchableJWKURLResolver((JOSEConfiguration)this.configuration.get(), (JWKURLResolver)this.jwkURLResolver.get());
            return switchableJWKURLResolver;
        }));
        this.workerPool = this.with(Module.WrapperBeanBuilder.singleton((String)"workerPool", () -> {
            WorkerPool workerPool = new WorkerPool();
            return workerPool;
        }).override(workerPoolOverride));
    }

    public JOSEConfiguration configuration() {
        return (JOSEConfiguration)this.configuration.get();
    }

    private GenericDataConversionService dataConversionService() {
        return (GenericDataConversionService)this.dataConversionService.get();
    }

    private DeflateJWEZip deflateJWEZip() {
        return (DeflateJWEZip)this.deflateJWEZip.get();
    }

    private GenericECJWKFactory genericECJWKFactory() {
        return (GenericECJWKFactory)this.genericECJWKFactory.get();
    }

    private GenericEdECJWKFactory genericEdECJWKFactory() {
        return (GenericEdECJWKFactory)this.genericEdECJWKFactory.get();
    }

    private GenericOCTJWKFactory genericOCTJWKFactory() {
        return (GenericOCTJWKFactory)this.genericOCTJWKFactory.get();
    }

    private GenericPBES2JWKFactory genericPBES2JWKFactory() {
        return (GenericPBES2JWKFactory)this.genericPBES2JWKFactory.get();
    }

    private GenericRSAJWKFactory genericRSAJWKFactory() {
        return (GenericRSAJWKFactory)this.genericRSAJWKFactory.get();
    }

    private GenericXECJWKFactory genericXECJWKFactory() {
        return (GenericXECJWKFactory)this.genericXECJWKFactory.get();
    }

    public MediaTypeConverter<String> joseJsonStringMediaTypeConverter() {
        return (MediaTypeConverter)this.joseJsonStringMediaTypeConverter.get();
    }

    public MediaTypeConverter<String> joseStringMediaTypeConverter() {
        return (MediaTypeConverter)this.joseStringMediaTypeConverter.get();
    }

    public JWEService jweService() {
        return (JWEService)this.jweService.get();
    }

    public MediaTypeConverter<String> jwkJsonMediaTypeConverter() {
        return (MediaTypeConverter)this.jwkJsonMediaTypeConverter.get();
    }

    private JWKKeyResolver jwkKeyResolver() {
        return (JWKKeyResolver)this.jwkKeyResolver.get();
    }

    private PKIXParameters jwkPKIXParameters() {
        return (PKIXParameters)this.jwkPKIXParameters.get();
    }

    public JWKService jwkService() {
        return (JWKService)this.jwkService.get();
    }

    public MediaTypeConverter<String> jwkSetJsonMediaTypeConverter() {
        return (MediaTypeConverter)this.jwkSetJsonMediaTypeConverter.get();
    }

    private JWKStore jwkStore() {
        return (JWKStore)this.jwkStore.get();
    }

    private JWKURLResolver jwkURLResolver() {
        return (JWKURLResolver)this.jwkURLResolver.get();
    }

    private X509JWKCertPathValidator jwkX509CertPathValidator() {
        return (X509JWKCertPathValidator)this.jwkX509CertPathValidator.get();
    }

    public JWSService jwsService() {
        return (JWSService)this.jwsService.get();
    }

    public JWTService jwtService() {
        return (JWTService)this.jwtService.get();
    }

    public MediaTypeConverter<String> jwtStringMediaTypeConverter() {
        return (MediaTypeConverter)this.jwtStringMediaTypeConverter.get();
    }

    private ObjectMapper objectMapper() {
        return (ObjectMapper)this.objectMapper.get();
    }

    private SwitchableJWKURLResolver switchableJWKURLResolver() {
        return (SwitchableJWKURLResolver)this.switchableJWKURLResolver.get();
    }

    private ExecutorService workerPool() {
        return (ExecutorService)this.workerPool.get();
    }

    public static final class Linker
    extends Module.ModuleLinker<Jose> {
        public Linker(Map<String, Object> sockets) {
            super(sockets);
        }

        protected Jose link() {
            return new Jose((Optional)this.sockets.get("jweZips"), (Optional)this.sockets.get("jwkFactories"), (Supplier)this.sockets.get("mediaTypeConverters"), (Optional)this.sockets.get("resourceService"), (Optional)this.sockets.get("configuration"), (Optional)this.sockets.get("jwkKeyResolver"), (Optional)this.sockets.get("jwkPKIXParameters"), (Optional)this.sockets.get("jwkStore"), (Optional)this.sockets.get("jwkURLResolver"), (Optional)this.sockets.get("jwkX509CertPathValidator"), (Optional)this.sockets.get("objectMapper"), (Optional)this.sockets.get("workerPool"));
        }
    }

    public static final class Builder
    extends Module.ModuleBuilder<Jose> {
        private Optional<Supplier<List<JWEZip>>> jweZips = Optional.empty();
        private Optional<Supplier<List<JWKFactory<?, ?, ?>>>> jwkFactories = Optional.empty();
        private Supplier<List<MediaTypeConverter<String>>> mediaTypeConverters;
        private Optional<Supplier<ResourceService>> resourceService = Optional.empty();
        private Optional<Supplier<JOSEConfiguration>> configuration = Optional.empty();
        private Optional<Supplier<JWKKeyResolver>> jwkKeyResolver = Optional.empty();
        private Optional<Supplier<PKIXParameters>> jwkPKIXParameters = Optional.empty();
        private Optional<Supplier<JWKStore>> jwkStore = Optional.empty();
        private Optional<Supplier<JWKURLResolver>> jwkURLResolver = Optional.empty();
        private Optional<Supplier<X509JWKCertPathValidator>> jwkX509CertPathValidator = Optional.empty();
        private Optional<Supplier<ObjectMapper>> objectMapper = Optional.empty();
        private Optional<Supplier<ExecutorService>> workerPool = Optional.empty();

        public Builder(List<MediaTypeConverter<String>> mediaTypeConverters) {
            super(new Object[]{"mediaTypeConverters", mediaTypeConverters});
            this.mediaTypeConverters = () -> mediaTypeConverters;
        }

        protected Jose doBuild() {
            return new Jose(this.jweZips, this.jwkFactories, this.mediaTypeConverters, this.resourceService, this.configuration, this.jwkKeyResolver, this.jwkPKIXParameters, this.jwkStore, this.jwkURLResolver, this.jwkX509CertPathValidator, this.objectMapper, this.workerPool);
        }

        public Builder setJweZips(List<JWEZip> jweZips) {
            this.jweZips = Optional.ofNullable(jweZips != null ? () -> jweZips : null);
            return this;
        }

        public Builder setJwkFactories(List<JWKFactory<?, ?, ?>> jwkFactories) {
            this.jwkFactories = Optional.ofNullable(jwkFactories != null ? () -> jwkFactories : null);
            return this;
        }

        public Builder setResourceService(ResourceService resourceService) {
            this.resourceService = Optional.ofNullable(resourceService != null ? () -> resourceService : null);
            return this;
        }

        public Builder setConfiguration(JOSEConfiguration configuration) {
            this.configuration = Optional.ofNullable(configuration != null ? () -> configuration : null);
            return this;
        }

        public Builder setJwkKeyResolver(JWKKeyResolver jwkKeyResolver) {
            this.jwkKeyResolver = Optional.ofNullable(jwkKeyResolver != null ? () -> jwkKeyResolver : null);
            return this;
        }

        public Builder setJwkPKIXParameters(PKIXParameters jwkPKIXParameters) {
            this.jwkPKIXParameters = Optional.ofNullable(jwkPKIXParameters != null ? () -> jwkPKIXParameters : null);
            return this;
        }

        public Builder setJwkStore(JWKStore jwkStore) {
            this.jwkStore = Optional.ofNullable(jwkStore != null ? () -> jwkStore : null);
            return this;
        }

        public Builder setJwkURLResolver(JWKURLResolver jwkURLResolver) {
            this.jwkURLResolver = Optional.ofNullable(jwkURLResolver != null ? () -> jwkURLResolver : null);
            return this;
        }

        public Builder setJwkX509CertPathValidator(X509JWKCertPathValidator jwkX509CertPathValidator) {
            this.jwkX509CertPathValidator = Optional.ofNullable(jwkX509CertPathValidator != null ? () -> jwkX509CertPathValidator : null);
            return this;
        }

        public Builder setObjectMapper(ObjectMapper objectMapper) {
            this.objectMapper = Optional.ofNullable(objectMapper != null ? () -> objectMapper : null);
            return this;
        }

        public Builder setWorkerPool(ExecutorService workerPool) {
            this.workerPool = Optional.ofNullable(workerPool != null ? () -> workerPool : null);
            return this;
        }
    }
}

