package io.inverno.mod.security.jose;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.inverno.core.v1.Module;
import io.inverno.mod.base.converter.MediaTypeConverter;
import io.inverno.mod.base.resource.ResourceService;
import io.inverno.mod.security.jose.internal.JOSEObjectMapper;
import io.inverno.mod.security.jose.internal.WorkerPool;
import io.inverno.mod.security.jose.internal.converter.GenericDataConversionService;
import io.inverno.mod.security.jose.internal.converter.JOSEJsonStringMediaTypeConverter;
import io.inverno.mod.security.jose.internal.converter.JOSEStringMediaTypeConverter;
import io.inverno.mod.security.jose.internal.converter.JWKJsonMediaTypeConverter;
import io.inverno.mod.security.jose.internal.converter.JWKSetJsonMediaTypeConverter;
import io.inverno.mod.security.jose.internal.converter.JWTStringMediaTypeConverter;
import io.inverno.mod.security.jose.internal.jwe.DeflateJWEZip;
import io.inverno.mod.security.jose.internal.jwe.GenericJWEService;
import io.inverno.mod.security.jose.internal.jwk.GenericJWKKeyResolver;
import io.inverno.mod.security.jose.internal.jwk.GenericJWKService;
import io.inverno.mod.security.jose.internal.jwk.GenericJWKStore;
import io.inverno.mod.security.jose.internal.jwk.GenericJWKURLResolver;
import io.inverno.mod.security.jose.internal.jwk.GenericX509JWKCertPathValidator;
import io.inverno.mod.security.jose.internal.jwk.SwitchableJWKURLResolver;
import io.inverno.mod.security.jose.internal.jwk.ec.GenericECJWKFactory;
import io.inverno.mod.security.jose.internal.jwk.oct.GenericOCTJWKFactory;
import io.inverno.mod.security.jose.internal.jwk.okp.GenericEdECJWKFactory;
import io.inverno.mod.security.jose.internal.jwk.okp.GenericXECJWKFactory;
import io.inverno.mod.security.jose.internal.jwk.pbes2.GenericPBES2JWKFactory;
import io.inverno.mod.security.jose.internal.jwk.rsa.GenericRSAJWKFactory;
import io.inverno.mod.security.jose.internal.jws.GenericJWSService;
import io.inverno.mod.security.jose.internal.jwt.GenericJWTService;
import io.inverno.mod.security.jose.jwe.JWEService;
import io.inverno.mod.security.jose.jwe.JWEZip;
import io.inverno.mod.security.jose.jwk.JWKFactory;
import io.inverno.mod.security.jose.jwk.JWKKeyResolver;
import io.inverno.mod.security.jose.jwk.JWKPKIXParameters;
import io.inverno.mod.security.jose.jwk.JWKService;
import io.inverno.mod.security.jose.jwk.JWKStore;
import io.inverno.mod.security.jose.jwk.JWKURLResolver;
import io.inverno.mod.security.jose.jwk.X509JWKCertPathValidator;
import io.inverno.mod.security.jose.jws.JWSService;
import io.inverno.mod.security.jose.jwt.JWTService;
import java.lang.String;
import java.security.cert.PKIXParameters;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import javax.annotation.processing.Generated;

@Generated(value= {"io.inverno.core.compiler.InvernoCompiler", "1"}, date = "2024-04-12T11:58:59.085408084+02:00[Europe/Paris]")
public final class Jose extends Module {

	private Bean<JOSEConfiguration> configuration;
	private Bean<GenericDataConversionService> dataConversionService;
	private Bean<DeflateJWEZip> deflateJWEZip;
	private Bean<GenericECJWKFactory> genericECJWKFactory;
	private Bean<GenericEdECJWKFactory> genericEdECJWKFactory;
	private Bean<GenericOCTJWKFactory> genericOCTJWKFactory;
	private Bean<GenericPBES2JWKFactory> genericPBES2JWKFactory;
	private Bean<GenericRSAJWKFactory> genericRSAJWKFactory;
	private Bean<GenericXECJWKFactory> genericXECJWKFactory;
	private Bean<JOSEJsonStringMediaTypeConverter> joseJsonStringMediaTypeConverter;
	private Bean<JOSEStringMediaTypeConverter> joseStringMediaTypeConverter;
	private Bean<GenericJWEService> jweService;
	private Bean<JWKJsonMediaTypeConverter> jwkJsonMediaTypeConverter;
	private Bean<JWKKeyResolver> jwkKeyResolver;
	private Bean<PKIXParameters> jwkPKIXParameters;
	private Bean<GenericJWKService> jwkService;
	private Bean<JWKSetJsonMediaTypeConverter> jwkSetJsonMediaTypeConverter;
	private Bean<JWKStore> jwkStore;
	private Bean<JWKURLResolver> jwkURLResolver;
	private Bean<X509JWKCertPathValidator> jwkX509CertPathValidator;
	private Bean<GenericJWSService> jwsService;
	private Bean<GenericJWTService> jwtService;
	private Bean<JWTStringMediaTypeConverter> jwtStringMediaTypeConverter;
	private Bean<ObjectMapper> objectMapper;
	private Bean<SwitchableJWKURLResolver> switchableJWKURLResolver;
	private Bean<ExecutorService> workerPool;

	private Jose(
			@Socket(name = "jweZips", wiredTo = {"dataConversionService", "genericRSAJWKFactory", "objectMapper", "joseJsonStringMediaTypeConverter", "jwkSetJsonMediaTypeConverter", "genericOCTJWKFactory", "jwkURLResolver", "genericXECJWKFactory", "jwkPKIXParameters", "genericPBES2JWKFactory", "jwtService", "jwkJsonMediaTypeConverter", "jwsService", "jweService", "jwkService", "workerPool", "genericECJWKFactory", "genericEdECJWKFactory", "switchableJWKURLResolver", "jwkStore", "jwkKeyResolver", "jwkX509CertPathValidator", "configuration", "jwtStringMediaTypeConverter", "joseStringMediaTypeConverter"}) Optional<Supplier<List<JWEZip>>> jweZips,
			@Socket(name = "jwkFactories", wiredTo = {"dataConversionService", "genericRSAJWKFactory", "objectMapper", "joseJsonStringMediaTypeConverter", "jwkSetJsonMediaTypeConverter", "genericOCTJWKFactory", "jwkURLResolver", "genericXECJWKFactory", "jwkPKIXParameters", "genericPBES2JWKFactory", "jwtService", "jwkJsonMediaTypeConverter", "jwsService", "jweService", "jwkService", "workerPool", "genericECJWKFactory", "genericEdECJWKFactory", "switchableJWKURLResolver", "jwkStore", "jwkKeyResolver", "jwkX509CertPathValidator", "configuration", "jwtStringMediaTypeConverter", "joseStringMediaTypeConverter"}) Optional<Supplier<List<JWKFactory<?, ?, ?>>>> jwkFactories,
			@Socket(name = "mediaTypeConverters", wiredTo = {"dataConversionService", "genericRSAJWKFactory", "objectMapper", "joseJsonStringMediaTypeConverter", "jwkSetJsonMediaTypeConverter", "genericOCTJWKFactory", "jwkURLResolver", "genericXECJWKFactory", "jwkPKIXParameters", "genericPBES2JWKFactory", "jwtService", "jwkJsonMediaTypeConverter", "jwsService", "jweService", "jwkService", "workerPool", "genericECJWKFactory", "genericEdECJWKFactory", "switchableJWKURLResolver", "jwkStore", "jwkKeyResolver", "jwkX509CertPathValidator", "configuration", "jwtStringMediaTypeConverter", "joseStringMediaTypeConverter"}) Supplier<List<MediaTypeConverter<String>>> mediaTypeConverters,
			@Socket(name = "resourceService", wiredTo = {"dataConversionService", "genericRSAJWKFactory", "objectMapper", "joseJsonStringMediaTypeConverter", "jwkSetJsonMediaTypeConverter", "genericOCTJWKFactory", "jwkURLResolver", "genericXECJWKFactory", "jwkPKIXParameters", "genericPBES2JWKFactory", "jwtService", "jwkJsonMediaTypeConverter", "jwsService", "jweService", "jwkService", "workerPool", "genericECJWKFactory", "genericEdECJWKFactory", "switchableJWKURLResolver", "jwkStore", "jwkKeyResolver", "jwkX509CertPathValidator", "configuration", "jwtStringMediaTypeConverter", "joseStringMediaTypeConverter"}) Optional<Supplier<ResourceService>> resourceService,
			@Socket(name = "configuration", wiredTo = {"dataConversionService", "genericRSAJWKFactory", "objectMapper", "joseJsonStringMediaTypeConverter", "jwkSetJsonMediaTypeConverter", "genericOCTJWKFactory", "jwkURLResolver", "genericXECJWKFactory", "jwkPKIXParameters", "genericPBES2JWKFactory", "jwtService", "jwkJsonMediaTypeConverter", "jwsService", "jweService", "jwkService", "workerPool", "genericECJWKFactory", "genericEdECJWKFactory", "switchableJWKURLResolver", "jwkStore", "jwkKeyResolver", "jwkX509CertPathValidator", "configuration", "jwtStringMediaTypeConverter", "joseStringMediaTypeConverter"}) Optional<Supplier<JOSEConfiguration>> configurationOverride,
			@Socket(name = "jwkKeyResolver", wiredTo = {"dataConversionService", "genericRSAJWKFactory", "objectMapper", "joseJsonStringMediaTypeConverter", "jwkSetJsonMediaTypeConverter", "genericOCTJWKFactory", "jwkURLResolver", "genericXECJWKFactory", "jwkPKIXParameters", "genericPBES2JWKFactory", "jwtService", "jwkJsonMediaTypeConverter", "jwsService", "jweService", "jwkService", "workerPool", "genericECJWKFactory", "genericEdECJWKFactory", "switchableJWKURLResolver", "jwkStore", "jwkKeyResolver", "jwkX509CertPathValidator", "configuration", "jwtStringMediaTypeConverter", "joseStringMediaTypeConverter"}) Optional<Supplier<JWKKeyResolver>> jwkKeyResolverOverride,
			@Socket(name = "jwkPKIXParameters", wiredTo = {"dataConversionService", "genericRSAJWKFactory", "objectMapper", "joseJsonStringMediaTypeConverter", "jwkSetJsonMediaTypeConverter", "genericOCTJWKFactory", "jwkURLResolver", "genericXECJWKFactory", "jwkPKIXParameters", "genericPBES2JWKFactory", "jwtService", "jwkJsonMediaTypeConverter", "jwsService", "jweService", "jwkService", "workerPool", "genericECJWKFactory", "genericEdECJWKFactory", "switchableJWKURLResolver", "jwkStore", "jwkKeyResolver", "jwkX509CertPathValidator", "configuration", "jwtStringMediaTypeConverter", "joseStringMediaTypeConverter"}) Optional<Supplier<PKIXParameters>> jwkPKIXParametersOverride,
			@Socket(name = "jwkStore", wiredTo = {"dataConversionService", "genericRSAJWKFactory", "objectMapper", "joseJsonStringMediaTypeConverter", "jwkSetJsonMediaTypeConverter", "genericOCTJWKFactory", "jwkURLResolver", "genericXECJWKFactory", "jwkPKIXParameters", "genericPBES2JWKFactory", "jwtService", "jwkJsonMediaTypeConverter", "jwsService", "jweService", "jwkService", "workerPool", "genericECJWKFactory", "genericEdECJWKFactory", "switchableJWKURLResolver", "jwkStore", "jwkKeyResolver", "jwkX509CertPathValidator", "configuration", "jwtStringMediaTypeConverter", "joseStringMediaTypeConverter"}) Optional<Supplier<JWKStore>> jwkStoreOverride,
			@Socket(name = "jwkURLResolver", wiredTo = {"dataConversionService", "genericRSAJWKFactory", "objectMapper", "joseJsonStringMediaTypeConverter", "jwkSetJsonMediaTypeConverter", "genericOCTJWKFactory", "jwkURLResolver", "genericXECJWKFactory", "jwkPKIXParameters", "genericPBES2JWKFactory", "jwtService", "jwkJsonMediaTypeConverter", "jwsService", "jweService", "jwkService", "workerPool", "genericECJWKFactory", "genericEdECJWKFactory", "switchableJWKURLResolver", "jwkStore", "jwkKeyResolver", "jwkX509CertPathValidator", "configuration", "jwtStringMediaTypeConverter", "joseStringMediaTypeConverter"}) Optional<Supplier<JWKURLResolver>> jwkURLResolverOverride,
			@Socket(name = "jwkX509CertPathValidator", wiredTo = {"dataConversionService", "genericRSAJWKFactory", "objectMapper", "joseJsonStringMediaTypeConverter", "jwkSetJsonMediaTypeConverter", "genericOCTJWKFactory", "jwkURLResolver", "genericXECJWKFactory", "jwkPKIXParameters", "genericPBES2JWKFactory", "jwtService", "jwkJsonMediaTypeConverter", "jwsService", "jweService", "jwkService", "workerPool", "genericECJWKFactory", "genericEdECJWKFactory", "switchableJWKURLResolver", "jwkStore", "jwkKeyResolver", "jwkX509CertPathValidator", "configuration", "jwtStringMediaTypeConverter", "joseStringMediaTypeConverter"}) Optional<Supplier<X509JWKCertPathValidator>> jwkX509CertPathValidatorOverride,
			@Socket(name = "objectMapper", wiredTo = {"dataConversionService", "genericRSAJWKFactory", "objectMapper", "joseJsonStringMediaTypeConverter", "jwkSetJsonMediaTypeConverter", "genericOCTJWKFactory", "jwkURLResolver", "genericXECJWKFactory", "jwkPKIXParameters", "genericPBES2JWKFactory", "jwtService", "jwkJsonMediaTypeConverter", "jwsService", "jweService", "jwkService", "workerPool", "genericECJWKFactory", "genericEdECJWKFactory", "switchableJWKURLResolver", "jwkStore", "jwkKeyResolver", "jwkX509CertPathValidator", "configuration", "jwtStringMediaTypeConverter", "joseStringMediaTypeConverter"}) Optional<Supplier<ObjectMapper>> objectMapperOverride,
			@Socket(name = "workerPool", wiredTo = {"dataConversionService", "genericRSAJWKFactory", "objectMapper", "joseJsonStringMediaTypeConverter", "jwkSetJsonMediaTypeConverter", "genericOCTJWKFactory", "jwkURLResolver", "genericXECJWKFactory", "jwkPKIXParameters", "genericPBES2JWKFactory", "jwtService", "jwkJsonMediaTypeConverter", "jwsService", "jweService", "jwkService", "workerPool", "genericECJWKFactory", "genericEdECJWKFactory", "switchableJWKURLResolver", "jwkStore", "jwkKeyResolver", "jwkX509CertPathValidator", "configuration", "jwtStringMediaTypeConverter", "joseStringMediaTypeConverter"}) Optional<Supplier<ExecutorService>> workerPoolOverride
		) {
		super("io.inverno.mod.security.jose");

		this.configuration = this.with(WrapperBeanBuilder
			.singleton("configuration", () -> {
				io.inverno.mod.security.jose.JOSEConfigurationLoader.Bean configuration = new io.inverno.mod.security.jose.JOSEConfigurationLoader.Bean();

				return configuration;
			})
			.override(configurationOverride)
		);
		this.dataConversionService = this.with(ModuleBeanBuilder
			.singleton("dataConversionService", () -> {
				GenericDataConversionService dataConversionService = new GenericDataConversionService(
					new BeanAggregator<MediaTypeConverter<String>>()
						.add(mediaTypeConverters.get())
						.add(this.joseJsonStringMediaTypeConverter.get())
						.add(this.joseStringMediaTypeConverter.get())
						.add(this.jwkJsonMediaTypeConverter.get())
						.add(this.jwkSetJsonMediaTypeConverter.get())
						.add(this.jwtStringMediaTypeConverter.get())
					.toList()
				);

				return dataConversionService;
			})
		);
		this.deflateJWEZip = this.with(ModuleBeanBuilder
			.singleton("deflateJWEZip", () -> {
				DeflateJWEZip deflateJWEZip = new DeflateJWEZip();

				return deflateJWEZip;
			})
		);
		this.genericECJWKFactory = this.with(ModuleBeanBuilder
			.singleton("genericECJWKFactory", () -> {
				GenericECJWKFactory genericECJWKFactory = new GenericECJWKFactory(
					this.configuration.get(),
					this.jwkStore.get(),
					this.jwkKeyResolver.get(),
					this.objectMapper.get(),
					this.switchableJWKURLResolver.get(),
					this.jwkX509CertPathValidator.get()
				);

				return genericECJWKFactory;
			})
		);
		this.genericEdECJWKFactory = this.with(ModuleBeanBuilder
			.singleton("genericEdECJWKFactory", () -> {
				GenericEdECJWKFactory genericEdECJWKFactory = new GenericEdECJWKFactory(
					this.configuration.get(),
					this.jwkStore.get(),
					this.jwkKeyResolver.get(),
					this.objectMapper.get(),
					this.switchableJWKURLResolver.get(),
					this.jwkX509CertPathValidator.get()
				);

				return genericEdECJWKFactory;
			})
		);
		this.genericOCTJWKFactory = this.with(ModuleBeanBuilder
			.singleton("genericOCTJWKFactory", () -> {
				GenericOCTJWKFactory genericOCTJWKFactory = new GenericOCTJWKFactory(
					this.configuration.get(),
					this.jwkStore.get(),
					this.jwkKeyResolver.get(),
					this.objectMapper.get()
				);

				return genericOCTJWKFactory;
			})
		);
		this.genericPBES2JWKFactory = this.with(ModuleBeanBuilder
			.singleton("genericPBES2JWKFactory", () -> {
				GenericPBES2JWKFactory genericPBES2JWKFactory = new GenericPBES2JWKFactory(
					this.configuration.get(),
					this.jwkStore.get(),
					this.jwkKeyResolver.get(),
					this.objectMapper.get()
				);

				return genericPBES2JWKFactory;
			})
		);
		this.genericRSAJWKFactory = this.with(ModuleBeanBuilder
			.singleton("genericRSAJWKFactory", () -> {
				GenericRSAJWKFactory genericRSAJWKFactory = new GenericRSAJWKFactory(
					this.configuration.get(),
					this.jwkStore.get(),
					this.jwkKeyResolver.get(),
					this.objectMapper.get(),
					this.switchableJWKURLResolver.get(),
					this.jwkX509CertPathValidator.get()
				);

				return genericRSAJWKFactory;
			})
		);
		this.genericXECJWKFactory = this.with(ModuleBeanBuilder
			.singleton("genericXECJWKFactory", () -> {
				GenericXECJWKFactory genericXECJWKFactory = new GenericXECJWKFactory(
					this.configuration.get(),
					this.jwkStore.get(),
					this.jwkKeyResolver.get(),
					this.objectMapper.get(),
					this.switchableJWKURLResolver.get(),
					this.jwkX509CertPathValidator.get()
				);

				return genericXECJWKFactory;
			})
		);
		this.joseJsonStringMediaTypeConverter = this.with(ModuleBeanBuilder
			.singleton("joseJsonStringMediaTypeConverter", () -> {
				JOSEJsonStringMediaTypeConverter joseJsonStringMediaTypeConverter = new JOSEJsonStringMediaTypeConverter();

				return joseJsonStringMediaTypeConverter;
			})
		);
		this.joseStringMediaTypeConverter = this.with(ModuleBeanBuilder
			.singleton("joseStringMediaTypeConverter", () -> {
				JOSEStringMediaTypeConverter joseStringMediaTypeConverter = new JOSEStringMediaTypeConverter();

				return joseStringMediaTypeConverter;
			})
		);
		this.jweService = this.with(ModuleBeanBuilder
			.singleton("jweService", () -> {
				GenericJWEService jweService = new GenericJWEService(
					this.objectMapper.get(),
					this.dataConversionService.get(),
					this.jwkService.get()
				);
				new BeanAggregator<JWEZip>()
					.add(jweZips.orElse(() -> null).get())
					.add(this.deflateJWEZip.get())
				.toOptionalList().ifPresent(jweService::setJWEZips);
				return jweService;
			})
			.init(GenericJWEService::init)
		);
		this.jwkJsonMediaTypeConverter = this.with(ModuleBeanBuilder
			.singleton("jwkJsonMediaTypeConverter", () -> {
				JWKJsonMediaTypeConverter jwkJsonMediaTypeConverter = new JWKJsonMediaTypeConverter(
					this.jwkService.get(),
					this.objectMapper.get()
				);

				return jwkJsonMediaTypeConverter;
			})
		);
		this.jwkKeyResolver = this.with(ModuleBeanBuilder
			.singleton("jwkKeyResolver", () -> {
				GenericJWKKeyResolver jwkKeyResolver = new GenericJWKKeyResolver(
					this.configuration.get()
				);
				resourceService.map(Supplier::get).ifPresent(jwkKeyResolver::setResourceService);
				return jwkKeyResolver;
			})
			.init(GenericJWKKeyResolver::init)
			.override(jwkKeyResolverOverride)
		);
		this.jwkPKIXParameters = this.with(WrapperBeanBuilder
			.singleton("jwkPKIXParameters", () -> {
				JWKPKIXParameters jwkPKIXParameters = new JWKPKIXParameters();

				return jwkPKIXParameters;
			})
			.override(jwkPKIXParametersOverride)
		);
		this.jwkService = this.with(ModuleBeanBuilder
			.singleton("jwkService", () -> {
				GenericJWKService jwkService = new GenericJWKService(
					this.configuration.get(),
					this.genericECJWKFactory.get(),
					this.genericRSAJWKFactory.get(),
					this.genericOCTJWKFactory.get(),
					this.genericEdECJWKFactory.get(),
					this.genericXECJWKFactory.get(),
					this.genericPBES2JWKFactory.get(),
					this.jwkStore.get(),
					this.jwkURLResolver.get(),
					this.switchableJWKURLResolver.get(),
					this.objectMapper.get()
				);
				new BeanAggregator<JWKFactory<?, ?, ?>>()
					.add(jwkFactories.orElse(() -> null).get())
					.add(this.genericECJWKFactory.get())
					.add(this.genericEdECJWKFactory.get())
					.add(this.genericOCTJWKFactory.get())
					.add(this.genericPBES2JWKFactory.get())
					.add(this.genericRSAJWKFactory.get())
					.add(this.genericXECJWKFactory.get())
				.toOptionalList().ifPresent(jwkService::setJWKFactories);
				return jwkService;
			})
		);
		this.jwkSetJsonMediaTypeConverter = this.with(ModuleBeanBuilder
			.singleton("jwkSetJsonMediaTypeConverter", () -> {
				JWKSetJsonMediaTypeConverter jwkSetJsonMediaTypeConverter = new JWKSetJsonMediaTypeConverter(
					this.jwkService.get(),
					this.objectMapper.get()
				);

				return jwkSetJsonMediaTypeConverter;
			})
		);
		this.jwkStore = this.with(WrapperBeanBuilder
			.singleton("jwkStore", () -> {
				GenericJWKStore jwkStore = new GenericJWKStore();

				return jwkStore;
			})
			.override(jwkStoreOverride)
		);
		this.jwkURLResolver = this.with(ModuleBeanBuilder
			.singleton("jwkURLResolver", () -> {
				GenericJWKURLResolver jwkURLResolver = new GenericJWKURLResolver(
					this.objectMapper.get()
				);
				resourceService.map(Supplier::get).ifPresent(jwkURLResolver::setResourceService);
				return jwkURLResolver;
			})
			.override(jwkURLResolverOverride)
		);
		this.jwkX509CertPathValidator = this.with(ModuleBeanBuilder
			.singleton("jwkX509CertPathValidator", () -> {
				GenericX509JWKCertPathValidator jwkX509CertPathValidator = new GenericX509JWKCertPathValidator(
					this.jwkPKIXParameters.get(),
					this.workerPool.get()
				);

				return jwkX509CertPathValidator;
			})
			.override(jwkX509CertPathValidatorOverride)
		);
		this.jwsService = this.with(ModuleBeanBuilder
			.singleton("jwsService", () -> {
				GenericJWSService jwsService = new GenericJWSService(
					this.objectMapper.get(),
					this.dataConversionService.get(),
					this.jwkService.get()
				);

				return jwsService;
			})
			.init(GenericJWSService::init)
		);
		this.jwtService = this.with(ModuleBeanBuilder
			.singleton("jwtService", () -> {
				GenericJWTService jwtService = new GenericJWTService(
					this.objectMapper.get(),
					this.dataConversionService.get(),
					this.jwkService.get()
				);
				new BeanAggregator<JWEZip>()
					.add(jweZips.orElse(() -> null).get())
					.add(this.deflateJWEZip.get())
				.toOptionalList().ifPresent(jwtService::setJWEZips);
				return jwtService;
			})
			.init(GenericJWTService::init)
		);
		this.jwtStringMediaTypeConverter = this.with(ModuleBeanBuilder
			.singleton("jwtStringMediaTypeConverter", () -> {
				JWTStringMediaTypeConverter jwtStringMediaTypeConverter = new JWTStringMediaTypeConverter();

				return jwtStringMediaTypeConverter;
			})
		);
		this.objectMapper = this.with(WrapperBeanBuilder
			.singleton("objectMapper", () -> {
				JOSEObjectMapper objectMapper = new JOSEObjectMapper();

				return objectMapper;
			})
			.override(objectMapperOverride)
		);
		this.switchableJWKURLResolver = this.with(ModuleBeanBuilder
			.singleton("switchableJWKURLResolver", () -> {
				SwitchableJWKURLResolver switchableJWKURLResolver = new SwitchableJWKURLResolver(
					this.configuration.get(),
					this.jwkURLResolver.get()
				);

				return switchableJWKURLResolver;
			})
		);
		this.workerPool = this.with(WrapperBeanBuilder
			.singleton("workerPool", () -> {
				WorkerPool workerPool = new WorkerPool();

				return workerPool;
			})
			.override(workerPoolOverride)
		);
	}

	public JOSEConfiguration configuration() {
		return this.configuration.get();
	}

	private GenericDataConversionService dataConversionService() {
		return this.dataConversionService.get();
	}

	private DeflateJWEZip deflateJWEZip() {
		return this.deflateJWEZip.get();
	}

	private GenericECJWKFactory genericECJWKFactory() {
		return this.genericECJWKFactory.get();
	}

	private GenericEdECJWKFactory genericEdECJWKFactory() {
		return this.genericEdECJWKFactory.get();
	}

	private GenericOCTJWKFactory genericOCTJWKFactory() {
		return this.genericOCTJWKFactory.get();
	}

	private GenericPBES2JWKFactory genericPBES2JWKFactory() {
		return this.genericPBES2JWKFactory.get();
	}

	private GenericRSAJWKFactory genericRSAJWKFactory() {
		return this.genericRSAJWKFactory.get();
	}

	private GenericXECJWKFactory genericXECJWKFactory() {
		return this.genericXECJWKFactory.get();
	}

	public MediaTypeConverter<String> joseJsonStringMediaTypeConverter() {
		return this.joseJsonStringMediaTypeConverter.get();
	}

	public MediaTypeConverter<String> joseStringMediaTypeConverter() {
		return this.joseStringMediaTypeConverter.get();
	}

	public JWEService jweService() {
		return this.jweService.get();
	}

	public MediaTypeConverter<String> jwkJsonMediaTypeConverter() {
		return this.jwkJsonMediaTypeConverter.get();
	}

	private JWKKeyResolver jwkKeyResolver() {
		return this.jwkKeyResolver.get();
	}

	private PKIXParameters jwkPKIXParameters() {
		return this.jwkPKIXParameters.get();
	}

	public JWKService jwkService() {
		return this.jwkService.get();
	}

	public MediaTypeConverter<String> jwkSetJsonMediaTypeConverter() {
		return this.jwkSetJsonMediaTypeConverter.get();
	}

	private JWKStore jwkStore() {
		return this.jwkStore.get();
	}

	private JWKURLResolver jwkURLResolver() {
		return this.jwkURLResolver.get();
	}

	private X509JWKCertPathValidator jwkX509CertPathValidator() {
		return this.jwkX509CertPathValidator.get();
	}

	public JWSService jwsService() {
		return this.jwsService.get();
	}

	public JWTService jwtService() {
		return this.jwtService.get();
	}

	public MediaTypeConverter<String> jwtStringMediaTypeConverter() {
		return this.jwtStringMediaTypeConverter.get();
	}

	private ObjectMapper objectMapper() {
		return this.objectMapper.get();
	}

	private SwitchableJWKURLResolver switchableJWKURLResolver() {
		return this.switchableJWKURLResolver.get();
	}

	private ExecutorService workerPool() {
		return this.workerPool.get();
	}

	public static final class Builder extends ModuleBuilder<Jose> {

		private Optional<Supplier<List<JWEZip>>> jweZips = Optional.empty();
		private Optional<Supplier<List<JWKFactory<?, ?, ?>>>> jwkFactories = Optional.empty();
		private Supplier<List<MediaTypeConverter<String>>> mediaTypeConverters;
		private Optional<Supplier<ResourceService>> resourceService = Optional.empty();
		private Optional<Supplier<JOSEConfiguration>> configuration = Optional.empty();
		private Optional<Supplier<JWKKeyResolver>> jwkKeyResolver = Optional.empty();
		private Optional<Supplier<PKIXParameters>> jwkPKIXParameters = Optional.empty();
		private Optional<Supplier<JWKStore>> jwkStore = Optional.empty();
		private Optional<Supplier<JWKURLResolver>> jwkURLResolver = Optional.empty();
		private Optional<Supplier<X509JWKCertPathValidator>> jwkX509CertPathValidator = Optional.empty();
		private Optional<Supplier<ObjectMapper>> objectMapper = Optional.empty();
		private Optional<Supplier<ExecutorService>> workerPool = Optional.empty();

		public Builder(List<MediaTypeConverter<String>> mediaTypeConverters) {
			super("mediaTypeConverters", mediaTypeConverters);

			this.mediaTypeConverters = () -> mediaTypeConverters;
		}

		protected Jose doBuild() {
			return new Jose(this.jweZips, this.jwkFactories, this.mediaTypeConverters, this.resourceService, this.configuration, this.jwkKeyResolver, this.jwkPKIXParameters, this.jwkStore, this.jwkURLResolver, this.jwkX509CertPathValidator, this.objectMapper, this.workerPool);
		}

		public Builder setJweZips(List<JWEZip> jweZips) {
			this.jweZips = Optional.ofNullable(jweZips != null ? () -> jweZips : null);
			return this;
		}

		public Builder setJwkFactories(List<JWKFactory<?, ?, ?>> jwkFactories) {
			this.jwkFactories = Optional.ofNullable(jwkFactories != null ? () -> jwkFactories : null);
			return this;
		}

		public Builder setResourceService(ResourceService resourceService) {
			this.resourceService = Optional.ofNullable(resourceService != null ? () -> resourceService : null);
			return this;
		}

		public Builder setConfiguration(JOSEConfiguration configuration) {
			this.configuration = Optional.ofNullable(configuration != null ? () -> configuration : null);
			return this;
		}

		public Builder setJwkKeyResolver(JWKKeyResolver jwkKeyResolver) {
			this.jwkKeyResolver = Optional.ofNullable(jwkKeyResolver != null ? () -> jwkKeyResolver : null);
			return this;
		}

		public Builder setJwkPKIXParameters(PKIXParameters jwkPKIXParameters) {
			this.jwkPKIXParameters = Optional.ofNullable(jwkPKIXParameters != null ? () -> jwkPKIXParameters : null);
			return this;
		}

		public Builder setJwkStore(JWKStore jwkStore) {
			this.jwkStore = Optional.ofNullable(jwkStore != null ? () -> jwkStore : null);
			return this;
		}

		public Builder setJwkURLResolver(JWKURLResolver jwkURLResolver) {
			this.jwkURLResolver = Optional.ofNullable(jwkURLResolver != null ? () -> jwkURLResolver : null);
			return this;
		}

		public Builder setJwkX509CertPathValidator(X509JWKCertPathValidator jwkX509CertPathValidator) {
			this.jwkX509CertPathValidator = Optional.ofNullable(jwkX509CertPathValidator != null ? () -> jwkX509CertPathValidator : null);
			return this;
		}

		public Builder setObjectMapper(ObjectMapper objectMapper) {
			this.objectMapper = Optional.ofNullable(objectMapper != null ? () -> objectMapper : null);
			return this;
		}

		public Builder setWorkerPool(ExecutorService workerPool) {
			this.workerPool = Optional.ofNullable(workerPool != null ? () -> workerPool : null);
			return this;
		}
	}

	public static final class Linker extends ModuleLinker<Jose> {

		public Linker(Map<String, Object> sockets) {
			super(sockets);
		}

		@SuppressWarnings("unchecked")
		protected Jose link() {
			return new Jose(
				(Optional<Supplier<List<JWEZip>>>)this.sockets.get("jweZips"),
				(Optional<Supplier<List<JWKFactory<?, ?, ?>>>>)this.sockets.get("jwkFactories"),
				(Supplier<List<MediaTypeConverter<String>>>)this.sockets.get("mediaTypeConverters"),
				(Optional<Supplier<ResourceService>>)this.sockets.get("resourceService"),
				(Optional<Supplier<JOSEConfiguration>>)this.sockets.get("configuration"),
				(Optional<Supplier<JWKKeyResolver>>)this.sockets.get("jwkKeyResolver"),
				(Optional<Supplier<PKIXParameters>>)this.sockets.get("jwkPKIXParameters"),
				(Optional<Supplier<JWKStore>>)this.sockets.get("jwkStore"),
				(Optional<Supplier<JWKURLResolver>>)this.sockets.get("jwkURLResolver"),
				(Optional<Supplier<X509JWKCertPathValidator>>)this.sockets.get("jwkX509CertPathValidator"),
				(Optional<Supplier<ObjectMapper>>)this.sockets.get("objectMapper"),
				(Optional<Supplier<ExecutorService>>)this.sockets.get("workerPool")
			);
		}
	}
}
