/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.jwt;

import io.inverno.mod.security.SecurityException;
import io.inverno.mod.security.authentication.InvalidCredentialsException;
import io.inverno.mod.security.authentication.TokenAuthentication;
import io.inverno.mod.security.jose.JOSEProcessingException;
import io.inverno.mod.security.jose.jwa.NoAlgorithm;
import io.inverno.mod.security.jose.jws.JWS;
import io.inverno.mod.security.jose.jws.JWSHeader;
import io.inverno.mod.security.jose.jwt.InvalidJWTException;
import io.inverno.mod.security.jose.jwt.JWTClaimsSet;
import java.util.Objects;
import java.util.Optional;

public class JWTSAuthentication<A extends JWTClaimsSet>
implements TokenAuthentication {
    private final JWS<A> jwt;
    private final Optional<SecurityException> cause;

    public JWTSAuthentication(JWS<A> jwt) {
        this.jwt = Objects.requireNonNull(jwt);
        this.cause = Optional.empty();
    }

    public JWTSAuthentication(SecurityException cause) {
        this.jwt = null;
        this.cause = Optional.ofNullable(cause);
    }

    JWTSAuthentication(JOSEProcessingException cause) {
        this.jwt = null;
        this.cause = Optional.ofNullable(cause).map(e -> new InvalidCredentialsException("Invalid token", (Throwable)e));
    }

    public JWS<A> getJwt() {
        return this.jwt;
    }

    public A getJWTClaimsSet() {
        return (A)(this.jwt != null ? (JWTClaimsSet)this.jwt.getPayload() : null);
    }

    public String getToken() {
        return this.jwt != null ? this.jwt.toCompact() : null;
    }

    public boolean isAuthenticated() {
        return this.jwt != null && !((JWSHeader)this.jwt.getHeader()).getAlgorithm().equals(NoAlgorithm.NONE.getAlgorithm()) && ((JWTClaimsSet)this.jwt.getPayload()).isValid();
    }

    public Optional<SecurityException> getCause() {
        if (this.jwt != null) {
            try {
                ((JWTClaimsSet)this.jwt.getPayload()).ifInvalidThrow();
                return Optional.empty();
            }
            catch (InvalidJWTException e) {
                return Optional.of(new InvalidCredentialsException((Throwable)e));
            }
        }
        return this.cause;
    }
}

