/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.jwk;

import io.inverno.core.annotation.Bean;
import io.inverno.core.annotation.BeanSocket;
import io.inverno.core.annotation.Overridable;
import io.inverno.core.annotation.Wrapper;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

@Overridable
@Wrapper
@Bean(name="jwkPKIXParameters", visibility=Bean.Visibility.PRIVATE)
public class JWKPKIXParameters
implements Supplier<PKIXParameters> {
    private final CertStore trustStore;
    private PKIXParameters instance;

    @BeanSocket
    public JWKPKIXParameters() {
        this(null);
    }

    public JWKPKIXParameters(CertStore trustStore) {
        this.trustStore = trustStore != null ? trustStore : this.getDefaultTrustStore();
    }

    private CertStore getDefaultTrustStore() {
        try {
            ArrayList<X509Certificate> trustedCertificates = new ArrayList<X509Certificate>();
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init((KeyStore)null);
            for (TrustManager tm : tmf.getTrustManagers()) {
                if (!(tm instanceof X509TrustManager)) continue;
                trustedCertificates.addAll(Arrays.asList(((X509TrustManager)tm).getAcceptedIssuers()));
            }
            return CertStore.getInstance("collection", new CollectionCertStoreParameters(trustedCertificates));
        }
        catch (InvalidAlgorithmParameterException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new RuntimeException("Error initializing JWK trust store", e);
        }
    }

    @Override
    public PKIXParameters get() {
        if (this.instance == null) {
            try {
                this.instance = new PKIXParameters(this.trustStore.getCertificates(new X509CertSelector()).stream().map(trustedCert -> new TrustAnchor((X509Certificate)trustedCert, null)).collect(Collectors.toSet()));
                this.instance.setRevocationEnabled(false);
                return this.instance;
            }
            catch (InvalidAlgorithmParameterException | CertStoreException e) {
                throw new RuntimeException("Error initializing certificate path validator parameters", e);
            }
        }
        return this.instance;
    }
}

