/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.jwa;

import io.inverno.mod.security.jose.internal.jwa.PBES2KeyManager;
import io.inverno.mod.security.jose.jwa.JWAAlgorithm;
import io.inverno.mod.security.jose.jwa.JWACipher;
import io.inverno.mod.security.jose.jwa.JWAKeyManager;
import io.inverno.mod.security.jose.jwa.JWAProcessingException;
import io.inverno.mod.security.jose.jwa.JWASigner;
import io.inverno.mod.security.jose.jwk.pbes2.PBES2JWK;
import java.util.Objects;
import java.util.function.BiFunction;

public enum PBES2Algorithm implements JWAAlgorithm<PBES2JWK>
{
    PBES2_HS256_A128KW("PBES2-HS256+A128KW", null, PBES2Algorithm::createPBES2KeyManager, null, "PBKDF2WithHmacSHA256", "AESWrap_128", 16),
    PBES2_HS384_A192KW("PBES2-HS384+A192KW", null, PBES2Algorithm::createPBES2KeyManager, null, "PBKDF2WithHmacSHA384", "AESWrap_192", 24),
    PBES2_HS512_A256KW("PBES2-HS512+A256KW", null, PBES2Algorithm::createPBES2KeyManager, null, "PBKDF2WithHmacSHA512", "AESWrap_256", 32);

    public static final int MINIMUM_SALT_LENGTH = 8;
    public static final int DEFAULT_SALT_LENGTH = 16;
    public static final int MINIMUM_ITERATION_COUNT = 1000;
    public static final int DEFAULT_ITERATION_COUNT = 1000;
    private final String alg;
    private final BiFunction<PBES2JWK, PBES2Algorithm, JWASigner> signerFactory;
    private final BiFunction<PBES2JWK, PBES2Algorithm, JWAKeyManager> keyManagerFactory;
    private final BiFunction<PBES2JWK, PBES2Algorithm, JWACipher> cipherFactory;
    private final String jcaAlg;
    private final String jcaEncryptionAlg;
    private final int encKeyLength;

    private PBES2Algorithm(String alg, BiFunction<PBES2JWK, PBES2Algorithm, JWASigner> signerFactory, BiFunction<PBES2JWK, PBES2Algorithm, JWAKeyManager> keyManagerFactory, BiFunction<PBES2JWK, PBES2Algorithm, JWACipher> cipherFactory, String jcaAlg, String jcaEncryptionAlg, int encKeyLength) {
        this.alg = alg;
        this.signerFactory = signerFactory;
        this.keyManagerFactory = keyManagerFactory;
        this.cipherFactory = cipherFactory;
        this.jcaAlg = jcaAlg;
        this.jcaEncryptionAlg = jcaEncryptionAlg;
        this.encKeyLength = encKeyLength;
    }

    @Override
    public String getAlgorithm() {
        return this.alg;
    }

    @Override
    public boolean isSignature() {
        return this.signerFactory != null;
    }

    @Override
    public boolean isKeyManagement() {
        return this.keyManagerFactory != null;
    }

    @Override
    public boolean isEncryption() {
        return this.cipherFactory != null;
    }

    @Override
    public JWASigner createSigner(PBES2JWK jwk) throws JWAProcessingException {
        if (this.signerFactory == null) {
            throw new JWAProcessingException("Not a signature algorithm: " + this.alg);
        }
        return this.signerFactory.apply(jwk, this);
    }

    @Override
    public JWAKeyManager createKeyManager(PBES2JWK jwk) throws JWAProcessingException {
        if (this.keyManagerFactory == null) {
            throw new JWAProcessingException("Not a key management algorithm: " + this.alg);
        }
        return this.keyManagerFactory.apply(jwk, this);
    }

    @Override
    public JWACipher createCipher(PBES2JWK jwk) throws JWAProcessingException {
        if (this.cipherFactory == null) {
            throw new JWAProcessingException("Not an encryption algorithm: " + this.alg);
        }
        return this.cipherFactory.apply(jwk, this);
    }

    public String getJcaAlgorithm() {
        return this.jcaAlg;
    }

    public String getJcaEncryptionAlgorithm() {
        return this.jcaEncryptionAlg;
    }

    public int getEncryptionKeyLength() {
        return this.encKeyLength;
    }

    public static PBES2Algorithm fromAlgorithm(String alg) {
        switch (alg) {
            case "PBES2-HS256+A128KW": {
                return PBES2_HS256_A128KW;
            }
            case "PBES2-HS384+A192KW": {
                return PBES2_HS384_A192KW;
            }
            case "PBES2-HS512+A256KW": {
                return PBES2_HS512_A256KW;
            }
        }
        throw new IllegalArgumentException("Unknown password-based algorithm " + alg);
    }

    private static PBES2KeyManager createPBES2KeyManager(PBES2JWK jwk, PBES2Algorithm algorithm) throws JWAProcessingException {
        PBES2Algorithm pBES2Algorithm = algorithm;
        Objects.requireNonNull(pBES2Algorithm);
        return pBES2Algorithm.new InnerPBES2KeyManager(jwk);
    }

    private class InnerPBES2KeyManager
    extends PBES2KeyManager {
        InnerPBES2KeyManager(PBES2JWK jwk) throws JWAProcessingException {
            super(jwk);
            this.algorithm = PBES2Algorithm.this;
            this.init();
        }
    }
}

