/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.jwa;

import io.inverno.mod.security.jose.internal.jwa.AESCBCCipher;
import io.inverno.mod.security.jose.internal.jwa.AESGCMCipher;
import io.inverno.mod.security.jose.internal.jwa.AESGCMKWKeyManager;
import io.inverno.mod.security.jose.internal.jwa.AESKWKeyManager;
import io.inverno.mod.security.jose.internal.jwa.HMACSigner;
import io.inverno.mod.security.jose.jwa.JWAAlgorithm;
import io.inverno.mod.security.jose.jwa.JWACipher;
import io.inverno.mod.security.jose.jwa.JWAKeyManager;
import io.inverno.mod.security.jose.jwa.JWAProcessingException;
import io.inverno.mod.security.jose.jwa.JWASigner;
import io.inverno.mod.security.jose.jwk.oct.OCTJWK;
import java.util.Objects;
import java.util.function.BiFunction;

public enum OCTAlgorithm implements JWAAlgorithm<OCTJWK>
{
    HS256("HS256", OCTAlgorithm::createHMACSigner, null, null, "HmacSHA256", 32),
    HS384("HS384", OCTAlgorithm::createHMACSigner, null, null, "HmacSHA384", 48),
    HS512("HS512", OCTAlgorithm::createHMACSigner, null, null, "HmacSHA512", 64),
    A128KW("A128KW", null, OCTAlgorithm::createAESKWKeyManager, null, "AESWrap_128", 16),
    A192KW("A192KW", null, OCTAlgorithm::createAESKWKeyManager, null, "AESWrap_192", 24),
    A256KW("A256KW", null, OCTAlgorithm::createAESKWKeyManager, null, "AESWrap_256", 32),
    A128GCMKW("A128GCMKW", null, OCTAlgorithm::createAESGCMKWKeyManager, null, "AES/GCM/NoPadding", 16, 12, 16),
    A192GCMKW("A192GCMKW", null, OCTAlgorithm::createAESGCMKWKeyManager, null, "AES/GCM/NoPadding", 24, 12, 16),
    A256GCMKW("A256GCMKW", null, OCTAlgorithm::createAESGCMKWKeyManager, null, "AES/GCM/NoPadding", 32, 12, 16),
    A128CBC_HS256("A128CBC-HS256", null, null, OCTAlgorithm::createAESCBCCipher, "AES/CBC/PKCS5Padding", 16, 16, 16, "HmacSHA256", 16),
    A192CBC_HS384("A192CBC-HS384", null, null, OCTAlgorithm::createAESCBCCipher, "AES/CBC/PKCS5Padding", 24, 16, 16, "HmacSHA384", 24),
    A256CBC_HS512("A256CBC-HS512", null, null, OCTAlgorithm::createAESCBCCipher, "AES/CBC/PKCS5Padding", 32, 16, 16, "HmacSHA512", 32),
    A128GCM("A128GCM", null, null, OCTAlgorithm::createAESGCMCipher, "AES/GCM/NoPadding", 16, 12, 16),
    A192GCM("A192GCM", null, null, OCTAlgorithm::createAESGCMCipher, "AES/GCM/NoPadding", 24, 12, 16),
    A256GCM("A256GCM", null, null, OCTAlgorithm::createAESGCMCipher, "AES/GCM/NoPadding", 32, 12, 16);

    private final String alg;
    private final BiFunction<OCTJWK, OCTAlgorithm, JWASigner> signerFactory;
    private final BiFunction<OCTJWK, OCTAlgorithm, JWAKeyManager> keyManagerFactory;
    private final BiFunction<OCTJWK, OCTAlgorithm, JWACipher> cipherFactory;
    private final String jcaAlg;
    private final int encKeyLength;
    private final Integer ivLength;
    private final Integer tagLength;
    private final String jcaMacAlg;
    private final Integer macKeyLength;

    private OCTAlgorithm(String alg, BiFunction<OCTJWK, OCTAlgorithm, JWASigner> signerFactory, BiFunction<OCTJWK, OCTAlgorithm, JWAKeyManager> keyManagerFactory, BiFunction<OCTJWK, OCTAlgorithm, JWACipher> cipherFactory, String jcaAlg, int encKeyLength) {
        this(alg, signerFactory, keyManagerFactory, cipherFactory, jcaAlg, encKeyLength, null, null, null, null);
    }

    private OCTAlgorithm(String alg, BiFunction<OCTJWK, OCTAlgorithm, JWASigner> signerFactory, BiFunction<OCTJWK, OCTAlgorithm, JWAKeyManager> keyManagerFactory, BiFunction<OCTJWK, OCTAlgorithm, JWACipher> cipherFactory, String jcaAlg, int encKeyLength, Integer ivLength, Integer tagLength) {
        this(alg, signerFactory, keyManagerFactory, cipherFactory, jcaAlg, encKeyLength, ivLength, tagLength, null, null);
    }

    private OCTAlgorithm(String alg, BiFunction<OCTJWK, OCTAlgorithm, JWASigner> signerFactory, BiFunction<OCTJWK, OCTAlgorithm, JWAKeyManager> keyManagerFactory, BiFunction<OCTJWK, OCTAlgorithm, JWACipher> cipherFactory, String jcaAlg, int encKeyLength, Integer ivLength, Integer tagLength, String jcaMacAlg, Integer macKeyLength) {
        this.alg = alg;
        this.signerFactory = signerFactory;
        this.keyManagerFactory = keyManagerFactory;
        this.cipherFactory = cipherFactory;
        this.jcaAlg = jcaAlg;
        this.encKeyLength = encKeyLength;
        this.ivLength = ivLength;
        this.tagLength = tagLength;
        this.jcaMacAlg = jcaMacAlg;
        this.macKeyLength = macKeyLength;
    }

    @Override
    public String getAlgorithm() {
        return this.alg;
    }

    @Override
    public boolean isSignature() {
        return this.signerFactory != null;
    }

    @Override
    public boolean isKeyManagement() {
        return this.keyManagerFactory != null;
    }

    @Override
    public boolean isEncryption() {
        return this.cipherFactory != null;
    }

    @Override
    public JWASigner createSigner(OCTJWK jwk) throws JWAProcessingException {
        if (this.signerFactory == null) {
            throw new JWAProcessingException("Not a signature algorithm: " + this.alg);
        }
        return this.signerFactory.apply(jwk, this);
    }

    @Override
    public JWAKeyManager createKeyManager(OCTJWK jwk) throws JWAProcessingException {
        if (this.keyManagerFactory == null) {
            throw new JWAProcessingException("Not a key management algorithm: " + this.alg);
        }
        return this.keyManagerFactory.apply(jwk, this);
    }

    @Override
    public JWACipher createCipher(OCTJWK jwk) throws JWAProcessingException {
        if (this.cipherFactory == null) {
            throw new JWAProcessingException("Not an encryption algorithm: " + this.alg);
        }
        return this.cipherFactory.apply(jwk, this);
    }

    public String getJcaAlgorithm() {
        return this.jcaAlg;
    }

    public int getEncryptionKeyLength() {
        return this.encKeyLength;
    }

    public Integer getInitializationVectorLength() {
        return this.ivLength;
    }

    public Integer getAuthenticationTagLength() {
        return this.tagLength;
    }

    public String getMacAlgorithm() {
        return this.jcaMacAlg;
    }

    public Integer getMacKeyLength() {
        return this.macKeyLength;
    }

    public static OCTAlgorithm fromAlgorithm(String alg) throws IllegalArgumentException {
        switch (alg) {
            case "HS256": {
                return HS256;
            }
            case "HS384": {
                return HS384;
            }
            case "HS512": {
                return HS512;
            }
            case "A128KW": {
                return A128KW;
            }
            case "A192KW": {
                return A192KW;
            }
            case "A256KW": {
                return A256KW;
            }
            case "A128GCMKW": {
                return A128GCMKW;
            }
            case "A192GCMKW": {
                return A192GCMKW;
            }
            case "A256GCMKW": {
                return A256GCMKW;
            }
            case "A128CBC-HS256": {
                return A128CBC_HS256;
            }
            case "A192CBC-HS384": {
                return A192CBC_HS384;
            }
            case "A256CBC-HS512": {
                return A256CBC_HS512;
            }
            case "A128GCM": {
                return A128GCM;
            }
            case "A192GCM": {
                return A192GCM;
            }
            case "A256GCM": {
                return A256GCM;
            }
        }
        throw new IllegalArgumentException("Unknown OCT algorithm " + alg);
    }

    private static HMACSigner createHMACSigner(OCTJWK jwk, OCTAlgorithm algorithm) throws JWAProcessingException {
        OCTAlgorithm oCTAlgorithm = algorithm;
        Objects.requireNonNull(oCTAlgorithm);
        return oCTAlgorithm.new InnerHMACSigner(jwk);
    }

    private static AESCBCCipher createAESCBCCipher(OCTJWK jwk, OCTAlgorithm algorithm) throws JWAProcessingException {
        OCTAlgorithm oCTAlgorithm = algorithm;
        Objects.requireNonNull(oCTAlgorithm);
        return oCTAlgorithm.new InnerAESCBCCipher(jwk);
    }

    private static AESGCMCipher createAESGCMCipher(OCTJWK jwk, OCTAlgorithm algorithm) throws JWAProcessingException {
        OCTAlgorithm oCTAlgorithm = algorithm;
        Objects.requireNonNull(oCTAlgorithm);
        return oCTAlgorithm.new InnerAESGCMCipher(jwk);
    }

    private static AESKWKeyManager createAESKWKeyManager(OCTJWK jwk, OCTAlgorithm algorithm) throws JWAProcessingException {
        OCTAlgorithm oCTAlgorithm = algorithm;
        Objects.requireNonNull(oCTAlgorithm);
        return oCTAlgorithm.new InnerAESKWKeyManager(jwk);
    }

    private static AESGCMKWKeyManager createAESGCMKWKeyManager(OCTJWK jwk, OCTAlgorithm algorithm) throws JWAProcessingException {
        OCTAlgorithm oCTAlgorithm = algorithm;
        Objects.requireNonNull(oCTAlgorithm);
        return oCTAlgorithm.new InnerAESGCMKWKeyManager(jwk);
    }

    private class InnerHMACSigner
    extends HMACSigner {
        InnerHMACSigner(OCTJWK jwk) throws JWAProcessingException {
            super(jwk);
            this.algorithm = OCTAlgorithm.this;
            this.init();
        }
    }

    private class InnerAESCBCCipher
    extends AESCBCCipher {
        InnerAESCBCCipher(OCTJWK jwk) throws JWAProcessingException {
            super(jwk);
            this.algorithm = OCTAlgorithm.this;
            this.init();
        }
    }

    private class InnerAESGCMCipher
    extends AESGCMCipher {
        InnerAESGCMCipher(OCTJWK jwk) throws JWAProcessingException {
            super(jwk);
            this.algorithm = OCTAlgorithm.this;
            this.init();
        }
    }

    private class InnerAESKWKeyManager
    extends AESKWKeyManager {
        InnerAESKWKeyManager(OCTJWK jwk) throws JWAProcessingException {
            super(jwk);
            this.algorithm = OCTAlgorithm.this;
            this.init();
        }
    }

    private class InnerAESGCMKWKeyManager
    extends AESGCMKWKeyManager {
        InnerAESGCMKWKeyManager(OCTJWK jwk) throws JWAProcessingException {
            super(jwk);
            this.algorithm = OCTAlgorithm.this;
            this.init();
        }
    }
}

