/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jws;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.inverno.mod.security.jose.JOSEObjectBuildException;
import io.inverno.mod.security.jose.JOSEObjectReadException;
import io.inverno.mod.security.jose.JOSEProcessingException;
import io.inverno.mod.security.jose.internal.AbstractJsonJOSEObjectReader;
import io.inverno.mod.security.jose.internal.converter.DataConversionService;
import io.inverno.mod.security.jose.internal.jws.GenericJWSHeader;
import io.inverno.mod.security.jose.internal.jws.GenericJWSPayload;
import io.inverno.mod.security.jose.internal.jws.GenericJsonJWS;
import io.inverno.mod.security.jose.internal.jws.JsonJWSHeader;
import io.inverno.mod.security.jose.internal.jws.SignatureJWSReader;
import io.inverno.mod.security.jose.jwk.JWK;
import io.inverno.mod.security.jose.jwk.JWKService;
import io.inverno.mod.security.jose.jws.JWSBuildException;
import io.inverno.mod.security.jose.jws.JWSReadException;
import io.inverno.mod.security.jose.jws.JsonJWS;
import io.inverno.mod.security.jose.jws.JsonJWSReader;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Base64;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class GenericJsonJWSReader<A>
extends AbstractJsonJOSEObjectReader<A, JsonJWS<A, JsonJWS.ReadSignature<A>>, GenericJsonJWSReader<A>>
implements JsonJWSReader<A, GenericJsonJWSReader<A>> {
    public GenericJsonJWSReader(ObjectMapper mapper, DataConversionService dataConversionService, JWKService jwkService, Type type) {
        super(mapper, dataConversionService, jwkService, type);
    }

    @Override
    public Mono<JsonJWS<A, JsonJWS.ReadSignature<A>>> read(String json, String contentType) throws JWSReadException, JWSBuildException, JOSEObjectReadException, JOSEObjectBuildException, JOSEProcessingException {
        return this.read(json, null, contentType);
    }

    @Override
    public Mono<JsonJWS<A, JsonJWS.ReadSignature<A>>> read(String json, Function<String, Mono<A>> payloadDecoder) throws JWSReadException, JWSBuildException, JOSEObjectReadException, JOSEObjectBuildException, JOSEProcessingException {
        return this.read(json, payloadDecoder, null);
    }

    private Mono<JsonJWS<A, JsonJWS.ReadSignature<A>>> read(String json, Function<String, Mono<A>> overridingPayloadDecoder, String overridingContentType) throws JWSReadException, JWSBuildException, JOSEObjectReadException, JOSEObjectBuildException, JOSEProcessingException {
        List signaturesValue;
        String payloadValue;
        Map parsedJson;
        try {
            parsedJson = (Map)this.mapper.readerForMapOf(Object.class).readValue(json);
        }
        catch (JsonProcessingException ex) {
            throw new JWSReadException("Error reading Json JWS");
        }
        try {
            payloadValue = (String)parsedJson.get("payload");
            signaturesValue = (List)parsedJson.get("signatures");
        }
        catch (ClassCastException e) {
            throw new JWSReadException("Invalid JWS", e);
        }
        String cty = null;
        Boolean b64 = null;
        LinkedList<SignatureInfo> signatureInfos = new LinkedList<SignatureInfo>();
        if (signaturesValue != null) {
            for (Object signatureElement : signaturesValue) {
                SignatureInfo signatureInfo = this.readJWSSignature(signatureElement);
                if (cty == null) {
                    cty = signatureInfo.signatureJWSHeader.getContentType();
                } else if (signatureInfo.signatureJWSHeader.getContentType() != null && !cty.equals(signatureInfo.signatureJWSHeader.getContentType())) {
                    throw new JWSReadException("Inconsistent content type");
                }
                if (b64 == null) {
                    b64 = signatureInfo.signatureJWSHeader.isBase64EncodePayload() == null || signatureInfo.signatureJWSHeader.isBase64EncodePayload() != false;
                } else if (!b64.booleanValue() && (signatureInfo.signatureJWSHeader.isBase64EncodePayload() == null || signatureInfo.signatureJWSHeader.isBase64EncodePayload().booleanValue()) || b64.booleanValue() && signatureInfo.signatureJWSHeader.isBase64EncodePayload() != null && !signatureInfo.signatureJWSHeader.isBase64EncodePayload().booleanValue()) {
                    throw new JWSReadException("Inconsistent base64 payload encoding");
                }
                signatureInfos.add(signatureInfo);
            }
        } else {
            SignatureInfo signatureInfo = this.readJWSSignature(parsedJson);
            cty = signatureInfo.signatureJWSHeader.getContentType();
            b64 = signatureInfo.signatureJWSHeader.isBase64EncodePayload();
            signatureInfos.add(signatureInfo);
        }
        return this.readJWSPayload(payloadValue, overridingPayloadDecoder, overridingContentType, cty, b64).flatMap(jwsPayload -> Flux.fromIterable((Iterable)signatureInfos).map(signatureReader -> new GenericJsonJWS.GenericReadSignature(signatureReader.signatureProtectedJWSHeader, signatureReader.signatureUnprotectedJWSHeader, signatureReader.signature, keys -> new SignatureJWSReader(this.mapper, this.dataConversionService, this.jwkService, this.type, (Publisher<? extends JWK>)((Publisher<JWK>)((Publisher<? extends JWK>)keys)), signatureReader.signatureJWSHeader, jwsPayload).read(".." + signatureReader.signature))).collectList().map(signatures -> new GenericJsonJWS(this.mapper, jwsPayload, signatures)));
    }

    protected SignatureInfo readJWSSignature(Object signatureElementValue) throws JWSReadException, JOSEObjectReadException, JOSEProcessingException {
        JsonJWSHeader signatureJWSHeader;
        JsonJWSHeader unprotectedSignatureJWSHeader;
        JsonJWSHeader protectedSignatureJWSHeader;
        String signatureValue;
        block10: {
            Map unprotectedValue;
            String protectedValue;
            try {
                Map signatureElement = (Map)signatureElementValue;
                protectedValue = (String)signatureElement.get("protected");
                unprotectedValue = (Map)signatureElement.get("header");
                signatureValue = (String)signatureElement.get("signature");
            }
            catch (ClassCastException e) {
                throw new JWSReadException("Invalid signature element", e);
            }
            if (signatureValue == null) {
                throw new JWSReadException("Missing signature field");
            }
            protectedSignatureJWSHeader = null;
            unprotectedSignatureJWSHeader = null;
            try {
                if (unprotectedValue != null) {
                    unprotectedSignatureJWSHeader = (JsonJWSHeader)this.mapper.convertValue((Object)unprotectedValue, JsonJWSHeader.class);
                    unprotectedSignatureJWSHeader.setEncoded("");
                    signatureJWSHeader = (JsonJWSHeader)this.mapper.convertValue((Object)unprotectedValue, JsonJWSHeader.class);
                    if (protectedValue != null) {
                        protectedSignatureJWSHeader = (JsonJWSHeader)this.mapper.readValue(Base64.getUrlDecoder().decode(protectedValue), JsonJWSHeader.class);
                        protectedSignatureJWSHeader.setEncoded(protectedValue);
                        signatureJWSHeader.startRecordOverlap();
                        this.mapper.readerForUpdating((Object)signatureJWSHeader).readValue(Base64.getUrlDecoder().decode(protectedValue));
                        Set<String> overlappedParameters = signatureJWSHeader.stopRecordOverlap();
                        if (overlappedParameters != null && !overlappedParameters.isEmpty()) {
                            throw new JWSReadException("Protected and unprotected headers must be disjoint: " + overlappedParameters.stream().collect(Collectors.joining(", ")));
                        }
                        signatureJWSHeader.setEncoded(protectedValue);
                    } else {
                        signatureJWSHeader = unprotectedSignatureJWSHeader;
                    }
                    break block10;
                }
                if (protectedValue != null) {
                    protectedSignatureJWSHeader = (JsonJWSHeader)this.mapper.readValue(Base64.getUrlDecoder().decode(protectedValue), JsonJWSHeader.class);
                    protectedSignatureJWSHeader.setEncoded(protectedValue);
                    signatureJWSHeader = protectedSignatureJWSHeader;
                    break block10;
                }
                throw new JWSReadException("Signature must have one of protected and header fields");
            }
            catch (IOException e) {
                throw new JWSReadException("Error decoding signature header", e);
            }
        }
        return new SignatureInfo(protectedSignatureJWSHeader, unprotectedSignatureJWSHeader, signatureJWSHeader, signatureValue);
    }

    protected Mono<GenericJWSPayload<A>> readJWSPayload(String encodedPayload, Function<String, Mono<A>> overridingPayloadDecoder, String overridingContentType, String cty, Boolean b64) throws JWSReadException, JOSEObjectReadException, JOSEProcessingException {
        Function payloadDecoder = this.getPayloadDecoder(overridingPayloadDecoder, overridingContentType, cty);
        return Mono.defer(() -> {
            if (b64 != null && !b64.booleanValue()) {
                return ((Mono)payloadDecoder.apply(encodedPayload)).map(payload -> {
                    GenericJWSPayload<Object> jwsPayload = new GenericJWSPayload<Object>(payload);
                    jwsPayload.setRaw(encodedPayload);
                    return jwsPayload;
                });
            }
            return ((Mono)payloadDecoder.apply(new String(Base64.getUrlDecoder().decode(encodedPayload)))).map(payload -> {
                GenericJWSPayload<Object> jwsPayload = new GenericJWSPayload<Object>(payload);
                jwsPayload.setEncoded(encodedPayload);
                jwsPayload.setRaw(new String(Base64.getUrlDecoder().decode(encodedPayload)));
                return jwsPayload;
            });
        });
    }

    protected static class SignatureInfo {
        final GenericJWSHeader signatureProtectedJWSHeader;
        final GenericJWSHeader signatureUnprotectedJWSHeader;
        final GenericJWSHeader signatureJWSHeader;
        final String signature;

        public SignatureInfo(GenericJWSHeader signatureProtectedJWSHeader, GenericJWSHeader signatureUnprotectedJWSHeader, GenericJWSHeader jwsHeader, String signature) {
            this.signatureProtectedJWSHeader = signatureProtectedJWSHeader;
            this.signatureUnprotectedJWSHeader = signatureUnprotectedJWSHeader;
            this.signatureJWSHeader = jwsHeader;
            this.signature = signature;
        }
    }
}

