/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jws;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.inverno.mod.security.jose.JOSEObjectBuildException;
import io.inverno.mod.security.jose.JOSEObjectReadException;
import io.inverno.mod.security.jose.JOSEProcessingException;
import io.inverno.mod.security.jose.internal.AbstractJsonJOSEObject;
import io.inverno.mod.security.jose.internal.jws.GenericJWSPayload;
import io.inverno.mod.security.jose.jwk.JWK;
import io.inverno.mod.security.jose.jws.JWS;
import io.inverno.mod.security.jose.jws.JWSBuildException;
import io.inverno.mod.security.jose.jws.JWSHeader;
import io.inverno.mod.security.jose.jws.JWSReadException;
import io.inverno.mod.security.jose.jws.JsonJWS;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class GenericJsonJWS<A, B extends JsonJWS.Signature<A>>
extends AbstractJsonJOSEObject<A>
implements JsonJWS<A, B> {
    private final GenericJWSPayload<A> payload;
    private final List<B> signatures;

    public GenericJsonJWS(ObjectMapper mapper, GenericJWSPayload<A> payload, List<B> signatures) {
        super(mapper);
        this.payload = payload;
        this.signatures = signatures != null ? Collections.unmodifiableList(signatures) : List.of();
    }

    @Override
    @JsonIgnore
    public A getPayload() {
        return this.payload.getValue();
    }

    @JsonProperty(value="payload")
    public String getEncodedPayload() {
        if (this.payload.getEncoded() != null) {
            return this.payload.getEncoded();
        }
        if (this.payload.getRaw() != null) {
            return this.payload.getRaw();
        }
        return null;
    }

    @Override
    @JsonProperty(value="signatures")
    public List<B> getSignatures() {
        return this.signatures;
    }

    @Override
    public String toJson() throws JOSEProcessingException {
        if (this.signatures.size() == 1) {
            AbstractSignature signature = (AbstractSignature)this.signatures.get(0);
            try {
                return this.mapper.writeValueAsString(Map.of("payload", this.getEncodedPayload(), "protected", signature.getEncodedProtectedHeader(), "header", signature.getUnprotectedHeader(), "signature", signature.getSignature()));
            }
            catch (JsonProcessingException e) {
                throw new JOSEProcessingException(e);
            }
        }
        return super.toJson();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.payload, this.signatures);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GenericJsonJWS other = (GenericJsonJWS)obj;
        return Objects.equals(this.payload, other.payload) && Objects.equals(this.signatures, other.signatures);
    }

    public static abstract class AbstractSignature<A>
    implements JsonJWS.Signature<A> {
        protected final JWSHeader protectedHeader;
        protected final JWSHeader unprotectedHeader;

        public AbstractSignature(JWSHeader protectedHeader, JWSHeader unprotectedHeader) {
            this.protectedHeader = protectedHeader;
            this.unprotectedHeader = unprotectedHeader;
        }

        @Override
        @JsonIgnore
        public JWSHeader getProtectedHeader() {
            return this.protectedHeader;
        }

        @JsonProperty(value="protected")
        public String getEncodedProtectedHeader() {
            return this.protectedHeader != null ? this.protectedHeader.getEncoded() : null;
        }

        @Override
        @JsonProperty(value="header")
        public JWSHeader getUnprotectedHeader() {
            return this.unprotectedHeader;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.protectedHeader, this.unprotectedHeader);
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AbstractSignature other = (AbstractSignature)obj;
            return Objects.equals(this.protectedHeader, other.protectedHeader) && Objects.equals(this.unprotectedHeader, other.unprotectedHeader);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class GenericReadSignature<A>
    extends AbstractSignature<A>
    implements JsonJWS.ReadSignature<A> {
        private final String signature;
        private final Function<Publisher<? extends JWK>, Mono<JWS<A>>> jwsFactory;

        public GenericReadSignature(JWSHeader protectedHeader, JWSHeader unprotectedHeader, String signature, Function<Publisher<? extends JWK>, Mono<JWS<A>>> jwsFactory) {
            super(protectedHeader, unprotectedHeader);
            this.signature = signature;
            this.jwsFactory = jwsFactory;
        }

        @Override
        @JsonProperty(value="signature")
        public String getSignature() {
            return this.signature;
        }

        @Override
        public Mono<JWS<A>> readJWS() throws JWSReadException, JWSBuildException, JOSEObjectReadException, JOSEObjectBuildException, JOSEProcessingException {
            return this.jwsFactory.apply(null);
        }

        @Override
        public Mono<JWS<A>> readJWS(Publisher<? extends JWK> keys) throws JWSReadException, JWSBuildException, JOSEObjectReadException, JOSEObjectBuildException, JOSEProcessingException {
            return this.jwsFactory.apply(keys);
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + Objects.hash(this.signature);
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GenericReadSignature other = (GenericReadSignature)obj;
            return Objects.equals(this.signature, other.signature);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class GenericBuiltSignature<A>
    extends AbstractSignature<A>
    implements JsonJWS.BuiltSignature<A> {
        private final JWS<A> jws;

        public GenericBuiltSignature(JWSHeader protectedHeader, JWSHeader unprotectedHeader, JWS<A> jws) {
            super(protectedHeader, unprotectedHeader);
            this.jws = jws;
        }

        @Override
        @JsonProperty(value="signature")
        public String getSignature() {
            return this.jws.getSignature();
        }

        @Override
        @JsonIgnore
        public JWS<A> getJWS() {
            return this.jws;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + Objects.hash(this.jws);
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GenericBuiltSignature other = (GenericBuiltSignature)obj;
            return Objects.equals(this.jws, other.jws);
        }
    }
}

