/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jwk.pbes2;

import io.inverno.mod.security.jose.internal.JOSEUtils;
import io.inverno.mod.security.jose.internal.jwk.AbstractJWK;
import io.inverno.mod.security.jose.jwa.JWAAlgorithm;
import io.inverno.mod.security.jose.jwa.JWAKeyManager;
import io.inverno.mod.security.jose.jwa.JWAKeyManagerException;
import io.inverno.mod.security.jose.jwa.PBES2Algorithm;
import io.inverno.mod.security.jose.jwk.JWKProcessingException;
import io.inverno.mod.security.jose.jwk.pbes2.PBES2JWK;
import java.security.MessageDigest;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;

public class GenericPBES2JWK
extends AbstractJWK
implements PBES2JWK {
    private final String p;
    private PBES2Algorithm pbes2Alg;
    private Optional<SecretKey> secretKey;
    private Map<PBES2Algorithm, JWAKeyManager> keyManagers;

    public GenericPBES2JWK() {
        this(null, null, false);
    }

    public GenericPBES2JWK(String p) {
        this(p, null, false);
    }

    public GenericPBES2JWK(String p, SecretKey key, boolean trusted) {
        super("oct", key, trusted);
        this.p = p;
        this.secretKey = key != null ? Optional.of(key) : null;
    }

    public void setAlgorithm(PBES2Algorithm pbes2Alg) {
        this.pbes2Alg = pbes2Alg;
        super.setAlgorithm(pbes2Alg != null ? pbes2Alg.getAlgorithm() : null);
    }

    @Override
    public void setAlgorithm(String alg) {
        this.pbes2Alg = alg != null ? PBES2Algorithm.fromAlgorithm(alg) : null;
        super.setAlgorithm(alg);
    }

    @Override
    public String getPassword() {
        return this.p;
    }

    @Override
    public PBES2JWK trust() {
        this.trusted = true;
        return this;
    }

    @Override
    public Optional<SecretKey> toSecretKey() throws JWKProcessingException {
        if (this.secretKey == null) {
            this.secretKey = Optional.ofNullable(this.p).map(p -> {
                if (this.pbes2Alg != null) {
                    return new SecretKeySpec(Base64.getUrlDecoder().decode(this.p), this.pbes2Alg.getJcaAlgorithm());
                }
                return new SecretKeySpec(Base64.getUrlDecoder().decode(this.p), null);
            });
        }
        return this.secretKey;
    }

    @Override
    public PBES2JWK toPublicJWK() {
        GenericPBES2JWK jwk = new GenericPBES2JWK();
        jwk.setAlgorithm(this.pbes2Alg);
        jwk.setKeyId(this.kid);
        jwk.setKeyOperations(this.key_ops);
        jwk.setPublicKeyUse(this.getPublicKeyUse());
        return jwk;
    }

    @Override
    public PBES2JWK minify() {
        GenericPBES2JWK jwk = new GenericPBES2JWK(this.p, (SecretKey)this.key, this.trusted);
        return jwk;
    }

    @Override
    public String toJWKThumbprint(MessageDigest digest) {
        return GenericPBES2JWK.toJWKThumbprint(digest, this.p, this.kty);
    }

    static String toJWKThumbprint(MessageDigest digest, String p, String kty) {
        if (p == null || kty == null) {
            return null;
        }
        StringBuilder input = new StringBuilder();
        input.append('{');
        input.append("\"k\":\"").append(p).append("\",");
        input.append("\"kty\":\"").append(kty).append("\"");
        input.append('}');
        return JOSEUtils.BASE64_NOPAD_URL_ENCODER.encodeToString(digest.digest(input.toString().getBytes()));
    }

    @Override
    public boolean supportsAlgorithm(String alg) {
        try {
            PBES2Algorithm.fromAlgorithm(alg);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    @Override
    public JWAKeyManager keyManager() throws JWKProcessingException {
        this.checkKeyManagement(this.pbes2Alg);
        return this.getKeyManager(this.pbes2Alg);
    }

    @Override
    public JWAKeyManager keyManager(String alg) throws JWKProcessingException {
        if (StringUtils.isBlank((CharSequence)alg)) {
            return this.keyManager();
        }
        PBES2Algorithm algorithm = PBES2Algorithm.fromAlgorithm(alg);
        this.checkKeyManagement(algorithm);
        return this.getKeyManager(algorithm);
    }

    @Override
    protected void checkKeyManagement(JWAAlgorithm<?> algorithm) throws JWAKeyManagerException {
        super.checkKeyManagement(algorithm);
        if (this.p == null) {
            throw new JWAKeyManagerException("JWK secret key is missing");
        }
    }

    private JWAKeyManager getKeyManager(PBES2Algorithm algorithm) {
        if (this.keyManagers == null) {
            this.keyManagers = new HashMap<PBES2Algorithm, JWAKeyManager>();
        }
        return this.keyManagers.computeIfAbsent(algorithm, ign -> algorithm.createKeyManager(this));
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.p);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GenericPBES2JWK other = (GenericPBES2JWK)obj;
        return Objects.equals(this.p, other.p);
    }
}

