/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jwk.okp;

import io.inverno.mod.security.jose.internal.jwk.AbstractX509JWKGenerator;
import io.inverno.mod.security.jose.internal.jwk.okp.AbstractOKPJWK;
import io.inverno.mod.security.jose.jwa.OKPCurve;
import io.inverno.mod.security.jose.jwk.JWKGenerateException;
import io.inverno.mod.security.jose.jwk.okp.OKPJWKGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Map;

public abstract class AbstractOKPJWKGenerator<A extends PublicKey, B extends PrivateKey, C extends AbstractOKPJWK<A, B>, D extends AbstractOKPJWKGenerator<A, B, C, D>>
extends AbstractX509JWKGenerator<A, B, C, D>
implements OKPJWKGenerator<A, B, C, D> {
    protected OKPCurve curve;

    public AbstractOKPJWKGenerator() {
        this(null);
    }

    public AbstractOKPJWKGenerator(Map<String, Object> parameters) throws JWKGenerateException {
        super(parameters);
    }

    @Override
    protected void set(String field, Object value) throws JWKGenerateException {
        switch (field) {
            case "crv": {
                this.curve((String)value);
                break;
            }
            default: {
                super.set(field, value);
            }
        }
    }

    @Override
    public D curve(String crv) {
        this.curve = OKPCurve.fromCurve(crv);
        return (D)this;
    }
}

