/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jwk;

import io.inverno.mod.security.jose.jwk.JWK;
import io.inverno.mod.security.jose.jwk.JWKGenerateException;
import io.inverno.mod.security.jose.jwk.JWKGenerator;
import io.inverno.mod.security.jose.jwk.JWKProcessingException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

public abstract class AbstractJWKGenerator<A extends JWK, B extends AbstractJWKGenerator<A, B>>
implements JWKGenerator<A, B> {
    private static Set<String> SIG_OPERATIONS = Set.of("sign", "verify");
    private static Set<String> ENC_OPERATIONS = Set.of("encrypt", "decrypt", "wrapKey", "unwrapKey");
    protected String use;
    protected Set<String> key_ops;
    protected String alg;
    protected String kid;

    public AbstractJWKGenerator() {
        this(null);
    }

    public AbstractJWKGenerator(Map<String, Object> parameters) throws JWKGenerateException {
        if (parameters != null) {
            parameters.forEach((k, v) -> {
                if (v != null) {
                    this.set((String)k, v);
                }
            });
        }
    }

    protected void set(String name, Object value) throws JWKGenerateException {
        switch (name) {
            case "kid": {
                this.keyId((String)value);
                break;
            }
            case "use": {
                this.publicKeyUse((String)value);
                break;
            }
            case "key_ops": {
                if (value instanceof String[]) {
                    this.keyOperations((String[])value);
                    break;
                }
                if (value instanceof Collection) {
                    this.keyOperations((String[])((Collection)value).toArray(String[]::new));
                    break;
                }
                throw new JWKGenerateException(String.valueOf(value.getClass()) + " can't be converted to String[]");
            }
        }
    }

    @Override
    public B publicKeyUse(String use) {
        this.use = use;
        return (B)this;
    }

    @Override
    public B keyOperations(String ... key_ops) {
        if (key_ops == null || key_ops.length == 0) {
            this.key_ops = null;
            return (B)this;
        }
        this.key_ops = new HashSet<String>();
        for (int i = 0; i < key_ops.length; ++i) {
            int current = i;
            Objects.requireNonNull(key_ops[i], () -> "Null key_op at index " + current);
            this.key_ops.add(key_ops[i]);
        }
        return (B)this;
    }

    @Override
    public B keyId(String kid) {
        this.kid = kid;
        return (B)this;
    }

    @Override
    public B algorithm(String alg) {
        this.alg = alg;
        return (B)this;
    }

    @Override
    public Mono<A> generate() throws JWKGenerateException, JWKProcessingException {
        return this.verify().then(this.doGenerate());
    }

    protected Mono<Void> verify() throws JWKGenerateException, JWKProcessingException {
        return Mono.fromRunnable(() -> {
            if (!(this.use == null || this.key_ops == null || this.key_ops.isEmpty() || this.use.equals("sig") && SIG_OPERATIONS.containsAll(this.key_ops) || this.use.equals("enc") && ENC_OPERATIONS.containsAll(this.key_ops))) {
                throw new JWKGenerateException("Key operations [" + this.key_ops.stream().collect(Collectors.joining(", ")) + "] are inconsistent with public key use " + this.use);
            }
        });
    }

    protected abstract Mono<A> doGenerate() throws JWKGenerateException, JWKProcessingException;
}

