/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jwk;

import io.inverno.mod.security.jose.JOSEConfiguration;
import io.inverno.mod.security.jose.jwk.JWK;
import io.inverno.mod.security.jose.jwk.JWKBuildException;
import io.inverno.mod.security.jose.jwk.JWKBuilder;
import io.inverno.mod.security.jose.jwk.JWKKeyResolver;
import io.inverno.mod.security.jose.jwk.JWKProcessingException;
import io.inverno.mod.security.jose.jwk.JWKReadException;
import io.inverno.mod.security.jose.jwk.JWKResolveException;
import io.inverno.mod.security.jose.jwk.JWKStore;
import java.security.Key;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

public abstract class AbstractJWKBuilder<A extends JWK, B extends AbstractJWKBuilder<A, B>>
implements JWKBuilder<A, B>,
Cloneable {
    private static final Set<String> SIG_OPERATIONS = Set.of("sign", "verify");
    private static final Set<String> ENC_OPERATIONS = Set.of("encrypt", "decrypt", "wrapKey", "unwrapKey");
    protected final JOSEConfiguration configuration;
    protected final JWKStore jwkStore;
    protected final JWKKeyResolver keyResolver;
    protected String use;
    protected Set<String> key_ops;
    protected String alg;
    protected String kid;
    protected volatile Key key;

    public AbstractJWKBuilder(JOSEConfiguration configuration, JWKStore jwkStore, JWKKeyResolver keyResolver) {
        this(configuration, jwkStore, keyResolver, null);
    }

    public AbstractJWKBuilder(JOSEConfiguration configuration, JWKStore jwkStore, JWKKeyResolver keyResolver, Map<String, Object> parameters) throws JWKReadException {
        this.configuration = configuration;
        this.jwkStore = jwkStore;
        this.keyResolver = keyResolver;
        if (parameters != null) {
            parameters.forEach((k, v) -> {
                if (v != null) {
                    this.set((String)k, v);
                }
            });
        }
    }

    protected void set(String name, Object value) throws JWKReadException {
        switch (name) {
            case "alg": {
                this.algorithm((String)value);
                break;
            }
            case "kid": {
                this.keyId((String)value);
                break;
            }
            case "use": {
                this.publicKeyUse((String)value);
                break;
            }
            case "key_ops": {
                if (value instanceof String[]) {
                    this.keyOperations((String[])value);
                    break;
                }
                if (value instanceof Collection) {
                    this.keyOperations((String[])((Collection)value).toArray(String[]::new));
                    break;
                }
                throw new JWKReadException(String.valueOf(value.getClass()) + " can't be converted to String[]");
            }
        }
    }

    @Override
    public B publicKeyUse(String use) {
        this.use = use;
        return (B)this;
    }

    @Override
    public B keyOperations(String ... key_ops) {
        this.key_ops = key_ops == null || key_ops.length == 0 ? null : Arrays.stream(key_ops).filter(Objects::nonNull).collect(Collectors.toSet());
        return (B)this;
    }

    @Override
    public B algorithm(String alg) {
        this.alg = alg;
        return (B)this;
    }

    @Override
    public B keyId(String kid) {
        this.kid = kid;
        return (B)this;
    }

    @Override
    public Mono<A> build() throws JWKBuildException, JWKResolveException, JWKProcessingException {
        return this.resolveFromJWKStore().switchIfEmpty(Mono.defer(() -> {
            try {
                AbstractJWKBuilder clone = (AbstractJWKBuilder)this.clone();
                return clone.resolve().then(clone.doBuild());
            }
            catch (CloneNotSupportedException e) {
                throw new JWKBuildException("Error cloning JWK builder", e);
            }
        }));
    }

    protected Mono<JWK> resolveFromJWKStore() throws JWKResolveException {
        return this.jwkStore.getByKeyId(this.kid);
    }

    protected Mono<Void> resolve() throws JWKBuildException, JWKResolveException, JWKProcessingException {
        return Mono.fromRunnable(() -> {
            if (!(this.use == null || this.key_ops == null || this.key_ops.isEmpty() || this.use.equals("sig") && SIG_OPERATIONS.containsAll(this.key_ops) || this.use.equals("enc") && ENC_OPERATIONS.containsAll(this.key_ops))) {
                throw new JWKBuildException("Key operations [" + this.key_ops.stream().collect(Collectors.joining(", ")) + "] are inconsistent with public key use " + this.use);
            }
        }).then(this.resolveKid());
    }

    protected abstract Mono<Void> resolveKey(Key var1) throws JWKBuildException, JWKResolveException, JWKProcessingException;

    private Mono<Void> resolveKid() throws JWKBuildException, JWKResolveException, JWKProcessingException {
        return this.keyResolver.resolveKeyFromKeyId(this.kid).flatMap(tmpKey -> this.resolveKey((Key)tmpKey).doOnSuccess(ign -> {
            this.key = tmpKey;
        }));
    }

    protected abstract Mono<A> doBuild() throws JWKBuildException, JWKProcessingException;
}

