/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jwk;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.inverno.mod.security.jose.jwa.JWAAlgorithm;
import io.inverno.mod.security.jose.jwa.JWACipher;
import io.inverno.mod.security.jose.jwa.JWAKeyManager;
import io.inverno.mod.security.jose.jwa.JWASigner;
import io.inverno.mod.security.jose.jwk.JWK;
import io.inverno.mod.security.jose.jwk.JWKProcessingException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractJWK
implements JWK {
    private static MessageDigest DEFAULT_THUMBPRINT_DIGEST;
    protected final Key key;
    protected final String kty;
    protected String use;
    protected Set<String> key_ops;
    protected String alg;
    protected String kid;
    protected boolean trusted;

    protected AbstractJWK(String kty) throws JWKProcessingException {
        this(kty, null, false);
    }

    protected AbstractJWK(String kty, Key key, boolean trusted) throws JWKProcessingException {
        if (StringUtils.isBlank((CharSequence)kty)) {
            throw new JWKProcessingException("Key type is blank");
        }
        this.kty = kty;
        this.key = key;
        this.trusted = trusted;
    }

    public static MessageDigest getDefaultThumbprintDigest() {
        if (DEFAULT_THUMBPRINT_DIGEST == null) {
            try {
                DEFAULT_THUMBPRINT_DIGEST = MessageDigest.getInstance("SHA-256");
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException(e);
            }
        }
        return DEFAULT_THUMBPRINT_DIGEST;
    }

    @Override
    public String getKeyType() {
        return this.kty;
    }

    @Override
    public String getPublicKeyUse() {
        return this.use;
    }

    public void setPublicKeyUse(String use) {
        this.use = use;
    }

    @Override
    public Set<String> getKeyOperations() {
        return this.key_ops;
    }

    public void setKeyOperations(Set<String> key_ops) {
        this.key_ops = key_ops != null && !key_ops.isEmpty() ? Collections.unmodifiableSet(key_ops) : null;
    }

    @Override
    public String getAlgorithm() {
        return this.alg;
    }

    public void setAlgorithm(String alg) {
        this.alg = alg;
    }

    @Override
    public String getKeyId() {
        return this.kid;
    }

    public void setKeyId(String kid) {
        this.kid = kid;
    }

    @JsonIgnore
    public Key getKey() {
        return this.key;
    }

    @Override
    @JsonIgnore
    public boolean isTrusted() {
        return this.trusted;
    }

    @Override
    public JWASigner signer() throws JWKProcessingException {
        throw new JWKProcessingException("JWK does not support signing operations");
    }

    @Override
    public JWASigner signer(String alg) throws JWKProcessingException {
        throw new JWKProcessingException("JWK does not support signing operations");
    }

    protected void checkSignature(JWAAlgorithm<?> algorithm) throws JWKProcessingException {
        if (algorithm == null) {
            throw new JWKProcessingException("Missing algorithm");
        }
        if (this.use != null && !this.use.equals("sig")) {
            throw new JWKProcessingException("JWK is not to be used for signature");
        }
        if (this.key_ops != null && !this.key_ops.contains("sign") && !this.key_ops.contains("verify")) {
            throw new JWKProcessingException("JWK does not support signing operations");
        }
        if (this.alg != null && !this.alg.equals(algorithm.getAlgorithm())) {
            throw new JWKProcessingException("JWK algorithm " + this.alg + " does not match " + String.valueOf(algorithm));
        }
    }

    @Override
    public JWACipher cipher() throws JWKProcessingException {
        throw new JWKProcessingException("JWK does not support encryption operations");
    }

    @Override
    public JWACipher cipher(String alg) throws JWKProcessingException {
        throw new JWKProcessingException("JWK does not support encryption operations");
    }

    protected void checkEncryption(JWAAlgorithm<?> algorithm) throws JWKProcessingException {
        if (algorithm == null) {
            throw new JWKProcessingException("Missing algorithm");
        }
        if (this.use != null && !this.use.equals("enc")) {
            throw new JWKProcessingException("JWK is not to be used for encryption");
        }
        if (this.key_ops != null && !this.key_ops.contains("encrypt") && !this.key_ops.contains("decrypt")) {
            throw new JWKProcessingException("JWK does not support encryption operations");
        }
        if (this.alg != null && !this.alg.equals(algorithm.getAlgorithm())) {
            throw new JWKProcessingException("JWK algorithm " + this.alg + " does not match " + String.valueOf(algorithm));
        }
    }

    @Override
    public JWAKeyManager keyManager() throws JWKProcessingException {
        throw new JWKProcessingException("JWK does not support key management operations");
    }

    @Override
    public JWAKeyManager keyManager(String alg) throws JWKProcessingException {
        throw new JWKProcessingException("JWK does not support key management operations");
    }

    protected void checkKeyManagement(JWAAlgorithm<?> algorithm) throws JWKProcessingException {
        if (algorithm == null) {
            throw new JWKProcessingException("Missing algorithm");
        }
        if (this.use != null && !this.use.equals("enc")) {
            throw new JWKProcessingException("JWK is not to be used for encryption");
        }
        if (!(this.key_ops == null || this.key_ops.contains("encrypt") || this.key_ops.contains("decrypt") || this.key_ops.contains("wrapKey") || this.key_ops.contains("unwrapKey") || this.key_ops.contains("deriveKey"))) {
            throw new JWKProcessingException("JWK does not support key management operations");
        }
        if (this.alg != null && !this.alg.equals(algorithm.getAlgorithm())) {
            throw new JWKProcessingException("JWK algorithm " + this.alg + " does not match " + String.valueOf(algorithm));
        }
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.alg, this.key_ops, this.kid, this.kty, this.use);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractJWK other = (AbstractJWK)obj;
        return Objects.equals(this.alg, other.alg) && Objects.equals(this.key_ops, other.key_ops) && Objects.equals(this.kid, other.kid) && Objects.equals(this.kty, other.kty) && Objects.equals(this.use, other.use);
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("{");
        str.append("\"kty\":\"").append(this.kty).append("\"");
        if (StringUtils.isNotBlank((CharSequence)this.kid)) {
            str.append(",\"kid\":\"").append(this.kid).append("\"");
        }
        if (StringUtils.isNotBlank((CharSequence)this.alg)) {
            str.append(",\"alg\":\"").append(this.alg).append("\"");
        }
        if (StringUtils.isNotBlank((CharSequence)this.use)) {
            str.append(",\"use\":\"").append(this.use).append("\"");
        }
        if (this.key_ops != null && !this.key_ops.isEmpty()) {
            str.append(",\"key_ops\":[").append(this.key_ops.stream().map(s -> "\"" + s + "\"").collect(Collectors.joining(", "))).append("]");
        }
        str.append("}");
        return str.toString();
    }
}

