/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jwe;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.inverno.mod.security.jose.JOSEObjectReadException;
import io.inverno.mod.security.jose.JOSEProcessingException;
import io.inverno.mod.security.jose.internal.converter.DataConversionService;
import io.inverno.mod.security.jose.internal.jwe.GenericJWEHeader;
import io.inverno.mod.security.jose.internal.jwe.GenericJWEReader;
import io.inverno.mod.security.jose.jwe.JWEReadException;
import io.inverno.mod.security.jose.jwe.JWEZip;
import io.inverno.mod.security.jose.jwk.JWK;
import io.inverno.mod.security.jose.jwk.JWKService;
import java.lang.reflect.Type;
import java.util.List;
import org.reactivestreams.Publisher;

public class RecipientJWEReader<A>
extends GenericJWEReader<A> {
    private final GenericJWEHeader jweHeader;
    private final byte[] aad;

    public RecipientJWEReader(ObjectMapper mapper, DataConversionService dataConversionService, JWKService jwkService, Type type, Publisher<? extends JWK> keys, List<JWEZip> zips, GenericJWEHeader jweHeader, byte[] aad) {
        super(mapper, dataConversionService, jwkService, type, keys, zips);
        this.jweHeader = jweHeader;
        this.aad = aad;
    }

    @Override
    protected GenericJWEHeader readJWEHeader(String encodedHeader) throws JWEReadException, JOSEObjectReadException, JOSEProcessingException {
        return this.jweHeader;
    }

    @Override
    protected byte[] getAdditionalAuthenticationData(GenericJWEHeader jweHeader) {
        return this.aad;
    }
}

