/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jwe;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.inverno.mod.security.jose.JOSEObjectBuildException;
import io.inverno.mod.security.jose.JOSEObjectReadException;
import io.inverno.mod.security.jose.JOSEProcessingException;
import io.inverno.mod.security.jose.internal.AbstractJsonJOSEObject;
import io.inverno.mod.security.jose.jwe.JWE;
import io.inverno.mod.security.jose.jwe.JWEBuildException;
import io.inverno.mod.security.jose.jwe.JWEHeader;
import io.inverno.mod.security.jose.jwe.JWEReadException;
import io.inverno.mod.security.jose.jwe.JsonJWE;
import io.inverno.mod.security.jose.jwk.JWK;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class GenericJsonJWE<A, B extends JsonJWE.Recipient<A>>
extends AbstractJsonJOSEObject<A>
implements JsonJWE<A, B> {
    private final JWEHeader protectedHeader;
    private final JWEHeader unprotectedHeader;
    private final String iv;
    private final String aad;
    private final String cipherText;
    private final String tag;
    private final List<B> recipients;

    public GenericJsonJWE(JWEHeader protectedHeader, JWEHeader unprotectedHeader, String iv, String aad, String cipherText, String tag, List<B> recipients, ObjectMapper mapper) {
        super(mapper);
        this.protectedHeader = protectedHeader;
        this.unprotectedHeader = unprotectedHeader;
        this.iv = iv;
        this.aad = aad;
        this.cipherText = cipherText;
        this.tag = tag;
        this.recipients = recipients;
    }

    @Override
    @JsonIgnore
    public JWEHeader getProtectedHeader() {
        return this.protectedHeader;
    }

    @JsonProperty(value="protected")
    public String getEncodedProtectedHeader() {
        return this.protectedHeader.getEncoded();
    }

    @Override
    @JsonProperty(value="unprotected")
    public JWEHeader getUnprotectedHeader() {
        return this.unprotectedHeader;
    }

    @Override
    @JsonProperty(value="iv")
    public String getInitializationVector() {
        return this.iv;
    }

    @Override
    @JsonProperty(value="aad")
    public String getAdditionalAuthenticationData() {
        return this.aad;
    }

    @Override
    @JsonProperty(value="ciphertext")
    public String getCipherText() {
        return this.cipherText;
    }

    @Override
    @JsonProperty(value="tag")
    public String getAuthenticationTag() {
        return this.tag;
    }

    @Override
    @JsonProperty(value="recipients")
    public List<B> getRecipients() {
        return this.recipients;
    }

    @Override
    public String toJson() throws JOSEProcessingException {
        if (this.recipients.size() == 1) {
            AbstractRecipient recipient = (AbstractRecipient)this.recipients.get(0);
            try {
                String tag;
                String ciphertext;
                String iv;
                String aad;
                String encrypted_key;
                JWEHeader header;
                JWEHeader unprotected;
                HashMap<String, Object> flattenedJsonJWE = new HashMap<String, Object>();
                String protected0 = this.getEncodedProtectedHeader();
                if (protected0 != null) {
                    flattenedJsonJWE.put("protected", protected0);
                }
                if ((unprotected = this.getUnprotectedHeader()) != null) {
                    flattenedJsonJWE.put("unprotected", unprotected);
                }
                if ((header = recipient.getHeader()) != null) {
                    flattenedJsonJWE.put("header", header);
                }
                if ((encrypted_key = recipient.getEncryptedKey()) != null) {
                    flattenedJsonJWE.put("encrypted_key", encrypted_key);
                }
                if ((aad = this.getAdditionalAuthenticationData()) != null) {
                    flattenedJsonJWE.put("aad", aad);
                }
                if ((iv = this.getInitializationVector()) != null) {
                    flattenedJsonJWE.put("iv", iv);
                }
                if ((ciphertext = this.getCipherText()) != null) {
                    flattenedJsonJWE.put("ciphertext", ciphertext);
                }
                if ((tag = this.getAuthenticationTag()) != null) {
                    flattenedJsonJWE.put("tag", tag);
                }
                return this.mapper.writeValueAsString(flattenedJsonJWE);
            }
            catch (JsonProcessingException e) {
                throw new JOSEProcessingException(e);
            }
        }
        return super.toJson();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.aad, this.cipherText, this.iv, this.protectedHeader, this.recipients, this.tag, this.unprotectedHeader);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GenericJsonJWE other = (GenericJsonJWE)obj;
        return Objects.equals(this.aad, other.aad) && Objects.equals(this.cipherText, other.cipherText) && Objects.equals(this.iv, other.iv) && Objects.equals(this.protectedHeader, other.protectedHeader) && Objects.equals(this.recipients, other.recipients) && Objects.equals(this.tag, other.tag) && Objects.equals(this.unprotectedHeader, other.unprotectedHeader);
    }

    public static abstract class AbstractRecipient<A>
    implements JsonJWE.Recipient<A> {
        protected final JWEHeader header;

        public AbstractRecipient(JWEHeader header) {
            this.header = header;
        }

        @Override
        @JsonProperty(value="header")
        public JWEHeader getHeader() {
            return this.header;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.header);
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AbstractRecipient other = (AbstractRecipient)obj;
            return Objects.equals(this.header, other.header);
        }
    }

    public static class GenericReadRecipient<A>
    extends AbstractRecipient<A>
    implements JsonJWE.ReadRecipient<A> {
        private final String encryptedKey;
        Function<Publisher<? extends JWK>, Mono<JWE<A>>> jweFactory;

        public GenericReadRecipient(JWEHeader header, String encryptedKey, Function<Publisher<? extends JWK>, Mono<JWE<A>>> jweFactory) {
            super(header);
            this.encryptedKey = encryptedKey;
            this.jweFactory = jweFactory;
        }

        @Override
        @JsonProperty(value="encrypted_key")
        public String getEncryptedKey() {
            return this.encryptedKey;
        }

        @Override
        public Mono<JWE<A>> readJWE() throws JWEReadException, JWEBuildException, JOSEObjectReadException, JOSEObjectBuildException, JOSEProcessingException {
            return this.jweFactory.apply(null);
        }

        @Override
        public Mono<JWE<A>> readJWE(Publisher<? extends JWK> keys) throws JWEReadException, JWEBuildException, JOSEObjectReadException, JOSEObjectBuildException, JOSEProcessingException {
            return this.jweFactory.apply(keys);
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + Objects.hash(this.encryptedKey);
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GenericReadRecipient other = (GenericReadRecipient)obj;
            return Objects.equals(this.encryptedKey, other.encryptedKey);
        }
    }

    public static class GenericBuiltRecipient<A>
    extends AbstractRecipient<A>
    implements JsonJWE.BuiltRecipient<A> {
        private final JWE<A> jwe;

        public GenericBuiltRecipient(JWEHeader header, JWE<A> jwe) {
            super(header);
            this.jwe = jwe;
        }

        @Override
        @JsonProperty(value="encrypted_key")
        public String getEncryptedKey() {
            return this.jwe.getEncryptedKey();
        }

        @Override
        @JsonIgnore
        public JWE<A> getJWE() {
            return this.jwe;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + Objects.hash(this.jwe);
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GenericBuiltRecipient other = (GenericBuiltRecipient)obj;
            return Objects.equals(this.jwe, other.jwe);
        }
    }
}

