/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jwa;

import io.inverno.mod.security.jose.internal.jwa.AbstractECDH_ES_AESKWKeyManager;
import io.inverno.mod.security.jose.internal.jwa.OKP_ECDH_ESKeyManager;
import io.inverno.mod.security.jose.jwa.DirectJWAKeyManager;
import io.inverno.mod.security.jose.jwa.JWAProcessingException;
import io.inverno.mod.security.jose.jwa.OCTAlgorithm;
import io.inverno.mod.security.jose.jwa.OKPCurve;
import io.inverno.mod.security.jose.jwa.XECAlgorithm;
import io.inverno.mod.security.jose.jwk.okp.XECJWK;
import java.security.interfaces.XECPrivateKey;
import java.security.interfaces.XECPublicKey;
import java.util.Map;
import java.util.Set;

public class OKP_ECDH_ES_AESKWKeyManager
extends AbstractECDH_ES_AESKWKeyManager<XECPublicKey, XECPrivateKey, XECJWK, XECAlgorithm> {
    public static final Set<XECAlgorithm> SUPPORTED_ALGORITHMS = Set.of(XECAlgorithm.ECDH_ES_A128KW, XECAlgorithm.ECDH_ES_A192KW, XECAlgorithm.ECDH_ES_A256KW);
    public static final Set<String> SUPPORTED_CURVES = Set.of(OKPCurve.X25519.getCurve(), OKPCurve.X448.getCurve());
    private OKP_ECDH_ESKeyManager ecdh_es_keyManager;
    private OCTAlgorithm keyWrappingAlgorithm;

    public OKP_ECDH_ES_AESKWKeyManager(XECJWK jwk, XECAlgorithm algorithm) throws JWAProcessingException {
        super(jwk, algorithm);
        if (!SUPPORTED_ALGORITHMS.contains(algorithm)) {
            throw new JWAProcessingException("Unsupported algorithm: " + algorithm.getAlgorithm());
        }
        if (!SUPPORTED_CURVES.contains(jwk.getCurve())) {
            throw new JWAProcessingException("Unsupported curve: " + jwk.getCurve());
        }
        this.init();
    }

    protected OKP_ECDH_ES_AESKWKeyManager(XECJWK jwk) {
        super(jwk);
    }

    @Override
    protected final void init() throws JWAProcessingException {
        this.ecdh_es_keyManager = new OKP_ECDH_ESKeyManager((XECJWK)this.jwk, XECAlgorithm.ECDH_ES);
        this.keyWrappingAlgorithm = OCTAlgorithm.fromAlgorithm(((XECAlgorithm)this.algorithm).getKeyWrappingAlgorithm());
    }

    @Override
    protected OCTAlgorithm getCEKWrappingAlgorithm() {
        return this.keyWrappingAlgorithm;
    }

    @Override
    protected DirectJWAKeyManager.DirectCEK deriveCEKWrappingKey(XECAlgorithm algorithm, Map<String, Object> parameters) {
        return this.ecdh_es_keyManager.deriveCEK(((XECAlgorithm)this.algorithm).getKeyWrappingAlgorithm(), parameters);
    }
}

