/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jwa;

import io.inverno.mod.security.jose.internal.jwa.AbstractECDH_ES_AESKWKeyManager;
import io.inverno.mod.security.jose.internal.jwa.ECDH_ESKeyManager;
import io.inverno.mod.security.jose.jwa.DirectJWAKeyManager;
import io.inverno.mod.security.jose.jwa.ECAlgorithm;
import io.inverno.mod.security.jose.jwa.JWAProcessingException;
import io.inverno.mod.security.jose.jwa.OCTAlgorithm;
import io.inverno.mod.security.jose.jwk.ec.ECJWK;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.util.Map;
import java.util.Set;

public class ECDH_ES_AESKWKeyManager
extends AbstractECDH_ES_AESKWKeyManager<ECPublicKey, ECPrivateKey, ECJWK, ECAlgorithm> {
    public static final Set<ECAlgorithm> SUPPORTED_ALGORITHMS = Set.of(ECAlgorithm.ECDH_ES_A128KW, ECAlgorithm.ECDH_ES_A192KW, ECAlgorithm.ECDH_ES_A256KW);
    private ECDH_ESKeyManager ecdh_es_keyManager;
    private OCTAlgorithm keyWrappingAlgorithm;

    public ECDH_ES_AESKWKeyManager(ECJWK jwk, ECAlgorithm algorithm) throws JWAProcessingException {
        super(jwk, algorithm);
        if (!SUPPORTED_ALGORITHMS.contains(algorithm)) {
            throw new JWAProcessingException("Unsupported algorithm: " + algorithm.getAlgorithm());
        }
        this.init();
    }

    protected ECDH_ES_AESKWKeyManager(ECJWK jwk) {
        super(jwk);
    }

    @Override
    protected final void init() throws JWAProcessingException {
        this.ecdh_es_keyManager = new ECDH_ESKeyManager((ECJWK)this.jwk, ECAlgorithm.ECDH_ES);
        this.keyWrappingAlgorithm = OCTAlgorithm.fromAlgorithm(((ECAlgorithm)this.algorithm).getKeyWrappingAlgorithm());
    }

    @Override
    protected OCTAlgorithm getCEKWrappingAlgorithm() {
        return this.keyWrappingAlgorithm;
    }

    @Override
    protected DirectJWAKeyManager.DirectCEK deriveCEKWrappingKey(ECAlgorithm algorithm, Map<String, Object> parameters) {
        return this.ecdh_es_keyManager.deriveCEK(((ECAlgorithm)this.algorithm).getKeyWrappingAlgorithm(), parameters);
    }
}

