/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jwa;

import io.inverno.mod.security.jose.internal.jwa.AbstractJWA;
import io.inverno.mod.security.jose.jwa.JWAAlgorithm;
import io.inverno.mod.security.jose.jwa.JWAProcessingException;
import io.inverno.mod.security.jose.jwa.JWASignatureException;
import io.inverno.mod.security.jose.jwa.JWASigner;
import io.inverno.mod.security.jose.jwk.JWK;

public abstract class AbstractJWASigner<A extends JWK, B extends JWAAlgorithm<A>>
extends AbstractJWA
implements JWASigner {
    protected final A jwk;
    protected B algorithm;

    public AbstractJWASigner(A jwk, B algorithm) throws JWAProcessingException {
        if (!algorithm.isSignature()) {
            throw new JWAProcessingException("Not a signature algorithm: " + algorithm.getAlgorithm());
        }
        this.jwk = jwk;
        this.algorithm = algorithm;
    }

    protected AbstractJWASigner(A jwk) {
        this.jwk = jwk;
    }

    @Override
    public final byte[] sign(byte[] data) throws JWASignatureException {
        if (this.jwk.getKeyOperations() != null && !this.jwk.getKeyOperations().contains("sign")) {
            throw new JWASignatureException("JWK does not support sign operation");
        }
        return this.doSign(data);
    }

    protected abstract byte[] doSign(byte[] var1) throws JWASignatureException;

    @Override
    public final boolean verify(byte[] data, byte[] signature) throws JWASignatureException {
        if (this.jwk.getKeyOperations() != null && !this.jwk.getKeyOperations().contains("verify")) {
            throw new JWASignatureException("JWK does not support verify operation");
        }
        return this.doVerify(data, signature);
    }

    protected abstract boolean doVerify(byte[] var1, byte[] var2) throws JWASignatureException;
}

