/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.converter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.inverno.core.annotation.Bean;
import io.inverno.mod.base.converter.ConverterException;
import io.inverno.mod.base.converter.MediaTypeConverter;
import io.inverno.mod.security.jose.internal.converter.JOSEMediaTypeConverter;
import io.inverno.mod.security.jose.jwe.JWEService;
import io.inverno.mod.security.jose.jwk.JWK;
import io.inverno.mod.security.jose.jwk.JWKService;
import io.inverno.mod.security.jose.jwk.JWKSet;
import io.inverno.mod.security.jose.jws.JWSService;
import io.inverno.mod.security.jose.jwt.JWTService;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Objects;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Bean(name="jwkSetJsonMediaTypeConverter")
public class JWKSetJsonMediaTypeConverter
implements JOSEMediaTypeConverter,
MediaTypeConverter<String> {
    private final JWKService jwkService;
    private final ObjectMapper mapper;

    public JWKSetJsonMediaTypeConverter(JWKService jwkService, ObjectMapper mapper) {
        this.jwkService = jwkService;
        this.mapper = mapper;
    }

    @Override
    public void injectJWSService(JWSService jwsService) {
    }

    @Override
    public void injectJWEService(JWEService jweService) {
    }

    @Override
    public void injectJWTService(JWTService jwtService) {
    }

    public boolean canConvert(String mediaType) {
        return mediaType.equalsIgnoreCase("application/jwk-set+json");
    }

    public <T> T decode(String value, Class<T> type) throws ConverterException {
        return this.decode(value, (Type)type);
    }

    public <T> T decode(String value, Type type) throws ConverterException {
        Objects.requireNonNull(value);
        this.checkJWKSetType(type);
        return (T)Flux.from(this.jwkService.read(value)).collectList().map(keys -> new JWKSet((JWK[])keys.toArray(JWK[]::new))).block();
    }

    public <T> Mono<T> decodeOne(Publisher<String> value, Class<T> type) {
        return this.decodeOne(value, (Type)type);
    }

    private void checkJWKSetType(Type type) throws ConverterException {
        Type rawType;
        if (type instanceof ParameterizedType ? !((rawType = ((ParameterizedType)type).getRawType()) instanceof Class) || !JWKSet.class.isAssignableFrom((Class)rawType) : !(type instanceof Class) || !JWKSet.class.isAssignableFrom((Class)type)) {
            throw new ConverterException("Invalid JWK Set type");
        }
    }

    public <T> Mono<T> decodeOne(Publisher<String> value, Type type) {
        return Mono.fromRunnable(() -> this.checkJWKSetType(type)).then(Flux.from(value).reduceWith(() -> new StringBuilder(), (acc, v) -> acc.append((String)v)).map(StringBuilder::toString).flatMapMany(jwk -> this.jwkService.read((String)jwk)).collectList().map(keys -> new JWKSet((JWK[])keys.toArray(JWK[]::new))));
    }

    public <T> Flux<T> decodeMany(Publisher<String> value, Class<T> type) {
        throw new UnsupportedOperationException();
    }

    public <T> Flux<T> decodeMany(Publisher<String> value, Type type) {
        throw new UnsupportedOperationException();
    }

    public <T> String encode(T value) throws ConverterException {
        Objects.requireNonNull(value);
        try {
            if (value instanceof JWKSet) {
                return this.mapper.writeValueAsString(value);
            }
            throw new ConverterException("Invalid JWKSet object: " + String.valueOf(value.getClass()));
        }
        catch (JsonProcessingException e) {
            throw new ConverterException((Throwable)e);
        }
    }

    public <T> String encode(T value, Class<T> type) throws ConverterException {
        return this.encode((Object)value, (Type)type);
    }

    public <T> String encode(T value, Type type) throws ConverterException {
        Objects.requireNonNull(value);
        try {
            if (value instanceof JWKSet) {
                return this.mapper.writerFor(this.mapper.constructType(type)).writeValueAsString(value);
            }
            throw new ConverterException("Invalid JWKSet object: " + String.valueOf(value.getClass()));
        }
        catch (JsonProcessingException e) {
            throw new ConverterException((Throwable)e);
        }
    }

    public <T> Publisher<String> encodeOne(Mono<T> value) {
        return value.map(jwkSet -> {
            try {
                if (jwkSet instanceof JWKSet) {
                    return this.mapper.writeValueAsString(jwkSet);
                }
                throw new ConverterException("Invalid JWKSet object: " + String.valueOf(jwkSet.getClass()));
            }
            catch (JsonProcessingException e) {
                throw new ConverterException((Throwable)e);
            }
        });
    }

    public <T> Publisher<String> encodeOne(Mono<T> value, Class<T> type) {
        return this.encodeOne(value, (Type)type);
    }

    public <T> Publisher<String> encodeOne(Mono<T> value, Type type) {
        return value.map(jwkSet -> {
            try {
                if (jwkSet instanceof JWKSet) {
                    return this.mapper.writerFor(this.mapper.constructType(type)).writeValueAsString(jwkSet);
                }
                throw new ConverterException("Invalid JWKSet object: " + String.valueOf(jwkSet.getClass()));
            }
            catch (JsonProcessingException e) {
                throw new ConverterException((Throwable)e);
            }
        });
    }

    public <T> Publisher<String> encodeMany(Flux<T> value) {
        throw new UnsupportedOperationException();
    }

    public <T> Publisher<String> encodeMany(Flux<T> value, Class<T> type) {
        throw new UnsupportedOperationException();
    }

    public <T> Publisher<String> encodeMany(Flux<T> value, Type type) {
        throw new UnsupportedOperationException();
    }
}

