/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.inverno.mod.security.jose.jwk.JWK;
import java.net.URI;
import java.util.Map;
import java.util.Set;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public interface JOSEHeader {
    @JsonProperty(value="alg")
    public String getAlgorithm();

    @JsonProperty(value="jku")
    public URI getJWKSetURL();

    @JsonProperty(value="jwk")
    public Map<String, Object> getJWK();

    @JsonProperty(value="kid")
    public String getKeyId();

    @JsonProperty(value="x5u")
    public URI getX509CertificateURL();

    @JsonProperty(value="x5c")
    public String[] getX509CertificateChain();

    @JsonProperty(value="x5t")
    public String getX509CertificateSHA1Thumbprint();

    @JsonProperty(value="x5t#S256")
    public String getX509CertificateSHA256Thumbprint();

    @JsonProperty(value="typ")
    public String getType();

    @JsonProperty(value="cty")
    public String getContentType();

    @JsonProperty(value="crit")
    public Set<String> getCritical();

    @JsonAnyGetter
    public Map<String, Object> getCustomParameters();

    @JsonIgnore
    public JWK getKey();

    @JsonIgnore
    public String getEncoded();

    public int hashCode();

    public boolean equals(Object var1);
}

