/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.jwt;

import io.inverno.mod.security.jose.jwt.ExpiredJWTException;
import io.inverno.mod.security.jose.jwt.InactiveJWTException;
import io.inverno.mod.security.jose.jwt.InvalidJWTException;
import io.inverno.mod.security.jose.jwt.JWTClaimsSet;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Set;

@FunctionalInterface
public interface JWTClaimsSetValidator {
    public void validate(JWTClaimsSet var1) throws InvalidJWTException;

    public static JWTClaimsSetValidator issuer(String iss) {
        return claims -> {
            if (iss != null && !iss.equals(claims.getIssuer())) {
                throw new InvalidJWTException("Invalid issuer: " + claims.getIssuer());
            }
        };
    }

    public static JWTClaimsSetValidator audience(Set<String> aud) {
        return claims -> {
            if (aud != null && !aud.isEmpty() && !aud.contains(claims.getAudience())) {
                throw new InvalidJWTException("Invalid audience: " + claims.getAudience());
            }
        };
    }

    public static JWTClaimsSetValidator subject(String sub) {
        return claims -> {
            if (sub != null && !sub.equals(claims.getSubject())) {
                throw new InvalidJWTException("Invalid subject: " + claims.getSubject());
            }
        };
    }

    public static JWTClaimsSetValidator expiration() {
        return claims -> {
            ZonedDateTime now = ZonedDateTime.now(ZoneOffset.UTC);
            ZonedDateTime exp = claims.getExpirationTimeAsDateTime();
            if (exp != null && now.isAfter(exp)) {
                throw new ExpiredJWTException("Token has expired");
            }
        };
    }

    public static JWTClaimsSetValidator expiration(ZonedDateTime time) {
        return claims -> {
            ZonedDateTime exp = claims.getExpirationTimeAsDateTime();
            if (exp != null && time.isAfter(exp)) {
                throw new ExpiredJWTException("Token has expired");
            }
        };
    }

    public static JWTClaimsSetValidator notBefore() {
        return claims -> {
            ZonedDateTime now = ZonedDateTime.now(ZoneOffset.UTC);
            ZonedDateTime nbf = claims.getNotBeforeAsDateTime();
            if (nbf != null && now.isBefore(nbf)) {
                throw new InactiveJWTException("Token is not active yet");
            }
        };
    }

    public static JWTClaimsSetValidator notBefore(ZonedDateTime time) {
        return claims -> {
            ZonedDateTime nbf = claims.getNotBeforeAsDateTime();
            if (nbf != null && time.isBefore(nbf)) {
                throw new InactiveJWTException("Token is not active yet");
            }
        };
    }
}

