/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.jwt;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.inverno.mod.base.converter.Convertible;
import io.inverno.mod.base.converter.ObjectDecoder;
import io.inverno.mod.security.jose.internal.jwt.StringOrURI;
import io.inverno.mod.security.jose.jwt.InvalidJWTException;
import io.inverno.mod.security.jose.jwt.JWTBuildException;
import io.inverno.mod.security.jose.jwt.JWTClaimsSetValidator;
import java.io.File;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.Currency;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Pattern;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class JWTClaimsSet {
    private final StringOrURI iss;
    private final StringOrURI sub;
    private final String aud;
    private final ZonedDateTime exp;
    private final ZonedDateTime nbf;
    private final ZonedDateTime iat;
    private final String jti;
    @JsonAnySetter
    private final Map<String, Object> customClaims;
    @JsonIgnore
    private final List<JWTClaimsSetValidator> validators;

    @JsonCreator
    public JWTClaimsSet(@JsonProperty(value="iss") String iss, @JsonProperty(value="sub") String sub, @JsonProperty(value="aud") String aud, @JsonProperty(value="exp") Long exp, @JsonProperty(value="nbf") Long nbf, @JsonProperty(value="iat") Long iat, @JsonProperty(value="jti") String jti) throws JWTBuildException {
        this.iss = iss != null ? new StringOrURI(iss) : null;
        this.sub = sub != null ? new StringOrURI(sub) : null;
        this.aud = aud;
        this.exp = exp != null ? ZonedDateTime.ofInstant(Instant.ofEpochSecond(exp), ZoneOffset.UTC) : null;
        this.nbf = nbf != null ? ZonedDateTime.ofInstant(Instant.ofEpochSecond(nbf), ZoneOffset.UTC) : null;
        this.iat = iat != null ? ZonedDateTime.ofInstant(Instant.ofEpochSecond(iat), ZoneOffset.UTC) : null;
        this.jti = jti;
        this.customClaims = new HashMap<String, Object>();
        this.validators = new LinkedList<JWTClaimsSetValidator>();
        this.validate(JWTClaimsSetValidator.expiration()).validate(JWTClaimsSetValidator.notBefore());
    }

    public JWTClaimsSet(@JsonProperty(value="iss") String iss, @JsonProperty(value="sub") String sub, @JsonProperty(value="aud") String aud, @JsonProperty(value="exp") Long exp, @JsonProperty(value="nbf") Long nbf, @JsonProperty(value="iat") Long iat, @JsonProperty(value="jti") String jti, Map<String, Object> customClaims) throws JWTBuildException {
        this.iss = iss != null ? new StringOrURI(iss) : null;
        this.sub = sub != null ? new StringOrURI(sub) : null;
        this.aud = aud;
        this.exp = exp != null ? ZonedDateTime.ofInstant(Instant.ofEpochSecond(exp), ZoneOffset.UTC) : null;
        this.nbf = nbf != null ? ZonedDateTime.ofInstant(Instant.ofEpochSecond(nbf), ZoneOffset.UTC) : null;
        this.iat = iat != null ? ZonedDateTime.ofInstant(Instant.ofEpochSecond(iat), ZoneOffset.UTC) : null;
        this.jti = jti;
        this.customClaims = customClaims;
        this.validators = new LinkedList<JWTClaimsSetValidator>();
        this.validate(JWTClaimsSetValidator.expiration()).validate(JWTClaimsSetValidator.notBefore());
    }

    protected JWTClaimsSet(String iss, URI iss_uri, String sub, URI sub_uri, String aud, ZonedDateTime exp, ZonedDateTime nbf, ZonedDateTime iat, String jti, Map<String, Object> customClaims) throws JWTBuildException {
        if (iss != null && iss_uri != null) {
            throw new JWTBuildException("Cannot define issuer as both String and URI");
        }
        if (sub != null && sub_uri != null) {
            throw new JWTBuildException("Cannot define subject as both String and URI");
        }
        this.iss = iss != null ? new StringOrURI(iss) : (iss_uri != null ? new StringOrURI(iss_uri) : null);
        this.sub = sub != null ? new StringOrURI(sub) : (iss_uri != null ? new StringOrURI(sub_uri) : null);
        this.aud = aud;
        this.exp = exp;
        this.nbf = nbf;
        this.iat = iat;
        this.jti = jti;
        this.customClaims = customClaims != null ? Collections.unmodifiableMap(customClaims) : null;
        this.validators = new LinkedList<JWTClaimsSetValidator>();
        this.validate(JWTClaimsSetValidator.expiration()).validate(JWTClaimsSetValidator.notBefore());
    }

    @JsonProperty(value="iss")
    public String getIssuer() {
        return this.iss != null ? this.iss.asString() : null;
    }

    @JsonIgnore
    public URI getIssuerAsURI() {
        return this.iss != null ? this.iss.asURI() : null;
    }

    @JsonProperty(value="sub")
    public String getSubject() {
        return this.sub != null ? this.sub.asString() : null;
    }

    @JsonIgnore
    public URI getSubjectAsURI() {
        return this.sub != null ? this.sub.asURI() : null;
    }

    @JsonProperty(value="aud")
    public String getAudience() {
        return this.aud;
    }

    @JsonProperty(value="exp")
    public Long getExpirationTime() {
        return this.exp != null ? Long.valueOf(this.exp.toEpochSecond()) : null;
    }

    @JsonIgnore
    public ZonedDateTime getExpirationTimeAsDateTime() {
        return this.exp;
    }

    @JsonProperty(value="nbf")
    public Long getNotBefore() {
        return this.nbf != null ? Long.valueOf(this.nbf.toEpochSecond()) : null;
    }

    @JsonIgnore
    public ZonedDateTime getNotBeforeAsDateTime() {
        return this.nbf;
    }

    @JsonProperty(value="iat")
    public Long getIssuedAt() {
        return this.iat != null ? Long.valueOf(this.iat.toEpochSecond()) : null;
    }

    @JsonIgnore
    public ZonedDateTime getIssuedAtAsDateTime() {
        return this.iat;
    }

    @JsonProperty(value="jti")
    public String getJWTId() {
        return this.jti;
    }

    @JsonAnyGetter
    public final Map<String, Object> getCustomClaims() {
        return this.customClaims;
    }

    public final Optional<Claim> getCustomClaim(String name) {
        return Optional.ofNullable(this.customClaims.get(name)).map(value -> new GenericJWTClaim(name, value));
    }

    public final JWTClaimsSet validate(JWTClaimsSetValidator validator) {
        this.validators.add(validator);
        return this;
    }

    public final void setValidators(List<JWTClaimsSetValidator> validators) {
        this.validators.clear();
        if (validators != null) {
            for (JWTClaimsSetValidator validator : validators) {
                this.validators.add(validator);
            }
        }
    }

    public final List<JWTClaimsSetValidator> getValidators() {
        return Collections.unmodifiableList(this.validators);
    }

    protected void validate() throws InvalidJWTException {
        this.validators.stream().forEach(validator -> validator.validate(this));
    }

    @JsonIgnore
    public final boolean isValid() {
        try {
            this.validate();
            return true;
        }
        catch (InvalidJWTException e) {
            return false;
        }
    }

    public final void ifValid(Runnable action) {
        if (this.isValid()) {
            action.run();
        }
    }

    public final void ifValidOrElse(Runnable action, Runnable invalidAction) {
        if (this.isValid()) {
            action.run();
        } else {
            invalidAction.run();
        }
    }

    public final JWTClaimsSet ifInvalidThrow() throws InvalidJWTException {
        this.validate();
        return this;
    }

    public <T extends Throwable> JWTClaimsSet ifInvalidThrow(Supplier<? extends T> exceptionSupplier) throws T {
        if (!this.isValid()) {
            throw (Throwable)exceptionSupplier.get();
        }
        return this;
    }

    public static Builder<JWTClaimsSet, ?> of() {
        return new GenericJWTClaimsSetBuilder();
    }

    public static Builder<JWTClaimsSet, ?> of(String iss, long exp) {
        return new GenericJWTClaimsSetBuilder().issuer(iss).expirationTime(exp);
    }

    public int hashCode() {
        return Objects.hash(this.aud, this.customClaims, this.exp, this.iat, this.iss, this.jti, this.nbf, this.sub);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JWTClaimsSet other = (JWTClaimsSet)obj;
        return Objects.equals(this.aud, other.aud) && Objects.equals(this.customClaims, other.customClaims) && Objects.equals(this.exp, other.exp) && Objects.equals(this.iat, other.iat) && Objects.equals(this.iss, other.iss) && Objects.equals(this.jti, other.jti) && Objects.equals(this.nbf, other.nbf) && Objects.equals(this.sub, other.sub);
    }

    private static class GenericJWTClaimsSetBuilder
    implements Builder<JWTClaimsSet, GenericJWTClaimsSetBuilder> {
        private String iss;
        private URI iss_uri;
        private String sub;
        private URI sub_uri;
        private String aud;
        private ZonedDateTime exp;
        private ZonedDateTime nbf;
        private ZonedDateTime iat;
        private String jti;
        private Map<String, Object> customClaims;

        @Override
        public GenericJWTClaimsSetBuilder issuer(String iss) {
            this.iss = iss;
            return this;
        }

        @Override
        public GenericJWTClaimsSetBuilder issuer(URI iss) {
            this.iss_uri = iss;
            return this;
        }

        @Override
        public GenericJWTClaimsSetBuilder subject(String sub) {
            this.sub = sub;
            return this;
        }

        @Override
        public GenericJWTClaimsSetBuilder subject(URI sub) {
            this.sub_uri = sub;
            return this;
        }

        @Override
        public GenericJWTClaimsSetBuilder audience(String aud) {
            this.aud = aud;
            return this;
        }

        @Override
        public GenericJWTClaimsSetBuilder expirationTime(Long exp) {
            this.exp = ZonedDateTime.ofInstant(Instant.ofEpochSecond(exp), ZoneOffset.UTC);
            return this;
        }

        @Override
        public GenericJWTClaimsSetBuilder expirationTime(ZonedDateTime exp) {
            this.exp = exp;
            return this;
        }

        @Override
        public GenericJWTClaimsSetBuilder notBefore(Long nbf) {
            this.nbf = ZonedDateTime.ofInstant(Instant.ofEpochSecond(nbf), ZoneOffset.UTC);
            return this;
        }

        @Override
        public GenericJWTClaimsSetBuilder notBefore(ZonedDateTime nbf) {
            this.nbf = nbf;
            return this;
        }

        @Override
        public GenericJWTClaimsSetBuilder issuedAt(Long iat) {
            this.nbf = ZonedDateTime.ofInstant(Instant.ofEpochSecond(iat), ZoneOffset.UTC);
            return this;
        }

        @Override
        public GenericJWTClaimsSetBuilder issuedAt(ZonedDateTime iat) {
            this.iat = iat;
            return this;
        }

        @Override
        public GenericJWTClaimsSetBuilder jwtId(String jti) {
            this.jti = jti;
            return this;
        }

        @Override
        public GenericJWTClaimsSetBuilder addCustomClaim(String name, Object value) {
            if (this.customClaims == null) {
                this.customClaims = new HashMap<String, Object>();
            }
            this.customClaims.put(name, value);
            return this;
        }

        @Override
        public JWTClaimsSet build() throws JWTBuildException {
            return new JWTClaimsSet(this.iss, this.iss_uri, this.sub, this.sub_uri, this.aud, this.exp, this.nbf, this.iat, this.jti, this.customClaims);
        }
    }

    private static class GenericJWTClaim
    implements Claim {
        private static final ObjectDecoder OBJECT_DECODER = new ObjectDecoder();
        private final String name;
        private final Object value;

        public GenericJWTClaim(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }

        public <T> T as(Class<T> type) {
            return (T)OBJECT_DECODER.decode(this.value, type);
        }

        public <T> T as(Type type) {
            return (T)OBJECT_DECODER.decode(this.value, type);
        }

        public <T> T[] asArrayOf(Class<T> type) {
            return OBJECT_DECODER.decodeToArray(this.value, type);
        }

        public <T> T[] asArrayOf(Type type) {
            return OBJECT_DECODER.decodeToArray(this.value, type);
        }

        public <T> List<T> asListOf(Class<T> type) {
            return OBJECT_DECODER.decodeToList(this.value, type);
        }

        public <T> List<T> asListOf(Type type) {
            return OBJECT_DECODER.decodeToList(this.value, type);
        }

        public <T> Set<T> asSetOf(Class<T> type) {
            return OBJECT_DECODER.decodeToSet(this.value, type);
        }

        public <T> Set<T> asSetOf(Type type) {
            return OBJECT_DECODER.decodeToSet(this.value, type);
        }

        public Byte asByte() {
            return OBJECT_DECODER.decodeByte(this.value);
        }

        public Short asShort() {
            return OBJECT_DECODER.decodeShort(this.value);
        }

        public Integer asInteger() {
            return OBJECT_DECODER.decodeInteger(this.value);
        }

        public Long asLong() {
            return OBJECT_DECODER.decodeLong(this.value);
        }

        public Float asFloat() {
            return OBJECT_DECODER.decodeFloat(this.value);
        }

        public Double asDouble() {
            return OBJECT_DECODER.decodeDouble(this.value);
        }

        public Character asCharacter() {
            return OBJECT_DECODER.decodeCharacter(this.value);
        }

        public String asString() {
            return OBJECT_DECODER.decodeString(this.value);
        }

        public Boolean asBoolean() {
            return OBJECT_DECODER.decodeBoolean(this.value);
        }

        public BigInteger asBigInteger() {
            return OBJECT_DECODER.decodeBigInteger(this.value);
        }

        public BigDecimal asBigDecimal() {
            return OBJECT_DECODER.decodeBigDecimal(this.value);
        }

        public LocalDate asLocalDate() {
            return OBJECT_DECODER.decodeLocalDate(this.value);
        }

        public LocalDateTime asLocalDateTime() {
            return OBJECT_DECODER.decodeLocalDateTime(this.value);
        }

        public ZonedDateTime asZonedDateTime() {
            return OBJECT_DECODER.decodeZonedDateTime(this.value);
        }

        public Currency asCurrency() {
            return OBJECT_DECODER.decodeCurrency(this.value);
        }

        public Locale asLocale() {
            return OBJECT_DECODER.decodeLocale(this.value);
        }

        public File asFile() {
            return OBJECT_DECODER.decodeFile(this.value);
        }

        public Path asPath() {
            return OBJECT_DECODER.decodePath(this.value);
        }

        public URI asURI() {
            return OBJECT_DECODER.decodeURI(this.value);
        }

        public URL asURL() {
            return OBJECT_DECODER.decodeURL(this.value);
        }

        public Pattern asPattern() {
            return OBJECT_DECODER.decodePattern(this.value);
        }

        public InetAddress asInetAddress() {
            return OBJECT_DECODER.decodeInetAddress(this.value);
        }

        public Class<?> asClass() {
            return OBJECT_DECODER.decodeClass(this.value);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.value);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GenericJWTClaim other = (GenericJWTClaim)obj;
            return Objects.equals(this.name, other.name) && Objects.equals(this.value, other.value);
        }
    }

    public static interface Builder<A extends JWTClaimsSet, B extends Builder<A, B>> {
        public B issuer(String var1);

        public B issuer(URI var1);

        public B subject(String var1);

        public B subject(URI var1);

        public B audience(String var1);

        public B expirationTime(Long var1);

        public B expirationTime(ZonedDateTime var1);

        public B notBefore(Long var1);

        public B notBefore(ZonedDateTime var1);

        public B issuedAt(Long var1);

        public B issuedAt(ZonedDateTime var1);

        public B jwtId(String var1);

        public B addCustomClaim(String var1, Object var2);

        public A build() throws JWTBuildException;
    }

    public static interface Claim
    extends Convertible<Object> {
        public String getName();
    }
}

