/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.jws;

import io.inverno.mod.security.authentication.Authentication;
import io.inverno.mod.security.authentication.Authenticator;
import io.inverno.mod.security.authentication.TokenCredentials;
import io.inverno.mod.security.jose.JOSEProcessingException;
import io.inverno.mod.security.jose.jwk.JWK;
import io.inverno.mod.security.jose.jws.JWSAuthentication;
import io.inverno.mod.security.jose.jws.JWSReader;
import io.inverno.mod.security.jose.jws.JWSService;
import java.lang.reflect.Type;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class JWSAuthenticator<A extends Authentication>
implements Authenticator<TokenCredentials, JWSAuthentication<A>> {
    private final JWSService jwsService;
    private final Type authenticationType;
    private final Publisher<? extends JWK> keys;
    private final String[] processedParameters;

    public JWSAuthenticator(JWSService jwsService, Class<A> authenticationType) {
        this(jwsService, (Type)authenticationType, (Publisher<JWK>)((Publisher<? extends JWK>)((Publisher)null)), (String[])null);
    }

    public JWSAuthenticator(JWSService jwsService, Type authenticationType) {
        this(jwsService, authenticationType, (Publisher<? extends JWK>)((Publisher)null), (String[])null);
    }

    public JWSAuthenticator(JWSService jwsService, Class<A> authenticationType, Publisher<? extends JWK> keys) {
        this(jwsService, (Type)authenticationType, (Publisher<JWK>)keys, (String[])null);
    }

    public JWSAuthenticator(JWSService jwsService, Type authenticationType, Publisher<? extends JWK> keys) {
        this(jwsService, authenticationType, keys, (String[])null);
    }

    public JWSAuthenticator(JWSService jwsService, Class<A> authenticationType, String ... processedParameters) {
        this(jwsService, (Type)authenticationType, (Publisher<JWK>)((Publisher<? extends JWK>)((Publisher)null)), processedParameters);
    }

    public JWSAuthenticator(JWSService jwsService, Type authenticationType, String ... processedParameters) {
        this(jwsService, authenticationType, (Publisher<? extends JWK>)((Publisher)null), processedParameters);
    }

    public JWSAuthenticator(JWSService jwsService, Class<A> authenticationType, Publisher<? extends JWK> keys, String ... processedParameters) {
        this(jwsService, (Type)authenticationType, (Publisher<JWK>)keys, processedParameters);
    }

    public JWSAuthenticator(JWSService jwsService, Type authenticationType, Publisher<? extends JWK> keys, String ... processedParameters) {
        this.jwsService = jwsService;
        this.keys = keys;
        this.authenticationType = authenticationType;
        this.processedParameters = processedParameters;
    }

    public Mono<JWSAuthentication<A>> authenticate(TokenCredentials credentials) {
        return ((JWSReader)this.jwsService.reader(this.authenticationType, (Publisher)this.keys).processedParameters(this.processedParameters)).read(credentials.getToken(), "application/json").map(JWSAuthentication::new).onErrorResume(JOSEProcessingException.class, e -> Mono.just(new JWSAuthentication((JOSEProcessingException)e)));
    }
}

