/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jwt;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.inverno.mod.security.jose.JOSEObjectBuildException;
import io.inverno.mod.security.jose.JOSEObjectReadException;
import io.inverno.mod.security.jose.JOSEProcessingException;
import io.inverno.mod.security.jose.internal.converter.GenericDataConversionService;
import io.inverno.mod.security.jose.internal.jws.GenericJWSReader;
import io.inverno.mod.security.jose.jwk.JWK;
import io.inverno.mod.security.jose.jwk.JWKService;
import io.inverno.mod.security.jose.jws.JWS;
import io.inverno.mod.security.jose.jws.JWSBuildException;
import io.inverno.mod.security.jose.jws.JWSHeader;
import io.inverno.mod.security.jose.jws.JWSReadException;
import io.inverno.mod.security.jose.jwt.JWTClaimsSet;
import io.inverno.mod.security.jose.jwt.JWTReadException;
import java.lang.reflect.Type;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

class JWTSReader<A extends JWTClaimsSet>
extends GenericJWSReader<A> {
    public JWTSReader(ObjectMapper mapper, GenericDataConversionService dataConversionService, JWKService jwkService, Type type, Publisher<? extends JWK> keys) {
        super(mapper, dataConversionService, jwkService, type, keys);
    }

    @Override
    protected void checkHeader(JWSHeader header) throws JWSReadException, JWSBuildException, JOSEObjectReadException, JOSEObjectBuildException, JOSEProcessingException {
        super.checkHeader(header);
        String joseType = header.getType();
        if (joseType != null && !joseType.equals("JWT")) {
            throw new JWTReadException("Invalid JWT, type is not set to JWT: " + joseType);
        }
        String joseContentType = header.getContentType();
        if (joseContentType != null) {
            throw new JWTReadException("Invalid JWT, content type must not be set: " + joseContentType);
        }
    }

    @Override
    public Mono<JWS<A>> read(String compact, String contentType) throws JWTReadException, JWSReadException, JWSBuildException, JOSEObjectReadException, JOSEObjectBuildException, JOSEProcessingException {
        return super.read(compact, "application/json");
    }
}

