/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jwt;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.inverno.mod.security.jose.JOSEObjectBuildException;
import io.inverno.mod.security.jose.JOSEProcessingException;
import io.inverno.mod.security.jose.internal.converter.DataConversionService;
import io.inverno.mod.security.jose.internal.jws.GenericJWSBuilder;
import io.inverno.mod.security.jose.jwk.JWK;
import io.inverno.mod.security.jose.jwk.JWKService;
import io.inverno.mod.security.jose.jws.JWS;
import io.inverno.mod.security.jose.jws.JWSBuildException;
import io.inverno.mod.security.jose.jws.JWSHeader;
import io.inverno.mod.security.jose.jwt.JWTBuildException;
import io.inverno.mod.security.jose.jwt.JWTClaimsSet;
import java.lang.reflect.Type;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

class JWTSBuilder<A extends JWTClaimsSet>
extends GenericJWSBuilder<A> {
    public JWTSBuilder(ObjectMapper mapper, DataConversionService dataConversionService, JWKService jwkService, Type type, Publisher<? extends JWK> keys) {
        super(mapper, dataConversionService, jwkService, type, keys);
    }

    @Override
    public Mono<JWS<A>> build(String contentType) throws JWSBuildException, JOSEObjectBuildException, JOSEProcessingException {
        return super.build("application/json");
    }

    @Override
    protected void checkHeader(JWSHeader header) throws JWTBuildException, JWSBuildException, JOSEObjectBuildException, JOSEProcessingException {
        super.checkHeader(header);
        if (header.getContentType() != null) {
            throw new JWTBuildException("Content type is not allowed in JWT header: " + header.getContentType());
        }
        String headerType = header.getType();
        if (headerType != null && !headerType.equals("JWT")) {
            throw new JWTBuildException("Type must be JWT: " + headerType);
        }
    }
}

