/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jws;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.inverno.mod.security.jose.JOSEObjectBuildException;
import io.inverno.mod.security.jose.JOSEProcessingException;
import io.inverno.mod.security.jose.internal.AbstractJOSEObjectBuilder;
import io.inverno.mod.security.jose.internal.JOSEUtils;
import io.inverno.mod.security.jose.internal.converter.DataConversionService;
import io.inverno.mod.security.jose.internal.jws.GenericJWS;
import io.inverno.mod.security.jose.internal.jws.GenericJWSHeader;
import io.inverno.mod.security.jose.internal.jws.GenericJWSPayload;
import io.inverno.mod.security.jose.jwa.NoAlgorithm;
import io.inverno.mod.security.jose.jwk.JWK;
import io.inverno.mod.security.jose.jwk.JWKService;
import io.inverno.mod.security.jose.jws.JWS;
import io.inverno.mod.security.jose.jws.JWSBuildException;
import io.inverno.mod.security.jose.jws.JWSBuilder;
import io.inverno.mod.security.jose.jws.JWSHeader;
import java.lang.reflect.Type;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class GenericJWSBuilder<A>
extends AbstractJOSEObjectBuilder<A, JWSHeader, JWS<A>, GenericJWSHeader, GenericJWSBuilder<A>>
implements JWSBuilder<A, GenericJWSHeader, GenericJWSBuilder<A>> {
    private static final Logger LOGGER = LogManager.getLogger(GenericJWSBuilder.class);
    protected Consumer<GenericJWSHeader> headerConfigurer;

    public GenericJWSBuilder(ObjectMapper mapper, DataConversionService dataConversionService, JWKService jwkService, Type type, Publisher<? extends JWK> keys) {
        super(mapper, dataConversionService, jwkService, type, keys);
    }

    @Override
    public GenericJWSBuilder<A> header(Consumer<GenericJWSHeader> configurer) {
        this.headerConfigurer = configurer;
        return this;
    }

    @Override
    public Mono<JWS<A>> build(String contentType) throws JWSBuildException, JOSEObjectBuildException, JOSEProcessingException {
        return this.build(null, contentType);
    }

    @Override
    public Mono<JWS<A>> build(Function<A, Mono<String>> payloadEncoder) throws JWSBuildException, JOSEObjectBuildException, JOSEProcessingException {
        return this.build(payloadEncoder, null);
    }

    private Mono<JWS<A>> build(Function<A, Mono<String>> overridingPayloadEncoder, String overridingContentType) throws JWSBuildException, JOSEObjectBuildException, JOSEProcessingException {
        GenericJWSHeader jwsHeader = this.buildJWSHeader();
        return this.buildJWSPayload(overridingPayloadEncoder, overridingContentType, jwsHeader).flatMap(jwsPayload -> this.build(jwsHeader, (GenericJWSPayload<A>)jwsPayload, (Flux<? extends JWK>)this.getKeys(jwsHeader)));
    }

    private Mono<JWS<A>> build(GenericJWSHeader jwsHeader, GenericJWSPayload<A> jwsPayload, Flux<? extends JWK> keys) throws JWSBuildException, JOSEObjectBuildException, JOSEProcessingException {
        String signingHeader = jwsHeader.getEncoded();
        int signingHeaderLength = signingHeader.length();
        String signingPayload = jwsHeader.isBase64EncodePayload() == null || jwsHeader.isBase64EncodePayload() != false ? jwsPayload.getEncoded() : jwsPayload.getRaw();
        int signingPayloadLength = signingPayload.length();
        byte[] signingInput = new byte[signingHeaderLength + signingPayloadLength + 1];
        System.arraycopy(signingHeader.getBytes(), 0, signingInput, 0, signingHeaderLength);
        signingInput[signingHeaderLength] = 46;
        System.arraycopy(signingPayload.getBytes(), 0, signingInput, signingHeaderLength + 1, signingPayloadLength);
        if (jwsHeader.getAlgorithm().equals(NoAlgorithm.NONE.getAlgorithm())) {
            return Mono.just(new GenericJWS<A>(jwsHeader, jwsPayload, null));
        }
        return Mono.defer(() -> {
            JWSBuildException error = new JWSBuildException("Failed to build JWS");
            return keys.onErrorStop().map(key -> {
                String joseSignature = JOSEUtils.BASE64_NOPAD_URL_ENCODER.encodeToString(key.signer(jwsHeader.getAlgorithm()).sign(signingInput));
                jwsHeader.setKey((JWK)key);
                return new GenericJWS(jwsHeader, jwsPayload, joseSignature);
            }).onErrorContinue((e, key) -> {
                error.addSuppressed((Throwable)e);
                LOGGER.debug(() -> "Failed to build JWS with key: " + String.valueOf(key), e);
            }).next().switchIfEmpty(Mono.error((Throwable)error));
        });
    }

    protected GenericJWSHeader buildJWSHeader() throws JWSBuildException, JOSEObjectBuildException, JOSEProcessingException {
        GenericJWSHeader jwsHeader = new GenericJWSHeader();
        if (this.headerConfigurer != null) {
            this.headerConfigurer.accept(jwsHeader);
        }
        this.checkHeader(jwsHeader);
        if (jwsHeader.isBase64EncodePayload() != null) {
            if (jwsHeader.getCritical() == null) {
                jwsHeader.critical(new String[]{"b64"});
            }
            jwsHeader.getCritical().add("b64");
        }
        try {
            jwsHeader.setEncoded(JOSEUtils.BASE64_NOPAD_URL_ENCODER.encodeToString(this.mapper.writeValueAsBytes((Object)jwsHeader)));
        }
        catch (JsonProcessingException e) {
            throw new JWSBuildException("Failed to encode JWS header", e);
        }
        return jwsHeader;
    }

    protected Mono<GenericJWSPayload<A>> buildJWSPayload(Function<A, Mono<String>> overridingPayloadEncoder, String overridingContentType, GenericJWSHeader jwsHeader) throws JWSBuildException, JOSEObjectBuildException, JOSEProcessingException {
        this.checkPayload();
        return this.getPayloadEncoder(overridingPayloadEncoder, overridingContentType, jwsHeader).apply(this.payload).onErrorMap(e -> new JWSBuildException("Failed to encode JWS payload", (Throwable)e)).map(rawPayload -> {
            GenericJWSPayload<Object> jwsPayload = new GenericJWSPayload<Object>(this.payload);
            jwsPayload.setRaw((String)rawPayload);
            if (jwsHeader.isBase64EncodePayload() == null || jwsHeader.isBase64EncodePayload().booleanValue()) {
                jwsPayload.setEncoded(JOSEUtils.BASE64_NOPAD_URL_ENCODER.encodeToString(rawPayload.getBytes()));
            }
            return jwsPayload;
        });
    }
}

