/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jwk.rsa;

import io.inverno.mod.security.jose.internal.JOSEUtils;
import io.inverno.mod.security.jose.internal.jwk.AbstractX509JWKGenerator;
import io.inverno.mod.security.jose.internal.jwk.rsa.GenericRSAJWK;
import io.inverno.mod.security.jose.jwa.RSAAlgorithm;
import io.inverno.mod.security.jose.jwk.JWKGenerateException;
import io.inverno.mod.security.jose.jwk.JWKProcessingException;
import io.inverno.mod.security.jose.jwk.rsa.RSAJWKGenerator;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Map;
import reactor.core.publisher.Mono;

public class GenericRSAJWKGenerator
extends AbstractX509JWKGenerator<RSAPublicKey, RSAPrivateKey, GenericRSAJWK, GenericRSAJWKGenerator>
implements RSAJWKGenerator<GenericRSAJWK, GenericRSAJWKGenerator> {
    public static final int MINIMUM_KEY_SIZE = 2048;
    public static final int DEFAULT_KEY_SIZE = 2048;
    private RSAAlgorithm rsaAlg;
    private Integer keySize;

    public GenericRSAJWKGenerator() {
        this(null);
    }

    public GenericRSAJWKGenerator(Map<String, Object> parameters) throws JWKGenerateException {
        super(parameters);
        if (this.keySize == null) {
            this.keySize = 2048;
        }
    }

    @Override
    protected void set(String field, Object value) throws JWKGenerateException {
        switch (field) {
            case "keySize": {
                this.keySize((Integer)value);
                break;
            }
            default: {
                super.set(field, value);
            }
        }
    }

    @Override
    public GenericRSAJWKGenerator algorithm(String alg) {
        this.rsaAlg = alg != null ? RSAAlgorithm.fromAlgorithm(alg) : null;
        return (GenericRSAJWKGenerator)super.algorithm(alg);
    }

    @Override
    public GenericRSAJWKGenerator keySize(int keySize) {
        this.keySize = keySize;
        return this;
    }

    @Override
    protected Mono<Void> verify() throws JWKGenerateException, JWKProcessingException {
        return super.verify().then(Mono.fromRunnable(() -> {
            if (this.keySize < 2048) {
                throw new JWKGenerateException("Key size must be at least 2048");
            }
        }));
    }

    @Override
    protected Mono<GenericRSAJWK> doGenerate() throws JWKGenerateException, JWKProcessingException {
        return Mono.fromSupplier(() -> {
            try {
                KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
                keyPairGenerator.initialize(this.keySize);
                KeyPair keyPair = keyPairGenerator.generateKeyPair();
                RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
                RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
                GenericRSAJWK jwk = new GenericRSAJWK(JOSEUtils.BASE64_NOPAD_URL_ENCODER.encodeToString(JOSEUtils.toUnsignedBytes(publicKey.getModulus())), JOSEUtils.BASE64_NOPAD_URL_ENCODER.encodeToString(JOSEUtils.toUnsignedBytes(publicKey.getPublicExponent())), JOSEUtils.BASE64_NOPAD_URL_ENCODER.encodeToString(JOSEUtils.toUnsignedBytes(privateKey.getPrivateExponent())));
                jwk.setPublicKeyUse(this.use);
                jwk.setKeyOperations(this.key_ops);
                jwk.setKeyId(this.kid);
                jwk.setAlgorithm(this.rsaAlg);
                return jwk;
            }
            catch (NoSuchAlgorithmException e) {
                throw new JWKGenerateException("Error generating RSA JWK", e);
            }
        });
    }
}

