/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jwk.rsa;

import io.inverno.mod.security.jose.internal.JOSEUtils;
import io.inverno.mod.security.jose.internal.jwk.AbstractX509JWK;
import io.inverno.mod.security.jose.jwa.JWAKeyManager;
import io.inverno.mod.security.jose.jwa.JWASigner;
import io.inverno.mod.security.jose.jwa.RSAAlgorithm;
import io.inverno.mod.security.jose.jwk.JWKProcessingException;
import io.inverno.mod.security.jose.jwk.rsa.RSAJWK;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAMultiPrimePrivateCrtKeySpec;
import java.security.spec.RSAOtherPrimeInfo;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class GenericRSAJWK
extends AbstractX509JWK<RSAPublicKey, RSAPrivateKey>
implements RSAJWK {
    private final String n;
    private final String e;
    private final String d;
    private String p;
    private String q;
    private String dp;
    private String dq;
    private String qi;
    private List<RSAJWK.OtherPrimeInfo> oth;
    private RSAAlgorithm rsaAlg;
    private RSAPublicKey publicKey;
    private Optional<RSAPrivateKey> privateKey;
    private Map<RSAAlgorithm, JWASigner> signers;
    private Map<RSAAlgorithm, JWAKeyManager> keyManagers;

    public GenericRSAJWK(String n, String e) {
        this(n, e, null, null, null, false);
    }

    public GenericRSAJWK(String n, String e, X509Certificate certificate) {
        this(n, e, null, null, certificate, certificate != null);
    }

    public GenericRSAJWK(String n, String e, String d) {
        this(n, e, d, null, null, false);
    }

    public GenericRSAJWK(String n, String e, String d, RSAPrivateKey key, boolean trusted) {
        this(n, e, d, key, null, trusted);
    }

    public GenericRSAJWK(String n, String e, String d, X509Certificate certificate) {
        this(n, e, d, null, null, false);
    }

    public GenericRSAJWK(String n, String e, String d, RSAPrivateKey key, X509Certificate certificate, boolean trusted) {
        super("RSA", key, certificate, trusted);
        this.n = n;
        this.e = e;
        this.d = d;
        this.privateKey = key != null ? Optional.of(key) : null;
    }

    public void setAlgorithm(RSAAlgorithm rsaAlg) {
        this.rsaAlg = rsaAlg;
        super.setAlgorithm(rsaAlg != null ? rsaAlg.getAlgorithm() : null);
    }

    @Override
    public void setAlgorithm(String alg) {
        this.rsaAlg = alg != null ? RSAAlgorithm.fromAlgorithm(alg) : null;
        super.setAlgorithm(alg);
    }

    @Override
    public String getModulus() {
        return this.n;
    }

    @Override
    public String getPublicExponent() {
        return this.e;
    }

    @Override
    public String getPrivateExponent() {
        return this.d;
    }

    public void setFirstPrimeFactor(String p) {
        this.p = p;
    }

    @Override
    public String getFirstPrimeFactor() {
        return this.p;
    }

    public void setSecondPrimeFactor(String q) {
        this.q = q;
    }

    @Override
    public String getSecondPrimeFactor() {
        return this.q;
    }

    public void setFirstFactorExponent(String dp) {
        this.dp = dp;
    }

    @Override
    public String getFirstFactorExponent() {
        return this.dp;
    }

    public void setSecondFactorExponent(String dq) {
        this.dq = dq;
    }

    @Override
    public String getSecondFactorExponent() {
        return this.dq;
    }

    public void setFirstCoefficient(String qi) {
        this.qi = qi;
    }

    @Override
    public String getFirstCoefficient() {
        return this.qi;
    }

    public void setOtherPrimesInfo(List<RSAJWK.OtherPrimeInfo> oth) {
        this.oth = oth != null && !oth.isEmpty() ? Collections.unmodifiableList(oth) : null;
    }

    @Override
    public List<RSAJWK.OtherPrimeInfo> getOtherPrimesInfo() {
        return this.oth;
    }

    @Override
    public RSAJWK trust() {
        this.trusted = true;
        return this;
    }

    @Override
    public RSAPublicKey toPublicKey() throws JWKProcessingException {
        if (this.publicKey == null) {
            this.publicKey = this.certificate.map(cert -> (RSAPublicKey)cert.getPublicKey()).orElseGet(() -> {
                try {
                    RSAPublicKeySpec rsaPublicKeySpec = new RSAPublicKeySpec(new BigInteger(1, Base64.getUrlDecoder().decode(this.n)), new BigInteger(1, Base64.getUrlDecoder().decode(this.e)));
                    return (RSAPublicKey)KeyFactory.getInstance("RSA").generatePublic(rsaPublicKeySpec);
                }
                catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
                    throw new JWKProcessingException("Error creating verifier", e);
                }
            });
        }
        return this.publicKey;
    }

    @Override
    public Optional<RSAPrivateKey> toPrivateKey() throws JWKProcessingException {
        if (this.privateKey == null) {
            this.privateKey = Optional.ofNullable(this.d).map(pe -> {
                try {
                    RSAPrivateKeySpec rsaPrivateKeySpec;
                    BigInteger modulus = new BigInteger(1, Base64.getUrlDecoder().decode(this.n));
                    BigInteger privateExponent = new BigInteger(1, Base64.getUrlDecoder().decode((String)pe));
                    if (this.getFirstPrimeFactor() != null) {
                        BigInteger publicExponent = new BigInteger(1, Base64.getUrlDecoder().decode(this.e));
                        BigInteger primeP = new BigInteger(1, Base64.getUrlDecoder().decode(this.p));
                        BigInteger primeQ = new BigInteger(1, Base64.getUrlDecoder().decode(this.q));
                        BigInteger primeExponentP = new BigInteger(1, Base64.getUrlDecoder().decode(this.dp));
                        BigInteger primeExponentQ = new BigInteger(1, Base64.getUrlDecoder().decode(this.dq));
                        BigInteger crtCoefficient = new BigInteger(1, Base64.getUrlDecoder().decode(this.qi));
                        RSAOtherPrimeInfo[] otherPrimeInfo = null;
                        if (this.getOtherPrimesInfo() != null) {
                            otherPrimeInfo = (RSAOtherPrimeInfo[])this.getOtherPrimesInfo().stream().map(o -> new RSAOtherPrimeInfo(new BigInteger(1, Base64.getUrlDecoder().decode(o.getPrimeFactor())), new BigInteger(1, Base64.getUrlDecoder().decode(o.getExponent())), new BigInteger(1, Base64.getUrlDecoder().decode(o.getCoefficient())))).toArray(RSAOtherPrimeInfo[]::new);
                        }
                        rsaPrivateKeySpec = new RSAMultiPrimePrivateCrtKeySpec(modulus, publicExponent, privateExponent, primeP, primeQ, primeExponentP, primeExponentQ, crtCoefficient, otherPrimeInfo);
                    } else {
                        rsaPrivateKeySpec = new RSAPrivateKeySpec(modulus, privateExponent);
                    }
                    return (RSAPrivateKey)KeyFactory.getInstance("RSA").generatePrivate(rsaPrivateKeySpec);
                }
                catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
                    throw new JWKProcessingException("Error creating signer", e);
                }
            });
        }
        return this.privateKey;
    }

    @Override
    public RSAJWK toPublicJWK() {
        GenericRSAJWK jwk = new GenericRSAJWK(this.n, this.e, this.certificate.orElse(null));
        jwk.publicKey = this.publicKey;
        jwk.setPublicKeyUse(this.use);
        jwk.setKeyOperations(this.key_ops);
        jwk.setAlgorithm(this.rsaAlg);
        jwk.setKeyId(this.kid);
        jwk.setX509CertificateURL(this.x5u);
        jwk.setX509CertificateChain(this.x5c);
        jwk.setX509CertificateSHA1Thumbprint(this.x5t);
        jwk.setX509CertificateSHA256Thumbprint(this.x5t_S256);
        return jwk;
    }

    @Override
    public RSAJWK minify() {
        GenericRSAJWK jwk = new GenericRSAJWK(this.n, this.e, this.d, (RSAPrivateKey)this.key, this.certificate.orElse(null), this.trusted);
        jwk.publicKey = this.publicKey;
        return jwk;
    }

    @Override
    public String toJWKThumbprint(MessageDigest digest) {
        return GenericRSAJWK.toJWKThumbprint(digest, this.e, this.kty, this.n);
    }

    static String toJWKThumbprint(MessageDigest digest, String e, String kty, String n) {
        if (e == null || kty == null || n == null) {
            return null;
        }
        StringBuilder input = new StringBuilder();
        input.append('{');
        input.append("\"e\":\"").append(e).append("\",");
        input.append("\"kty\":\"").append(kty).append("\",");
        input.append("\"n\":\"").append(n).append("\"");
        input.append('}');
        return JOSEUtils.BASE64_NOPAD_URL_ENCODER.encodeToString(digest.digest(input.toString().getBytes()));
    }

    @Override
    public boolean supportsAlgorithm(String alg) {
        try {
            RSAAlgorithm.fromAlgorithm(alg);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    @Override
    public JWASigner signer() throws JWKProcessingException {
        this.checkSignature(this.rsaAlg);
        return this.getSigner(this.rsaAlg);
    }

    @Override
    public JWASigner signer(String alg) {
        if (StringUtils.isBlank((CharSequence)alg)) {
            return this.signer();
        }
        RSAAlgorithm algorithm = RSAAlgorithm.fromAlgorithm(alg);
        this.checkSignature(algorithm);
        return this.getSigner(algorithm);
    }

    private JWASigner getSigner(RSAAlgorithm algorithm) {
        if (this.signers == null) {
            this.signers = new HashMap<RSAAlgorithm, JWASigner>();
        }
        return this.signers.computeIfAbsent(algorithm, ign -> algorithm.createSigner(this));
    }

    @Override
    public JWAKeyManager keyManager() throws JWKProcessingException {
        this.checkEncryption(this.rsaAlg);
        return this.getKeyManager(this.rsaAlg);
    }

    @Override
    public JWAKeyManager keyManager(String alg) throws JWKProcessingException {
        if (StringUtils.isBlank((CharSequence)alg)) {
            return this.keyManager();
        }
        RSAAlgorithm algorithm = RSAAlgorithm.fromAlgorithm(alg);
        this.checkKeyManagement(algorithm);
        return this.getKeyManager(algorithm);
    }

    private JWAKeyManager getKeyManager(RSAAlgorithm algorithm) {
        if (this.keyManagers == null) {
            this.keyManagers = new HashMap<RSAAlgorithm, JWAKeyManager>();
        }
        return this.keyManagers.computeIfAbsent(algorithm, ign -> algorithm.createKeyManager(this));
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.d, this.dp, this.dq, this.e, this.n, this.oth, this.p, this.q, this.qi);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GenericRSAJWK other = (GenericRSAJWK)obj;
        return Objects.equals(this.d, other.d) && Objects.equals(this.dp, other.dp) && Objects.equals(this.dq, other.dq) && Objects.equals(this.e, other.e) && Objects.equals(this.n, other.n) && Objects.equals(this.oth, other.oth) && Objects.equals(this.p, other.p) && Objects.equals(this.q, other.q) && Objects.equals(this.qi, other.qi);
    }

    public static class GenericOtherPrimeInfo
    implements RSAJWK.OtherPrimeInfo {
        private final String r;
        private final String d;
        private final String t;

        public GenericOtherPrimeInfo(String r, String d, String t) throws JWKProcessingException {
            if (StringUtils.isBlank((CharSequence)r)) {
                throw new JWKProcessingException("Prime factor is blank");
            }
            if (StringUtils.isBlank((CharSequence)d)) {
                throw new JWKProcessingException("Exponent is blank");
            }
            if (StringUtils.isBlank((CharSequence)t)) {
                throw new JWKProcessingException("Coefficient is blank");
            }
            this.r = r;
            this.d = d;
            this.t = t;
        }

        @Override
        public String getPrimeFactor() {
            return this.r;
        }

        @Override
        public String getExponent() {
            return this.d;
        }

        @Override
        public String getCoefficient() {
            return this.t;
        }

        public int hashCode() {
            return Objects.hash(this.d, this.r, this.t);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GenericOtherPrimeInfo other = (GenericOtherPrimeInfo)obj;
            return Objects.equals(this.d, other.d) && Objects.equals(this.r, other.r) && Objects.equals(this.t, other.t);
        }
    }
}

