/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jwk.okp;

import io.inverno.mod.security.jose.internal.jwk.okp.AbstractOKPJWK;
import io.inverno.mod.security.jose.jwa.JWAKeyManager;
import io.inverno.mod.security.jose.jwa.OKPCurve;
import io.inverno.mod.security.jose.jwa.XECAlgorithm;
import io.inverno.mod.security.jose.jwk.JWKProcessingException;
import io.inverno.mod.security.jose.jwk.okp.XECJWK;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.security.interfaces.XECPrivateKey;
import java.security.interfaces.XECPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.NamedParameterSpec;
import java.security.spec.XECPrivateKeySpec;
import java.security.spec.XECPublicKeySpec;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class GenericXECJWK
extends AbstractOKPJWK<XECPublicKey, XECPrivateKey>
implements XECJWK {
    public static final Set<OKPCurve> SUPPORTED_CURVES = Set.of(OKPCurve.X25519, OKPCurve.X448);
    private XECAlgorithm xecAlg;
    private Map<XECAlgorithm, JWAKeyManager> keyManagers;

    public GenericXECJWK(OKPCurve curve, String x) {
        super(curve, x);
    }

    public GenericXECJWK(OKPCurve curve, String x, X509Certificate certificate) {
        super(curve, x, certificate);
    }

    public GenericXECJWK(OKPCurve curve, String x, String d) {
        super(curve, x, d);
    }

    public GenericXECJWK(OKPCurve curve, String x, String d, XECPrivateKey key, boolean trusted) {
        super(curve, x, d, key, trusted);
    }

    public GenericXECJWK(OKPCurve curve, String x, String d, X509Certificate certificate) {
        super(curve, x, d, certificate);
    }

    public GenericXECJWK(OKPCurve curve, String x, String d, XECPrivateKey key, X509Certificate certificate, boolean trusted) {
        super(curve, x, d, key, certificate, trusted);
    }

    public void setAlgorithm(XECAlgorithm xecAlg) {
        super.setAlgorithm(xecAlg != null ? xecAlg.getAlgorithm() : null);
        this.xecAlg = xecAlg;
    }

    @Override
    public void setAlgorithm(String alg) {
        this.xecAlg = alg != null ? XECAlgorithm.fromAlgorithm(alg) : null;
        super.setAlgorithm(alg);
    }

    @Override
    public XECJWK trust() {
        this.trusted = true;
        return this;
    }

    @Override
    public XECPublicKey toPublicKey() throws JWKProcessingException {
        if (this.publicKey == null) {
            this.publicKey = this.certificate.map(cert -> (XECPublicKey)cert.getPublicKey()).orElseGet(() -> {
                try {
                    byte[] encodedPoint = Base64.getUrlDecoder().decode(this.x);
                    if (this.curve.equals((Object)OKPCurve.X25519)) {
                        int n = encodedPoint.length - 1;
                        encodedPoint[n] = (byte)(encodedPoint[n] & 0x7F);
                    }
                    GenericXECJWK.reverse(encodedPoint);
                    BigInteger u = new BigInteger(1, encodedPoint);
                    XECPublicKeySpec xecPublicKeySpec = new XECPublicKeySpec(new NamedParameterSpec(this.curve.getJCAName()), u);
                    return (XECPublicKey)KeyFactory.getInstance(this.curve.getJCAName()).generatePublic(xecPublicKeySpec);
                }
                catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
                    throw new JWKProcessingException("Error converting JWK to public key", e);
                }
            });
        }
        return (XECPublicKey)this.publicKey;
    }

    @Override
    public Optional<XECPrivateKey> toPrivateKey() throws JWKProcessingException {
        if (this.privateKey == null) {
            this.privateKey = Optional.ofNullable(this.d).map(pk -> {
                try {
                    XECPrivateKeySpec xecPrivateKeySpec = new XECPrivateKeySpec(new NamedParameterSpec(this.curve.getJCAName()), Base64.getUrlDecoder().decode((String)pk));
                    return (XECPrivateKey)KeyFactory.getInstance(this.curve.getJCAName()).generatePrivate(xecPrivateKeySpec);
                }
                catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
                    throw new JWKProcessingException("Error converting JWK to private key", e);
                }
            });
        }
        return this.privateKey;
    }

    @Override
    public XECJWK toPublicJWK() {
        GenericXECJWK jwk = new GenericXECJWK(this.curve, this.x, this.certificate.orElse(null));
        jwk.publicKey = this.publicKey;
        jwk.setPublicKeyUse(this.use);
        jwk.setKeyOperations(this.key_ops);
        jwk.setAlgorithm(this.xecAlg);
        jwk.setKeyId(this.kid);
        jwk.setX509CertificateURL(this.x5u);
        jwk.setX509CertificateChain(this.x5c);
        jwk.setX509CertificateSHA1Thumbprint(this.x5t);
        jwk.setX509CertificateSHA256Thumbprint(this.x5t_S256);
        return jwk;
    }

    @Override
    public XECJWK minify() {
        GenericXECJWK jwk = new GenericXECJWK(this.curve, this.x, this.d, (XECPrivateKey)this.key, (X509Certificate)this.certificate.orElse(null), this.trusted);
        jwk.publicKey = this.publicKey;
        return jwk;
    }

    @Override
    public boolean supportsAlgorithm(String alg) {
        try {
            XECAlgorithm.fromAlgorithm(alg);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    @Override
    public JWAKeyManager keyManager() throws JWKProcessingException {
        this.checkKeyManagement(this.xecAlg);
        return this.getKeyManager(this.xecAlg);
    }

    @Override
    public JWAKeyManager keyManager(String alg) throws JWKProcessingException {
        if (StringUtils.isBlank((CharSequence)alg)) {
            return this.keyManager();
        }
        XECAlgorithm algorithm = XECAlgorithm.fromAlgorithm(alg);
        this.checkKeyManagement(algorithm);
        return this.getKeyManager(algorithm);
    }

    private JWAKeyManager getKeyManager(XECAlgorithm algorithm) {
        if (this.keyManagers == null) {
            this.keyManagers = new HashMap<XECAlgorithm, JWAKeyManager>();
        }
        return this.keyManagers.computeIfAbsent(algorithm, ign -> algorithm.createKeyManager(this));
    }
}

