/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jwk.okp;

import io.inverno.mod.security.jose.internal.JOSEUtils;
import io.inverno.mod.security.jose.internal.jwk.okp.AbstractOKPJWKGenerator;
import io.inverno.mod.security.jose.internal.jwk.okp.GenericEdECJWK;
import io.inverno.mod.security.jose.jwa.EdECAlgorithm;
import io.inverno.mod.security.jose.jwa.OKPCurve;
import io.inverno.mod.security.jose.jwk.JWKGenerateException;
import io.inverno.mod.security.jose.jwk.JWKProcessingException;
import io.inverno.mod.security.jose.jwk.okp.EdECJWKGenerator;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.EdECPrivateKey;
import java.security.interfaces.EdECPublicKey;
import java.util.Map;
import reactor.core.publisher.Mono;

public class GenericEdECJWKGenerator
extends AbstractOKPJWKGenerator<EdECPublicKey, EdECPrivateKey, GenericEdECJWK, GenericEdECJWKGenerator>
implements EdECJWKGenerator<GenericEdECJWK, GenericEdECJWKGenerator> {
    public static final OKPCurve DEFAULT_CURVE = OKPCurve.ED25519;

    public GenericEdECJWKGenerator() {
        this(null);
    }

    public GenericEdECJWKGenerator(Map<String, Object> parameters) throws JWKGenerateException {
        super(parameters);
        if (this.curve == null) {
            this.curve = DEFAULT_CURVE;
        }
    }

    @Override
    protected Mono<Void> verify() throws JWKGenerateException, JWKProcessingException {
        return super.verify().then(Mono.fromRunnable(() -> {
            if (this.alg != null) {
                try {
                    EdECAlgorithm.fromAlgorithm(this.alg, this.curve);
                }
                catch (IllegalArgumentException e) {
                    throw new JWKGenerateException("Unsupported algorithm: " + this.alg + " + " + this.curve.getCurve());
                }
            }
            if (!GenericEdECJWK.SUPPORTED_CURVES.contains((Object)this.curve)) {
                throw new JWKGenerateException("Unsupported OKP curve: " + this.curve.getCurve());
            }
        }));
    }

    @Override
    protected Mono<GenericEdECJWK> doGenerate() throws JWKGenerateException, JWKProcessingException {
        return Mono.fromSupplier(() -> {
            try {
                KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(this.curve.getJCAName());
                KeyPair keyPair = keyPairGenerator.generateKeyPair();
                EdECPublicKey publicKey = (EdECPublicKey)keyPair.getPublic();
                EdECPrivateKey privateKey = (EdECPrivateKey)keyPair.getPrivate();
                byte[] xBytes = new byte[this.curve.getKeyLength()];
                byte[] encodedKeyBytes = publicKey.getEncoded();
                System.arraycopy(encodedKeyBytes, encodedKeyBytes.length - xBytes.length, xBytes, 0, xBytes.length);
                GenericEdECJWK jwk = new GenericEdECJWK(this.curve, JOSEUtils.BASE64_NOPAD_URL_ENCODER.encodeToString(xBytes), privateKey.getBytes().map(JOSEUtils.BASE64_NOPAD_URL_ENCODER::encodeToString).orElse(null));
                jwk.setPublicKeyUse(this.use);
                jwk.setKeyOperations(this.key_ops);
                jwk.setKeyId(this.kid);
                jwk.setAlgorithm(this.alg);
                return jwk;
            }
            catch (NoSuchAlgorithmException e) {
                throw new JWKGenerateException("Error generating OKP JWK", e);
            }
        });
    }
}

