/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jwk.ec;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.inverno.core.annotation.Bean;
import io.inverno.mod.security.jose.JOSEConfiguration;
import io.inverno.mod.security.jose.internal.jwk.AbstractX509JWKFactory;
import io.inverno.mod.security.jose.internal.jwk.SwitchableJWKURLResolver;
import io.inverno.mod.security.jose.internal.jwk.ec.GenericECJWK;
import io.inverno.mod.security.jose.internal.jwk.ec.GenericECJWKBuilder;
import io.inverno.mod.security.jose.internal.jwk.ec.GenericECJWKGenerator;
import io.inverno.mod.security.jose.jwa.ECAlgorithm;
import io.inverno.mod.security.jose.jwk.JWKGenerateException;
import io.inverno.mod.security.jose.jwk.JWKKeyResolver;
import io.inverno.mod.security.jose.jwk.JWKReadException;
import io.inverno.mod.security.jose.jwk.JWKStore;
import io.inverno.mod.security.jose.jwk.X509JWKCertPathValidator;
import io.inverno.mod.security.jose.jwk.ec.ECJWKFactory;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@Bean(visibility=Bean.Visibility.PRIVATE)
public class GenericECJWKFactory
extends AbstractX509JWKFactory<ECPublicKey, ECPrivateKey, GenericECJWK, GenericECJWKBuilder, GenericECJWKGenerator>
implements ECJWKFactory<GenericECJWK, GenericECJWKBuilder, GenericECJWKGenerator> {
    private static final Set<String> SUPPORTED_ALGORITHMS = Arrays.stream(ECAlgorithm.values()).map(ECAlgorithm::getAlgorithm).collect(Collectors.toSet());

    public GenericECJWKFactory(JOSEConfiguration configuration, JWKStore jwkStore, JWKKeyResolver keyResolver, ObjectMapper mapper, SwitchableJWKURLResolver urlResolver, X509JWKCertPathValidator certPathValidator) {
        super(configuration, jwkStore, keyResolver, mapper, urlResolver, certPathValidator);
    }

    @Override
    public boolean supports(String kty) {
        return "EC".equals(kty);
    }

    @Override
    public boolean supportsAlgorithm(String alg) {
        return SUPPORTED_ALGORITHMS.contains(alg);
    }

    @Override
    public GenericECJWKBuilder builder() {
        return new GenericECJWKBuilder(this.configuration, this.jwkStore, this.keyResolver, this.urlResolver, this.certPathValidator);
    }

    @Override
    public GenericECJWKBuilder builder(Map<String, Object> parameters) throws JWKReadException {
        return new GenericECJWKBuilder(this.configuration, this.jwkStore, this.keyResolver, this.urlResolver, this.certPathValidator, parameters);
    }

    @Override
    public GenericECJWKGenerator generator() {
        return new GenericECJWKGenerator();
    }

    @Override
    public GenericECJWKGenerator generator(String alg, Map<String, Object> parameters) throws JWKGenerateException {
        return new GenericECJWKGenerator(parameters).algorithm(alg);
    }
}

