/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jwk;

import io.inverno.core.annotation.Bean;
import io.inverno.mod.security.jose.JOSEConfiguration;
import io.inverno.mod.security.jose.jwk.JWKResolveException;
import io.inverno.mod.security.jose.jwk.JWKURLResolver;
import java.net.URI;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

@Bean(name="switchableJWKURLResolver", visibility=Bean.Visibility.PRIVATE)
public class SwitchableJWKURLResolver
implements JWKURLResolver {
    private static final Logger LOGGER = LogManager.getLogger(SwitchableJWKURLResolver.class);
    private final JOSEConfiguration configuration;
    private final JWKURLResolver urlResolver;

    public SwitchableJWKURLResolver(JOSEConfiguration configuration, JWKURLResolver urlResolver) {
        this.configuration = configuration;
        this.urlResolver = urlResolver;
    }

    @Override
    public Publisher<Map<String, Object>> resolveJWKSetURL(URI jku) throws JWKResolveException {
        if (!this.configuration.resolve_jku()) {
            return Mono.fromRunnable(() -> LOGGER.warn("JWK set URL resolver is disabled"));
        }
        return this.urlResolver.resolveJWKSetURL(jku);
    }

    @Override
    public Mono<List<X509Certificate>> resolveX509CertificateURL(URI x5u) throws JWKResolveException {
        if (!this.configuration.resolve_x5u()) {
            return Mono.fromRunnable(() -> LOGGER.warn("X509 certificate URL resolver is disabled"));
        }
        return this.urlResolver.resolveX509CertificateURL(x5u);
    }
}

