/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jwk;

import io.inverno.mod.security.jose.internal.jwk.AbstractJWK;
import io.inverno.mod.security.jose.jwk.JWKProcessingException;
import io.inverno.mod.security.jose.jwk.X509JWK;
import java.net.URI;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractX509JWK<A extends PublicKey, B extends PrivateKey>
extends AbstractJWK
implements X509JWK<A, B> {
    protected final Optional<X509Certificate> certificate;
    protected URI x5u;
    protected String[] x5c;
    protected String x5t;
    protected String x5t_S256;

    protected AbstractX509JWK(String kty) throws JWKProcessingException {
        this(kty, null, null, false);
    }

    protected AbstractX509JWK(String kty, PrivateKey key, boolean trusted) throws JWKProcessingException {
        this(kty, key, null, trusted);
    }

    protected AbstractX509JWK(String kty, X509Certificate certificate) throws JWKProcessingException {
        this(kty, null, certificate, certificate != null);
    }

    protected AbstractX509JWK(String kty, PrivateKey key, X509Certificate certificate, boolean trusted) throws JWKProcessingException {
        super(kty, key, trusted);
        this.certificate = Optional.ofNullable(certificate);
    }

    @Override
    public URI getX509CertificateURL() {
        return this.x5u;
    }

    public void setX509CertificateURL(URI x5u) {
        this.x5u = x5u;
    }

    @Override
    public String[] getX509CertificateChain() {
        return this.x5c;
    }

    public void setX509CertificateChain(String[] x5c) {
        this.x5c = x5c != null && x5c.length > 0 ? x5c : null;
    }

    @Override
    public String getX509CertificateSHA1Thumbprint() {
        return this.x5t;
    }

    public void setX509CertificateSHA1Thumbprint(String x5t) {
        this.x5t = x5t;
    }

    @Override
    public String getX509CertificateSHA256Thumbprint() {
        return this.x5t_S256;
    }

    public void setX509CertificateSHA256Thumbprint(String x5t_S256) {
        this.x5t_S256 = x5t_S256;
    }

    @Override
    public Optional<X509Certificate> getX509Certificate() {
        return this.certificate;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.x5c);
        result = 31 * result + Objects.hash(this.x5t, this.x5t_S256, this.x5u);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractX509JWK other = (AbstractX509JWK)obj;
        return Arrays.equals(this.x5c, other.x5c) && Objects.equals(this.x5t, other.x5t) && Objects.equals(this.x5t_S256, other.x5t_S256) && Objects.equals(this.x5u, other.x5u);
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("{");
        String jwkStr = super.toString();
        str.append(jwkStr, 1, jwkStr.length() - 1);
        if (this.x5u != null) {
            str.append(",\"x5u\":\"").append(this.x5u).append("\"");
        }
        if (StringUtils.isNotBlank((CharSequence)this.x5t)) {
            str.append(",\"x5t\":\"").append(this.x5t).append("\"");
        }
        if (StringUtils.isNotBlank((CharSequence)this.x5t_S256)) {
            str.append(",\"x5t#S256\":\"").append(this.x5t_S256).append("\"");
        }
        str.append("}");
        return str.toString();
    }
}

