/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jwe;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.inverno.core.annotation.Bean;
import io.inverno.core.annotation.Init;
import io.inverno.mod.security.jose.internal.converter.GenericDataConversionService;
import io.inverno.mod.security.jose.internal.jwe.DeflateJWEZip;
import io.inverno.mod.security.jose.internal.jwe.GenericJWEBuilder;
import io.inverno.mod.security.jose.internal.jwe.GenericJWEReader;
import io.inverno.mod.security.jose.internal.jwe.GenericJsonJWEBuilder;
import io.inverno.mod.security.jose.internal.jwe.GenericJsonJWEReader;
import io.inverno.mod.security.jose.jwe.JWEBuilder;
import io.inverno.mod.security.jose.jwe.JWEReader;
import io.inverno.mod.security.jose.jwe.JWEService;
import io.inverno.mod.security.jose.jwe.JWEZip;
import io.inverno.mod.security.jose.jwe.JsonJWEBuilder;
import io.inverno.mod.security.jose.jwe.JsonJWEReader;
import io.inverno.mod.security.jose.jwk.JWK;
import io.inverno.mod.security.jose.jwk.JWKService;
import java.lang.reflect.Type;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;

@Bean(name="jweService")
public class GenericJWEService
implements JWEService {
    private final ObjectMapper mapper;
    private final GenericDataConversionService dataConversionService;
    private final JWKService jwkService;
    private final List<JWEZip> zips;

    public GenericJWEService(ObjectMapper mapper, GenericDataConversionService dataConversionService, JWKService jwkService) {
        this.mapper = mapper;
        this.dataConversionService = dataConversionService;
        this.jwkService = jwkService;
        this.zips = new LinkedList<JWEZip>();
    }

    @Init
    public void init() {
        this.dataConversionService.injectJWEService(this);
    }

    public void setJWEZips(List<JWEZip> zips) {
        this.zips.clear();
        JWEZip deflateZip = null;
        for (JWEZip zip : zips) {
            if (zip instanceof DeflateJWEZip) {
                deflateZip = zip;
                continue;
            }
            this.zips.add(zip);
        }
        if (deflateZip != null) {
            this.zips.add(deflateZip);
        }
    }

    @Override
    public <T> JWEBuilder<T, ?, ?> builder(Type type, Publisher<? extends JWK> keys) {
        return new GenericJWEBuilder(this.mapper, this.dataConversionService, this.jwkService, type, keys, this.zips);
    }

    @Override
    public <T> JWEReader<T, ?> reader(Type type, Publisher<? extends JWK> keys) {
        return new GenericJWEReader(this.mapper, this.dataConversionService, this.jwkService, type, keys, this.zips);
    }

    @Override
    public <T> JsonJWEBuilder<T, ?, ?> jsonBuilder(Type type) {
        return new GenericJsonJWEBuilder(this.mapper, this.dataConversionService, this.jwkService, type, this.zips);
    }

    @Override
    public <T> JsonJWEReader<T, ?> jsonReader(Type type) {
        return new GenericJsonJWEReader(this.mapper, this.dataConversionService, this.jwkService, type, this.zips);
    }

    @Bean(name="jweZips")
    public static interface JWEZipsSocket
    extends Supplier<List<JWEZip>> {
    }
}

