/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jwe;

import io.inverno.mod.security.jose.internal.AbstractJOSEObject;
import io.inverno.mod.security.jose.internal.jwe.GenericJWEHeader;
import io.inverno.mod.security.jose.internal.jwe.GenericJWEPayload;
import io.inverno.mod.security.jose.jwe.JWE;
import io.inverno.mod.security.jose.jwe.JWEHeader;
import io.inverno.mod.security.jose.jwk.JWK;
import java.util.Objects;

public class GenericJWE<A>
extends AbstractJOSEObject<A, JWEHeader, GenericJWEPayload<A>>
implements JWE<A> {
    private final String initializationVector;
    private final String authenticationTag;
    private final String encryptedKey;
    private final JWK cek;
    private final String compact;

    public GenericJWE(GenericJWEHeader header, GenericJWEPayload<A> payload, String initializationVector, String authenticationTag) {
        this(header, payload, initializationVector, authenticationTag, null, null);
    }

    public GenericJWE(GenericJWEHeader header, GenericJWEPayload<A> payload, String initializationVector, String authenticationTag, String encryptedKey, JWK cek) {
        super(header, payload);
        this.initializationVector = initializationVector;
        this.authenticationTag = authenticationTag;
        this.encryptedKey = encryptedKey;
        this.cek = cek;
        this.compact = header.getEncoded() + "." + (this.encryptedKey != null ? this.encryptedKey : "") + "." + this.initializationVector + "." + ((GenericJWEPayload)this.payload).getEncoded() + "." + this.authenticationTag;
    }

    JWK getCEK() {
        return this.cek;
    }

    @Override
    public String getEncryptedKey() {
        return this.encryptedKey;
    }

    @Override
    public String getInitializationVector() {
        return this.initializationVector;
    }

    @Override
    public String getCipherText() {
        return ((GenericJWEPayload)this.payload).getEncoded();
    }

    @Override
    public String getAuthenticationTag() {
        return this.authenticationTag;
    }

    @Override
    public String toCompact() {
        return this.compact;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.authenticationTag, this.encryptedKey, this.initializationVector);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GenericJWE other = (GenericJWE)obj;
        return Objects.equals(this.authenticationTag, other.authenticationTag) && Objects.equals(this.encryptedKey, other.encryptedKey) && Objects.equals(this.initializationVector, other.initializationVector);
    }
}

