/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jwa;

import io.inverno.mod.security.jose.internal.JOSEUtils;
import io.inverno.mod.security.jose.internal.jwa.AbstractECDH_ESKeyManager;
import io.inverno.mod.security.jose.internal.jwk.okp.GenericXECJWK;
import io.inverno.mod.security.jose.jwa.JWAProcessingException;
import io.inverno.mod.security.jose.jwa.OKPCurve;
import io.inverno.mod.security.jose.jwa.XECAlgorithm;
import io.inverno.mod.security.jose.jwk.okp.XECJWK;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.XECPrivateKey;
import java.security.interfaces.XECPublicKey;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class OKP_ECDH_ESKeyManager
extends AbstractECDH_ESKeyManager<XECPublicKey, XECPrivateKey, XECJWK, XECAlgorithm> {
    public static final Set<XECAlgorithm> SUPPORTED_ALGORITHMS = Set.of(XECAlgorithm.ECDH_ES);
    public static final Set<String> SUPPORTED_CURVES = Set.of(OKPCurve.X25519.getCurve(), OKPCurve.X448.getCurve());
    private OKPCurve curve;

    public OKP_ECDH_ESKeyManager(XECJWK jwk, XECAlgorithm algorithm) throws JWAProcessingException {
        super(jwk, algorithm);
        if (!SUPPORTED_ALGORITHMS.contains(algorithm)) {
            throw new JWAProcessingException("Unsupported algorithm: " + algorithm.getAlgorithm());
        }
        if (!SUPPORTED_CURVES.contains(jwk.getCurve())) {
            throw new JWAProcessingException("Unsupported curve: " + jwk.getCurve());
        }
        this.init();
    }

    public OKP_ECDH_ESKeyManager(XECJWK jwk) {
        super(jwk);
    }

    @Override
    protected final void init() throws JWAProcessingException {
        this.curve = OKPCurve.fromCurve(((XECJWK)this.jwk).getCurve());
    }

    @Override
    protected String getKeyAgreementAlgorithm() {
        return this.curve.getJCAName();
    }

    @Override
    protected XECJWK getEPK(Map<String, Object> parameters) throws JWAProcessingException {
        Object epk_obj;
        Object object = epk_obj = parameters != null ? parameters.get("epk") : null;
        if (epk_obj != null) {
            if (epk_obj instanceof XECJWK) {
                return (XECJWK)epk_obj;
            }
            if (epk_obj instanceof Map) {
                Map epk = (Map)epk_obj;
                String kty = (String)epk.get("kty");
                String crv = (String)epk.get("crv");
                String x = (String)epk.get("x");
                if (kty == null || !"OKP".equals(kty)) {
                    throw new JWAProcessingException("Invalid ephemeral key type: " + kty);
                }
                if (crv == null) {
                    throw new JWAProcessingException("Missing curve in ephemeral key");
                }
                if (!this.curve.getCurve().equals(crv)) {
                    throw new JWAProcessingException("Curve " + crv + " in ephemeral key is not consistent with expected curve " + this.curve.getCurve());
                }
                if (StringUtils.isBlank((CharSequence)x)) {
                    throw new JWAProcessingException("X is blank in ephemeral key");
                }
                return new GenericXECJWK(this.curve, x);
            }
            throw new JWAProcessingException("Invalid EPK type: " + String.valueOf(epk_obj.getClass()));
        }
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(this.curve.getJCAName());
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            XECPublicKey publicKey = (XECPublicKey)keyPair.getPublic();
            XECPrivateKey privateKey = (XECPrivateKey)keyPair.getPrivate();
            byte[] xBytes = new byte[this.curve.getKeyLength()];
            byte[] encodedKeyBytes = publicKey.getEncoded();
            System.arraycopy(encodedKeyBytes, encodedKeyBytes.length - xBytes.length, xBytes, 0, xBytes.length);
            return new GenericXECJWK(this.curve, JOSEUtils.BASE64_NOPAD_URL_ENCODER.encodeToString(xBytes), privateKey.getScalar().map(JOSEUtils.BASE64_NOPAD_URL_ENCODER::encodeToString).orElse(null));
        }
        catch (NoSuchAlgorithmException e) {
            throw new JWAProcessingException("Error generating ephemeral key", e);
        }
    }
}

