/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jwa;

import io.inverno.mod.security.jose.internal.jwa.AbstractJWASigner;
import io.inverno.mod.security.jose.jwa.JWAProcessingException;
import io.inverno.mod.security.jose.jwa.JWASignatureException;
import io.inverno.mod.security.jose.jwa.OCTAlgorithm;
import io.inverno.mod.security.jose.jwk.oct.OCTJWK;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Set;
import javax.crypto.Mac;

public class HMACSigner
extends AbstractJWASigner<OCTJWK, OCTAlgorithm> {
    public static final Set<OCTAlgorithm> SUPPORTED_ALGORITHMS = Set.of(OCTAlgorithm.HS256, OCTAlgorithm.HS384, OCTAlgorithm.HS512);

    public HMACSigner(OCTJWK jwk, OCTAlgorithm algorithm) throws JWAProcessingException {
        super(jwk, algorithm);
        if (!SUPPORTED_ALGORITHMS.contains(algorithm)) {
            throw new JWAProcessingException("Unsupported algorithm: " + algorithm.getAlgorithm());
        }
        this.init();
    }

    protected HMACSigner(OCTJWK jwk) {
        super(jwk);
    }

    @Override
    protected final void init() throws JWAProcessingException {
    }

    @Override
    protected byte[] doSign(byte[] data) throws JWASignatureException {
        return ((OCTJWK)this.jwk).toSecretKey().map(secretKey -> {
            try {
                Mac sig = Mac.getInstance(((OCTAlgorithm)this.algorithm).getJcaAlgorithm());
                sig.init((Key)secretKey);
                return sig.doFinal(data);
            }
            catch (InvalidKeyException | NoSuchAlgorithmException e) {
                throw new JWASignatureException(e);
            }
        }).orElseThrow(() -> new JWASignatureException("JWK is missing secret key"));
    }

    @Override
    protected boolean doVerify(byte[] data, byte[] signature) {
        return MessageDigest.isEqual(this.sign(data), signature);
    }
}

