/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.jwt;

import io.inverno.mod.security.authentication.Authenticator;
import io.inverno.mod.security.authentication.TokenCredentials;
import io.inverno.mod.security.jose.JOSEProcessingException;
import io.inverno.mod.security.jose.jwe.JWEReader;
import io.inverno.mod.security.jose.jwk.JWK;
import io.inverno.mod.security.jose.jwt.JWTClaimsSet;
import io.inverno.mod.security.jose.jwt.JWTClaimsSetValidator;
import io.inverno.mod.security.jose.jwt.JWTEAuthentication;
import io.inverno.mod.security.jose.jwt.JWTService;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class JWTEAuthenticator<A extends JWTClaimsSet>
implements Authenticator<TokenCredentials, JWTEAuthentication<A>> {
    private final JWTService jwtService;
    private final Type type;
    private final Publisher<? extends JWK> keys;
    private final String[] processedParameters;
    private final List<JWTClaimsSetValidator> validators;

    public JWTEAuthenticator(JWTService jwtService) {
        this(jwtService, (Type)((Object)JWTClaimsSet.class), (Publisher<JWK>)((Publisher<? extends JWK>)((Publisher)null)), (String[])null);
    }

    public JWTEAuthenticator(JWTService jwtService, Publisher<? extends JWK> keys) {
        this(jwtService, (Type)((Object)JWTClaimsSet.class), (Publisher<JWK>)keys, (String[])null);
    }

    public JWTEAuthenticator(JWTService jwtService, String ... processedParameters) {
        this(jwtService, (Type)((Object)JWTClaimsSet.class), (Publisher<JWK>)((Publisher<? extends JWK>)((Publisher)null)), processedParameters);
    }

    public JWTEAuthenticator(JWTService jwtService, Publisher<? extends JWK> keys, String ... processedParameters) {
        this(jwtService, (Type)((Object)JWTClaimsSet.class), (Publisher<JWK>)keys, processedParameters);
    }

    public JWTEAuthenticator(JWTService jwtService, Class<A> type) {
        this(jwtService, (Type)type, (Publisher<JWK>)((Publisher<? extends JWK>)((Publisher)null)), (String[])null);
    }

    public JWTEAuthenticator(JWTService jwtService, Type type) {
        this(jwtService, type, (Publisher<? extends JWK>)((Publisher)null), (String[])null);
    }

    public JWTEAuthenticator(JWTService jwtService, Class<A> type, Publisher<? extends JWK> keys) {
        this(jwtService, (Type)type, (Publisher<JWK>)keys, (String[])null);
    }

    public JWTEAuthenticator(JWTService jwtService, Type type, Publisher<? extends JWK> keys) {
        this(jwtService, type, keys, (String[])null);
    }

    public JWTEAuthenticator(JWTService jwtService, Class<A> type, String ... processedParameters) {
        this(jwtService, (Type)type, (Publisher<JWK>)((Publisher<? extends JWK>)((Publisher)null)), processedParameters);
    }

    public JWTEAuthenticator(JWTService jwtService, Type type, String ... processedParameters) {
        this(jwtService, type, (Publisher<? extends JWK>)((Publisher)null), processedParameters);
    }

    public JWTEAuthenticator(JWTService jwtService, Class<A> type, Publisher<? extends JWK> keys, String ... processedParameters) {
        this(jwtService, (Type)type, (Publisher<JWK>)keys, processedParameters);
    }

    public JWTEAuthenticator(JWTService jwtService, Type type, Publisher<? extends JWK> keys, String ... processedParameters) {
        this.jwtService = jwtService;
        this.keys = keys;
        this.type = type;
        this.processedParameters = processedParameters;
        this.validators = new LinkedList<JWTClaimsSetValidator>();
    }

    public JWTEAuthenticator validate(JWTClaimsSetValidator validator) {
        this.validators.add(validator);
        return this;
    }

    public void setValidators(List<JWTClaimsSetValidator> validators) {
        this.validators.clear();
        if (validators != null) {
            for (JWTClaimsSetValidator validator : validators) {
                this.validators.add(validator);
            }
        }
    }

    public final List<JWTClaimsSetValidator> getValidators() {
        return Collections.unmodifiableList(this.validators);
    }

    public Mono<JWTEAuthentication<A>> authenticate(TokenCredentials credentials) {
        return ((JWEReader)this.jwtService.jweReader(this.type, this.keys).processedParameters(this.processedParameters)).read(credentials.getToken()).map(jwe -> {
            this.validators.forEach(((JWTClaimsSet)jwe.getPayload())::validate);
            return new JWTEAuthentication(jwe);
        }).onErrorResume(JOSEProcessingException.class, e -> Mono.just(new JWTEAuthentication((JOSEProcessingException)e)));
    }
}

