/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.jwt;

import io.inverno.mod.security.SecurityException;
import io.inverno.mod.security.authentication.InvalidCredentialsException;
import io.inverno.mod.security.authentication.TokenAuthentication;
import io.inverno.mod.security.jose.JOSEProcessingException;
import io.inverno.mod.security.jose.jwe.JWE;
import io.inverno.mod.security.jose.jwt.InvalidJWTException;
import io.inverno.mod.security.jose.jwt.JWTClaimsSet;
import java.util.Objects;
import java.util.Optional;

public class JWTEAuthentication<A extends JWTClaimsSet>
implements TokenAuthentication {
    private final JWE<A> jwt;
    private final Optional<SecurityException> cause;

    public JWTEAuthentication(JWE<A> jwt) {
        this.jwt = Objects.requireNonNull(jwt);
        this.cause = Optional.empty();
    }

    public JWTEAuthentication(SecurityException cause) {
        this.jwt = null;
        this.cause = Optional.ofNullable(cause);
    }

    JWTEAuthentication(JOSEProcessingException cause) {
        this.jwt = null;
        this.cause = Optional.ofNullable(cause).map(e -> new InvalidCredentialsException("Invalid token", (Throwable)e));
    }

    public JWE<A> getJwt() {
        return this.jwt;
    }

    public A getJWTClaimsSet() {
        return (A)(this.jwt != null ? (JWTClaimsSet)this.jwt.getPayload() : null);
    }

    public String getToken() {
        return this.jwt != null ? this.jwt.toCompact() : null;
    }

    public boolean isAuthenticated() {
        return this.jwt != null && ((JWTClaimsSet)this.jwt.getPayload()).isValid();
    }

    public Optional<SecurityException> getCause() {
        if (this.jwt != null) {
            try {
                ((JWTClaimsSet)this.jwt.getPayload()).ifInvalidThrow();
                return Optional.empty();
            }
            catch (InvalidJWTException e) {
                return Optional.of(new InvalidCredentialsException((Throwable)e));
            }
        }
        return this.cause;
    }
}

