/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.jws;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.inverno.mod.security.SecurityException;
import io.inverno.mod.security.authentication.Authentication;
import io.inverno.mod.security.authentication.InvalidCredentialsException;
import io.inverno.mod.security.authentication.TokenAuthentication;
import io.inverno.mod.security.jose.JOSEProcessingException;
import io.inverno.mod.security.jose.jws.JWS;
import java.util.Optional;

public class JWSAuthentication<A extends Authentication>
implements TokenAuthentication {
    private final JWS<A> jws;
    private final Optional<SecurityException> cause;

    public JWSAuthentication(JWS<A> jws) {
        this.jws = jws;
        this.cause = Optional.empty();
    }

    public JWSAuthentication(SecurityException cause) {
        this.jws = null;
        this.cause = Optional.ofNullable(cause);
    }

    JWSAuthentication(JOSEProcessingException cause) {
        this.jws = null;
        this.cause = Optional.ofNullable(cause).map(e -> new InvalidCredentialsException("Invalid token", (Throwable)e));
    }

    public JWS<A> getJws() {
        return this.jws;
    }

    @JsonProperty(value="token", access=JsonProperty.Access.READ_ONLY)
    public String getToken() {
        return this.jws != null ? this.jws.toCompact() : null;
    }

    public boolean isAuthenticated() {
        return this.jws != null && ((Authentication)this.jws.getPayload()).isAuthenticated();
    }

    public Optional<SecurityException> getCause() {
        if (this.jws != null) {
            return ((Authentication)this.jws.getPayload()).getCause();
        }
        return this.cause;
    }
}

