/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.jwk.rsa;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.inverno.mod.security.jose.jwk.X509JWK;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.List;

public interface RSAJWK
extends X509JWK<RSAPublicKey, RSAPrivateKey> {
    public static final String KEY_TYPE = "RSA";

    @JsonProperty(value="n")
    public String getModulus();

    @JsonProperty(value="e")
    public String getPublicExponent();

    @JsonProperty(value="d")
    public String getPrivateExponent();

    @JsonProperty(value="p")
    public String getFirstPrimeFactor();

    @JsonProperty(value="q")
    public String getSecondPrimeFactor();

    @JsonProperty(value="dp")
    public String getFirstFactorExponent();

    @JsonProperty(value="dq")
    public String getSecondFactorExponent();

    @JsonProperty(value="qi")
    public String getFirstCoefficient();

    @JsonProperty(value="oth")
    public List<OtherPrimeInfo> getOtherPrimesInfo();

    @Override
    public RSAJWK toPublicJWK();

    @Override
    public RSAJWK minify();

    @Override
    public RSAJWK trust();

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static interface OtherPrimeInfo {
        @JsonProperty(value="r")
        public String getPrimeFactor();

        @JsonProperty(value="d")
        public String getExponent();

        @JsonProperty(value="t")
        public String getCoefficient();
    }
}

