/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.jwk;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.inverno.mod.security.jose.jwk.AsymmetricJWK;
import java.net.URI;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Optional;

public interface X509JWK<A extends PublicKey, B extends PrivateKey>
extends AsymmetricJWK<A, B> {
    @JsonProperty(value="x5u")
    public URI getX509CertificateURL();

    @JsonProperty(value="x5c")
    public String[] getX509CertificateChain();

    @JsonProperty(value="x5t")
    public String getX509CertificateSHA1Thumbprint();

    @JsonProperty(value="x5t#S256")
    public String getX509CertificateSHA256Thumbprint();

    @JsonIgnore
    public Optional<X509Certificate> getX509Certificate();

    @Override
    public X509JWK<A, B> toPublicJWK();

    @Override
    public X509JWK<A, B> trust();
}

