/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.jwk;

import io.inverno.mod.security.jose.jwk.JWK;
import io.inverno.mod.security.jose.jwk.JWKStore;
import io.inverno.mod.security.jose.jwk.JWKStoreException;
import io.inverno.mod.security.jose.jwk.X509JWK;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import reactor.core.publisher.Mono;

public class InMemoryJWKStore
implements JWKStore {
    private Map<String, JWK> jwksByKid;
    private Map<String, JWK> jwksByX5t;
    private Map<String, JWK> jwksByX5t_S256;
    private Map<String, JWK> jwksByThumbprint;

    @Override
    public <T extends JWK> Mono<T> getByKeyId(String kid) throws JWKStoreException {
        if (this.jwksByKid != null && kid != null) {
            return Mono.fromSupplier(() -> this.jwksByKid.get(kid));
        }
        return Mono.empty();
    }

    @Override
    public <T extends JWK> Mono<T> getBy509CertificateSHA1Thumbprint(String x5t) throws JWKStoreException {
        if (this.jwksByX5t != null && x5t != null) {
            return Mono.fromSupplier(() -> this.jwksByX5t.get(x5t));
        }
        return Mono.empty();
    }

    @Override
    public <T extends JWK> Mono<T> getByX509CertificateSHA256Thumbprint(String x5t_S256) throws JWKStoreException {
        if (this.jwksByX5t_S256 != null && x5t_S256 != null) {
            return Mono.fromSupplier(() -> this.jwksByX5t_S256.get(x5t_S256));
        }
        return Mono.empty();
    }

    @Override
    public <T extends JWK> Mono<T> getByJWKThumbprint(String thumbprint) throws JWKStoreException {
        if (this.jwksByThumbprint != null && thumbprint != null) {
            return Mono.fromSupplier(() -> this.jwksByThumbprint.get(thumbprint));
        }
        return Mono.empty();
    }

    @Override
    public Mono<Void> set(JWK jwk) throws JWKStoreException {
        return Mono.fromRunnable(() -> {
            if (StringUtils.isNotBlank((CharSequence)jwk.getKeyId())) {
                if (this.jwksByKid == null) {
                    this.jwksByKid = new ConcurrentHashMap<String, JWK>();
                }
                this.jwksByKid.put(jwk.getKeyId(), jwk);
            }
            if (jwk instanceof X509JWK) {
                X509JWK x509JWK = (X509JWK)jwk;
                if (StringUtils.isNotBlank((CharSequence)x509JWK.getX509CertificateSHA1Thumbprint())) {
                    if (this.jwksByX5t == null) {
                        this.jwksByX5t = new ConcurrentHashMap<String, JWK>();
                    }
                    this.jwksByX5t.put(x509JWK.getX509CertificateSHA1Thumbprint(), x509JWK);
                }
                if (StringUtils.isNotBlank((CharSequence)x509JWK.getX509CertificateSHA256Thumbprint())) {
                    if (this.jwksByX5t_S256 == null) {
                        this.jwksByX5t_S256 = new ConcurrentHashMap<String, JWK>();
                    }
                    this.jwksByX5t_S256.put(x509JWK.getX509CertificateSHA256Thumbprint(), x509JWK);
                }
            }
            if (this.jwksByThumbprint == null) {
                this.jwksByThumbprint = new ConcurrentHashMap<String, JWK>();
            }
            this.jwksByThumbprint.put(jwk.toJWKThumbprint(JWK.DEFAULT_THUMBPRINT_DIGEST), jwk);
        });
    }

    @Override
    public Mono<Void> remove(JWK jwk) throws JWKStoreException {
        return Mono.fromRunnable(() -> {
            if (StringUtils.isNotBlank((CharSequence)jwk.getKeyId()) && this.jwksByKid != null) {
                this.jwksByKid.remove(jwk.getKeyId());
            }
            if (jwk instanceof X509JWK) {
                X509JWK x509JWK = (X509JWK)jwk;
                if (StringUtils.isNotBlank((CharSequence)x509JWK.getX509CertificateSHA1Thumbprint()) && this.jwksByX5t != null) {
                    this.jwksByX5t.remove(x509JWK.getX509CertificateSHA1Thumbprint());
                }
                if (StringUtils.isNotBlank((CharSequence)x509JWK.getX509CertificateSHA256Thumbprint()) && this.jwksByX5t_S256 != null) {
                    this.jwksByX5t_S256.remove(x509JWK.getX509CertificateSHA256Thumbprint());
                }
            }
            if (this.jwksByThumbprint != null) {
                this.jwksByThumbprint.remove(jwk.toJWKThumbprint(JWK.DEFAULT_THUMBPRINT_DIGEST));
            }
        });
    }
}

