/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.jwe;

import io.inverno.mod.security.jose.JOSEObjectBuildException;
import io.inverno.mod.security.jose.JOSEObjectReadException;
import io.inverno.mod.security.jose.JOSEProcessingException;
import io.inverno.mod.security.jose.JsonJOSEObject;
import io.inverno.mod.security.jose.jwe.JWE;
import io.inverno.mod.security.jose.jwe.JWEBuildException;
import io.inverno.mod.security.jose.jwe.JWEHeader;
import io.inverno.mod.security.jose.jwe.JWEReadException;
import io.inverno.mod.security.jose.jwk.JWK;
import java.util.List;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public interface JsonJWE<A, B extends Recipient<A>>
extends JsonJOSEObject<A> {
    public JWEHeader getProtectedHeader();

    public JWEHeader getUnprotectedHeader();

    public String getInitializationVector();

    public String getAdditionalAuthenticationData();

    public String getCipherText();

    public String getAuthenticationTag();

    public List<B> getRecipients();

    public static interface ReadRecipient<A>
    extends Recipient<A> {
        public Mono<JWE<A>> readJWE() throws JWEReadException, JWEBuildException, JOSEObjectReadException, JOSEObjectBuildException, JOSEProcessingException;

        public Mono<JWE<A>> readJWE(Publisher<? extends JWK> var1) throws JWEReadException, JWEBuildException, JOSEObjectReadException, JOSEObjectBuildException, JOSEProcessingException;
    }

    public static interface BuiltRecipient<A>
    extends Recipient<A> {
        public JWE<A> getJWE();

        @Override
        public int hashCode();

        @Override
        public boolean equals(Object var1);
    }

    public static interface Recipient<A> {
        public JWEHeader getHeader();

        public String getEncryptedKey();

        public int hashCode();

        public boolean equals(Object var1);
    }
}

