/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.jwe;

import io.inverno.mod.security.authentication.Authentication;
import io.inverno.mod.security.authentication.Authenticator;
import io.inverno.mod.security.authentication.TokenCredentials;
import io.inverno.mod.security.jose.JOSEProcessingException;
import io.inverno.mod.security.jose.jwe.JWEAuthentication;
import io.inverno.mod.security.jose.jwe.JWEReader;
import io.inverno.mod.security.jose.jwe.JWEService;
import io.inverno.mod.security.jose.jwk.JWK;
import java.lang.reflect.Type;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class JWEAuthenticator<A extends Authentication>
implements Authenticator<TokenCredentials, JWEAuthentication<A>> {
    private final JWEService jweService;
    private final Type authenticationType;
    private final Publisher<? extends JWK> keys;
    private final String[] processedParameters;

    public JWEAuthenticator(JWEService jweService, Class<A> authenticationType) {
        this(jweService, (Type)authenticationType, (Publisher<JWK>)((Publisher<? extends JWK>)((Publisher)null)), (String[])null);
    }

    public JWEAuthenticator(JWEService jweService, Type authenticationType) {
        this(jweService, authenticationType, (Publisher<? extends JWK>)((Publisher)null), (String[])null);
    }

    public JWEAuthenticator(JWEService jweService, Class<A> authenticationType, Publisher<? extends JWK> keys) {
        this(jweService, (Type)authenticationType, (Publisher<JWK>)keys, (String[])null);
    }

    public JWEAuthenticator(JWEService jweService, Type authenticationType, Publisher<? extends JWK> keys) {
        this(jweService, authenticationType, keys, (String[])null);
    }

    public JWEAuthenticator(JWEService jweService, Class<A> authenticationType, String ... processedParameters) {
        this(jweService, (Type)authenticationType, (Publisher<JWK>)((Publisher<? extends JWK>)((Publisher)null)), processedParameters);
    }

    public JWEAuthenticator(JWEService jweService, Type authenticationType, String ... processedParameters) {
        this(jweService, authenticationType, (Publisher<? extends JWK>)((Publisher)null), processedParameters);
    }

    public JWEAuthenticator(JWEService jweService, Class<A> authenticationType, Publisher<? extends JWK> keys, String ... processedParameters) {
        this(jweService, (Type)authenticationType, (Publisher<JWK>)keys, processedParameters);
    }

    public JWEAuthenticator(JWEService jweService, Type authenticationType, Publisher<? extends JWK> keys, String ... processedParameters) {
        this.jweService = jweService;
        this.keys = keys;
        this.authenticationType = authenticationType;
        this.processedParameters = processedParameters;
    }

    public Mono<JWEAuthentication<A>> authenticate(TokenCredentials credentials) {
        return ((JWEReader)this.jweService.reader(this.authenticationType, (Publisher)this.keys).processedParameters(this.processedParameters)).read(credentials.getToken(), "application/json").map(JWEAuthentication::new).onErrorResume(JOSEProcessingException.class, e -> Mono.just(new JWEAuthentication((JOSEProcessingException)e)));
    }
}

