/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.jwe;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.inverno.mod.security.SecurityException;
import io.inverno.mod.security.authentication.Authentication;
import io.inverno.mod.security.authentication.InvalidCredentialsException;
import io.inverno.mod.security.authentication.TokenAuthentication;
import io.inverno.mod.security.jose.JOSEProcessingException;
import io.inverno.mod.security.jose.jwe.JWE;
import java.util.Optional;

public class JWEAuthentication<A extends Authentication>
implements TokenAuthentication {
    private final JWE<A> jwe;
    private final Optional<SecurityException> cause;

    public JWEAuthentication(JWE<A> jwe) {
        this.jwe = jwe;
        this.cause = Optional.empty();
    }

    public JWEAuthentication(SecurityException cause) {
        this.jwe = null;
        this.cause = Optional.ofNullable(cause);
    }

    JWEAuthentication(JOSEProcessingException cause) {
        this.jwe = null;
        this.cause = Optional.ofNullable(cause).map(e -> new InvalidCredentialsException("Invalid token", (Throwable)e));
    }

    public JWE<A> getJwe() {
        return this.jwe;
    }

    @JsonProperty(value="token", access=JsonProperty.Access.READ_ONLY)
    public String getToken() {
        return this.jwe != null ? this.jwe.toCompact() : null;
    }

    public boolean isAuthenticated() {
        return this.jwe != null && ((Authentication)this.jwe.getPayload()).isAuthenticated();
    }

    public Optional<SecurityException> getCause() {
        if (this.jwe != null) {
            return ((Authentication)this.jwe.getPayload()).getCause();
        }
        return this.cause;
    }
}

