/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.jwa;

import io.inverno.mod.security.jose.internal.jwa.OKP_ECDH_ESKeyManager;
import io.inverno.mod.security.jose.internal.jwa.OKP_ECDH_ES_AESKWKeyManager;
import io.inverno.mod.security.jose.jwa.JWAAlgorithm;
import io.inverno.mod.security.jose.jwa.JWACipher;
import io.inverno.mod.security.jose.jwa.JWAKeyManager;
import io.inverno.mod.security.jose.jwa.JWAProcessingException;
import io.inverno.mod.security.jose.jwa.JWASigner;
import io.inverno.mod.security.jose.jwk.okp.XECJWK;
import java.util.Objects;
import java.util.function.BiFunction;

public enum XECAlgorithm implements JWAAlgorithm<XECJWK>
{
    ECDH_ES("ECDH-ES", null, XECAlgorithm::createOKP_ECDH_ESKeyManager, null, null),
    ECDH_ES_A128KW("ECDH-ES+A128KW", null, XECAlgorithm::createOKP_ECDH_ES_AESKWKeyManager, null, "A128KW"),
    ECDH_ES_A192KW("ECDH-ES+A192KW", null, XECAlgorithm::createOKP_ECDH_ES_AESKWKeyManager, null, "A192KW"),
    ECDH_ES_A256KW("ECDH-ES+A256KW", null, XECAlgorithm::createOKP_ECDH_ES_AESKWKeyManager, null, "A256KW");

    private final String alg;
    private final BiFunction<XECJWK, XECAlgorithm, JWASigner> signerFactory;
    private final BiFunction<XECJWK, XECAlgorithm, JWAKeyManager> keyManagerFactory;
    private final BiFunction<XECJWK, XECAlgorithm, JWACipher> cipherFactory;
    private final String keyWrappingAlgorithm;

    private XECAlgorithm(String alg, BiFunction<XECJWK, XECAlgorithm, JWASigner> signerFactory, BiFunction<XECJWK, XECAlgorithm, JWAKeyManager> keyManagerFactory, BiFunction<XECJWK, XECAlgorithm, JWACipher> cipherFactory, String keyWrappingAlgorithm) {
        this.alg = alg;
        this.signerFactory = signerFactory;
        this.keyManagerFactory = keyManagerFactory;
        this.cipherFactory = cipherFactory;
        this.keyWrappingAlgorithm = keyWrappingAlgorithm;
    }

    @Override
    public String getAlgorithm() {
        return this.alg;
    }

    @Override
    public boolean isSignature() {
        return this.signerFactory != null;
    }

    @Override
    public boolean isKeyManagement() {
        return this.keyManagerFactory != null;
    }

    @Override
    public boolean isEncryption() {
        return this.cipherFactory != null;
    }

    @Override
    public JWASigner createSigner(XECJWK jwk) throws JWAProcessingException {
        if (this.signerFactory == null) {
            throw new JWAProcessingException("Not a signature algorithm: " + this.alg);
        }
        return this.signerFactory.apply(jwk, this);
    }

    @Override
    public JWAKeyManager createKeyManager(XECJWK jwk) throws JWAProcessingException {
        if (this.keyManagerFactory == null) {
            throw new JWAProcessingException("Not a key management algorithm: " + this.alg);
        }
        return this.keyManagerFactory.apply(jwk, this);
    }

    @Override
    public JWACipher createCipher(XECJWK jwk) throws JWAProcessingException {
        if (this.cipherFactory == null) {
            throw new JWAProcessingException("Not an encryption algorithm: " + this.alg);
        }
        return this.cipherFactory.apply(jwk, this);
    }

    public String getKeyWrappingAlgorithm() {
        return this.keyWrappingAlgorithm;
    }

    public static XECAlgorithm fromAlgorithm(String alg) throws IllegalArgumentException {
        switch (alg) {
            case "ECDH-ES": {
                return ECDH_ES;
            }
            case "ECDH-ES+A128KW": {
                return ECDH_ES_A128KW;
            }
            case "ECDH-ES+A192KW": {
                return ECDH_ES_A192KW;
            }
            case "ECDH-ES+A256KW": {
                return ECDH_ES_A256KW;
            }
        }
        throw new IllegalArgumentException("Unknown OKP algorithm " + alg);
    }

    private static OKP_ECDH_ESKeyManager createOKP_ECDH_ESKeyManager(XECJWK jwk, XECAlgorithm algorithm) throws JWAProcessingException {
        XECAlgorithm xECAlgorithm = algorithm;
        Objects.requireNonNull(xECAlgorithm);
        return xECAlgorithm.new InnerOKP_ECDH_ESKeyManager(jwk);
    }

    private static OKP_ECDH_ES_AESKWKeyManager createOKP_ECDH_ES_AESKWKeyManager(XECJWK jwk, XECAlgorithm algorithm) throws JWAProcessingException {
        XECAlgorithm xECAlgorithm = algorithm;
        Objects.requireNonNull(xECAlgorithm);
        return xECAlgorithm.new InnerOKP_ECDH_ES_AESKWKeyManager(jwk);
    }

    private class InnerOKP_ECDH_ESKeyManager
    extends OKP_ECDH_ESKeyManager {
        InnerOKP_ECDH_ESKeyManager(XECJWK jwk) throws JWAProcessingException {
            super(jwk);
            this.algorithm = XECAlgorithm.this;
            this.init();
        }
    }

    private class InnerOKP_ECDH_ES_AESKWKeyManager
    extends OKP_ECDH_ES_AESKWKeyManager {
        InnerOKP_ECDH_ES_AESKWKeyManager(XECJWK jwk) throws JWAProcessingException {
            super(jwk);
            this.algorithm = XECAlgorithm.this;
            this.init();
        }
    }
}

